/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.database;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrationField {
    @NlsSafe
    private String myName;
    private String myDataType;
    private final List<SmartPsiElementPointer<?>> myDeclarations = new ArrayList();

    private MigrationField(@NonNls String name, @NonNls String dataType) {
        this.myName = name;
        this.myDataType = dataType;
    }

    public MigrationField(String name, @NonNls String dataType, PsiElement declaration) {
        this(name, dataType);
        this.addDeclaration(declaration);
    }

    @Nullable
    @NlsSafe
    public String getName() {
        return this.myName;
    }

    @Nullable
    @NlsSafe
    public String getDataType() {
        return this.myDataType;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setDataType(String dataType) {
        this.myDataType = dataType;
    }

    public void addDeclaration(PsiElement declaration) {
        this.myDeclarations.add(MigrationField.createPointerFor(declaration));
    }

    public static SmartPsiElementPointer<PsiElement> createPointerFor(@NotNull PsiElement declaration) {
        if (declaration == null) {
            MigrationField.$$$reportNull$$$0(0);
        }
        return SmartPointerManager.getInstance((Project)declaration.getProject()).createSmartPsiElementPointer(declaration);
    }

    @ApiStatus.Internal
    @Nullable
    public VirtualFile getVirtualFile() {
        for (SmartPsiElementPointer<?> declaration : this.myDeclarations) {
            VirtualFile file = declaration.getVirtualFile();
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @NotNull
    public List<PsiElement> getDeclarations() {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (SmartPsiElementPointer<?> pointer : this.myDeclarations) {
            PsiElement element = pointer.getElement();
            if (element == null) continue;
            result.add(element);
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            MigrationField.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public List<SmartPsiElementPointer<?>> getDeclarationPointers() {
        List<SmartPsiElementPointer<?>> list = Collections.unmodifiableList(this.myDeclarations);
        if (list == null) {
            MigrationField.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/database/MigrationField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/MigrationField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationPointers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPointerFor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

