/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.console;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.IrbUtil;
import org.jetbrains.plugins.ruby.console.SelectEnvironmentDialog;
import org.jetbrains.plugins.ruby.console.config.IrbConsoleType;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfigurationType;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.actions.RailsActionsUtil;
import org.jetbrains.plugins.ruby.rails.run.configuration.RailsRunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;

public class RunRailsConsoleAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunRailsConsoleAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunRailsConsoleAction.$$$reportNull$$$0(1);
        }
        RailsActionsUtil.setRailsActionVisibility(e.getDataContext(), e.getPresentation());
        e.getPresentation().setEnabled(RunRailsConsoleAction.isEnabled(RModuleUtil.getInstance().getModule(e.getDataContext())));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunRailsConsoleAction.$$$reportNull$$$0(2);
        }
        Module module = RModuleUtil.getInstance().getModule(e.getDataContext());
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        assert (sdk != null) : "SDK not found";
        assert (RailsUtil.hasRailsSupportInSDKOrModule(sdk, module)) : "No Rails support found";
        Ref environmentRef = new Ref();
        SelectEnvironmentDialog dialog = new SelectEnvironmentDialog((Ref<? super Pair<String, Boolean>>)environmentRef, module);
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return;
        }
        String consoleExecutablePath = RailsRunConfigurationUtil.getConsoleExecutablePath(module, (Boolean)((Pair)environmentRef.get()).second);
        assert (consoleExecutablePath != null) : "Executable not found";
        List<String> scriptArgs = RunRailsConsoleAction.getScriptArgs(consoleExecutablePath, (String)((Pair)environmentRef.get()).first);
        ReadAction.run(() -> {
            RunnerAndConfigurationSettings settings = IrbRunConfigurationType.getInstance().getFactory().createConfigurationSettings(module, RBundle.message((String)"rails.console", (Object[])new Object[]{module.getName()}), consoleExecutablePath, scriptArgs, IrbConsoleType.RAILS);
            RailsRunConfigurationUtil.setWorkingDirectory(module, (IrbRunConfiguration)settings.getConfiguration());
            RunManager runManager = RunManager.getInstance((Project)module.getProject());
            runManager.setTemporaryConfiguration(settings);
            RunConfigurationUtil.executeConfiguration(runManager, settings, null);
        });
    }

    private static boolean isEnabled(@Nullable Module module) {
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            return false;
        }
        ProgressManager.checkCanceled();
        if (!RailsUtil.hasRailsSupportInSDKOrModule(sdk, module)) {
            return false;
        }
        ProgressManager.checkCanceled();
        return RailsRunConfigurationUtil.getConsoleExecutable(module, false) != null;
    }

    @NotNull
    private static List<String> getScriptArgs(@NotNull String consoleExecutablePath, @Nullable String environment) {
        if (consoleExecutablePath == null) {
            RunRailsConsoleAction.$$$reportNull$$$0(3);
        }
        String exec = ContainerUtil.or(List.of("bin/rails", "zeus", "spring"), consoleExecutablePath::endsWith) ? "console" : "--irb=" + Objects.requireNonNull(IrbUtil.getDefaultExecutable(IrbConsoleType.IRB));
        List<String> list = environment == null ? List.of(exec) : List.of(exec, "-e", environment);
        if (list == null) {
            RunRailsConsoleAction.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/console/RunRailsConsoleAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleExecutablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/console/RunRailsConsoleAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptArgs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getScriptArgs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

