/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsCallTypeProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsSymbolTypes;
import org.jetbrains.plugins.ruby.rails.codeInsight.RenderCallIndex;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.HelperSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RSpecTestGenerator;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsClassModuleSymbol;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsBaseView;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsFileItem;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsLayout;
import org.jetbrains.plugins.ruby.rails.model.RailsLayoutOrView;
import org.jetbrains.plugins.ruby.rails.model.RailsMailer;
import org.jetbrains.plugins.ruby.rails.model.RailsPartialView;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyModificationTrackers;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RTypedSyntheticSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolWithImplicitMixins;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedPsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.TopLevelSymbolImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RCollectionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RDynamicType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyClassModuleNameIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public class ViewSymbol
extends TopLevelSymbolImpl
implements SymbolWithImplicitMixins,
RSpecTestGenerator {
    private static final String RSPEC_VIEW = "rspec:view";
    private static final FQN VIEW_FALLBACK_FQN = FQN.Builder.fromString((String)"View");
    @NotNull
    private final RailsBaseView myView;

    public ViewSymbol(@NotNull RailsBaseView view, RTopLevelContainer topLevelContainer) {
        if (view == null) {
            ViewSymbol.$$$reportNull$$$0(0);
        }
        super((PsiElement)topLevelContainer);
        this.myView = view;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        return this.myView.equals(((ViewSymbol)o).myView);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.myView.hashCode();
    }

    @Override
    public boolean processChildren(SymbolPsiProcessor processor, PsiElement invocationPoint) {
        if (!super.processChildren(processor, invocationPoint)) {
            return false;
        }
        if (!ViewSymbol.processSymbolsForViewOrLayout((Processor<? super Symbol>)processor, this.myView, (Symbol)this)) {
            return false;
        }
        return RailsClassModuleSymbol.processNamedRoutes((Processor<? super Symbol>)processor, (Symbol)this, this.myView.getApp());
    }

    @Override
    @NotNull
    public String getRSpecGeneratorName() {
        return RSPEC_VIEW;
    }

    @Override
    @Nullable
    public String getShortName(@NotNull PsiFile file) {
        RailsView view;
        if (file == null) {
            ViewSymbol.$$$reportNull$$$0(1);
        }
        return (view = RailsView.fromFile(file)) == null ? null : view.getName();
    }

    @Override
    @NotNull
    public FQN getFQN() {
        FQN fQN = VIEW_FALLBACK_FQN;
        if (fQN == null) {
            ViewSymbol.$$$reportNull$$$0(2);
        }
        return fQN;
    }

    private static boolean processSymbolsForViewOrLayout(Processor<? super Symbol> processor, RailsBaseView layoutOrView, Symbol symbol) {
        if (!ViewSymbol.processInstanceVarsFromController(layoutOrView, processor)) {
            return false;
        }
        if ((layoutOrView instanceof RailsPartialView || layoutOrView instanceof RailsLayoutOrView && ((RailsLayoutOrView)layoutOrView).isPartial()) && !ViewSymbol.processPartialLocals(layoutOrView, processor, symbol)) {
            return false;
        }
        if (layoutOrView instanceof RailsLayout || layoutOrView instanceof RailsPartialView && ((RailsPartialView)layoutOrView).isSharedPartialView()) {
            List instanceSymbols;
            Module module = ((RailsFileItem)((Object)layoutOrView)).getModule();
            Project project = module.getProject();
            List list = instanceSymbols = DumbService.isDumb((Project)project) ? ViewSymbol.getControllersInstanceVariables(module) : (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(ViewSymbol.getControllersInstanceVariables(module), RubyModificationTrackers.getModelModificationTrackers(project)));
            if (!ContainerUtil.process(instanceSymbols, processor)) {
                return false;
            }
        }
        if (layoutOrView.isRJS() && !ViewSymbol.addRJSSymbols(symbol, processor)) {
            return false;
        }
        if (layoutOrView.isBuilder() && !ViewSymbol.processBuilderSymbols(symbol, processor)) {
            return false;
        }
        if (layoutOrView.isJBuilder() && !ViewSymbol.processJBuilderSymbols(symbol, processor)) {
            return false;
        }
        return ViewSymbol.processSymbolsFromHelperCallsInController(symbol, layoutOrView.getViewOwner(), processor);
    }

    @NotNull
    private static List<Symbol> getControllersInstanceVariables(@NotNull Module module) {
        if (module == null) {
            ViewSymbol.$$$reportNull$$$0(3);
        }
        ArrayList<Symbol> allInstanceFieldChildren = new ArrayList<Symbol>();
        RailsController appController = RailsController.fromQualifiedName(module, "application");
        if (appController != null) {
            HashSet controllers = new HashSet();
            RubyOverrideImplementUtil.addDerivedClasses((RContainer)appController.getRClass(), controllers);
            for (RContainer clazz : controllers) {
                Symbol controllerSymbol;
                RailsController controller = clazz instanceof RClass ? RailsController.fromClass((RClass)clazz) : null;
                if (controller == null || (controllerSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)controller.getRClass())) == null) continue;
                List children = Symbol.getSymbolsByFilter((Symbol)controllerSymbol, (Predicate)Symbol.Filter.byType((Type)Type.INSTANCE_FIELD), (PsiElement)clazz);
                allInstanceFieldChildren.addAll(children);
            }
        }
        ArrayList<Symbol> arrayList = allInstanceFieldChildren;
        if (arrayList == null) {
            ViewSymbol.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static boolean processPartialLocals(RailsBaseView view, final Processor<? super Symbol> processor, final Symbol symbol) {
        String filename = view.getName();
        String name = filename.startsWith("_") ? filename.substring(1) : filename;
        PsiFile psiFile = view.getPsiFile();
        RTopLevelContainer topLevelContainer = ViewSymbol.getRubyTopLevelContainer(psiFile);
        if (topLevelContainer == null) {
            return false;
        }
        final RailsApp app = view.getApp();
        if (!processor.process(new PartialLocalSymbol<RTopLevelContainer>(topLevelContainer, name, symbol, app))) {
            return false;
        }
        ViewSymbol.iteratePartialUsages(app, topLevelContainer.getContainingFile(), (Processor<? super RPossibleCall>)new Processor<RPossibleCall>(){

            public boolean process(RPossibleCall call) {
                return this.findLocalArguments(call.getArguments());
            }

            private boolean findLocalArguments(List<RPsiElement> arguments) {
                for (RPsiElement element : arguments) {
                    if (element instanceof RAssocList) {
                        if (this.findLocalArguments(((RAssocList)element).getElements())) continue;
                        return false;
                    }
                    if (!(element instanceof RAssoc)) continue;
                    RAssoc assoc = (RAssoc)element;
                    String key = assoc.getKeyText();
                    RPsiElement value = assoc.getValue();
                    if ("as".equals(key) && (value instanceof RStringLiteral || value instanceof RSymbol)) {
                        String content = value instanceof RStringLiteral ? ((RStringLiteral)value).getContent() : ((RSymbol)value).getValue();
                        if (processor.process(new PartialLocalSymbol<RPsiElement>(value, content, symbol, app))) continue;
                        return false;
                    }
                    if (!"locals".equals(key) || !(value instanceof RAssocList)) continue;
                    for (RAssoc pair : ((RAssocList)value).getAssocElements()) {
                        String name = pair.getKeyText();
                        if (processor.process(new PartialLocalSymbol<RPsiElement>(pair.getKey(), name, symbol, app))) continue;
                        return false;
                    }
                }
                return true;
            }
        });
        return true;
    }

    @Nullable
    private static RTopLevelContainer getRubyTopLevelContainer(PsiFile psiFile) {
        RTopLevelContainer topLevelContainer;
        RTopLevelContainer rTopLevelContainer = topLevelContainer = psiFile != null ? (RTopLevelContainer)psiFile.getViewProvider().getPsi((Language)RubyLanguage.INSTANCE) : null;
        if (topLevelContainer == null && psiFile != null) {
            for (PsiElement element : psiFile.getChildren()) {
                if (!(element instanceof RTopLevelContainer)) continue;
                topLevelContainer = (RTopLevelContainer)element;
                break;
            }
        }
        return topLevelContainer;
    }

    private static boolean processInstanceVarsFromController(RailsBaseView view, Processor<? super Symbol> processor) {
        RailsViewOwner controller = view.getViewOwner();
        return ViewSymbol.processInstanceVarsFromController(processor, controller, (PsiElement)view.getPsiFile());
    }

    public static boolean processInstanceVarsFromController(Processor<? super Symbol> processor, RailsViewOwner controller, PsiElement invocationPoint) {
        Symbol symbol;
        Symbol symbol2 = symbol = controller != null ? SymbolUtil.getSymbolByContainer((RElementWithFQN)controller.getRClass()) : null;
        if (symbol != null) {
            List children = Symbol.getSymbolsByFilter((Symbol)symbol, (Predicate)Symbol.Filter.byType((Type)Type.INSTANCE_FIELD), (PsiElement)invocationPoint);
            return ContainerUtil.process((List)children, processor);
        }
        return true;
    }

    private static boolean addRJSSymbols(Symbol root, Processor<? super Symbol> processor) {
        return processor.process((Object)new RTypedSyntheticSymbol(root.getProject(), "page", Type.FIELD_READER, root, (RType)REmptyType.INSTANCE, Collections.emptyList()));
    }

    private static boolean processBuilderSymbols(Symbol root, Processor<? super Symbol> processor) {
        Symbol xmlMarkupClass = SymbolUtil.findConstantByFQN(root.getProject(), Type.CLASS, "Builder::XmlMarkup", null);
        if (xmlMarkupClass != null) {
            RDynamicType type = RTypeUtil.createDynamicType(xmlMarkupClass);
            RTypedSyntheticSymbol symbol = new RTypedSyntheticSymbol(root.getProject(), "xml", Type.FIELD_READER, root, (RType)type, Collections.emptyList());
            return processor.process((Object)symbol);
        }
        return true;
    }

    private static boolean processJBuilderSymbols(@NotNull Symbol root, @NotNull Processor<? super Symbol> processor) {
        Symbol jbuilderClass;
        if (root == null) {
            ViewSymbol.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            ViewSymbol.$$$reportNull$$$0(6);
        }
        if ((jbuilderClass = SymbolUtil.findConstantByFQN(root.getProject(), Type.CLASS, "JbuilderTemplate", null)) != null) {
            RDynamicType type = RTypeUtil.createDynamicType(jbuilderClass);
            RTypedSyntheticSymbol symbol = new RTypedSyntheticSymbol(root.getProject(), "json", Type.FIELD_READER, root, (RType)type, Collections.emptyList());
            return processor.process((Object)symbol);
        }
        return true;
    }

    private static boolean processSymbolsFromHelperCallsInController(Symbol classSymbol, RailsViewOwner controller, Processor<? super Symbol> processor) {
        RClass controllerClass = controller != null ? controller.getRClass() : null;
        HashSet<RClass> processed = new HashSet<RClass>();
        while (controllerClass != null && !ViewSymbol.shouldStopLookingForHelpers(controllerClass, processed)) {
            processed.add(controllerClass);
            if (!ViewSymbol.processSymbolsFromHelperMethodCalls(processor, classSymbol, controllerClass)) {
                return false;
            }
            List<RClass> classes = RubyClassResolveUtil.resolveSuperClass(controllerClass, (PsiElement)controllerClass);
            if (classes.isEmpty()) continue;
            controllerClass = classes.get(0);
        }
        return true;
    }

    private static boolean processSymbolsFromHelperMethodCalls(Processor<? super Symbol> processor, Symbol root, RClass controllerClass) {
        Symbol controllerSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)controllerClass);
        if (controllerSymbol == null) {
            return true;
        }
        List helperMethods = Symbol.getSymbolsByFilter((Symbol)controllerSymbol, (Predicate)Symbol.Filter.byType((Type)RailsSymbolTypes.HELPER_METHOD_SYMBOL), (PsiElement)controllerClass);
        for (Symbol helperMethod : helperMethods) {
            PsiElement declaration;
            Symbol methodSymbol;
            String name = helperMethod.getName();
            if (name == null || (methodSymbol = SymbolUtil.findSymbolInHierarchy(controllerSymbol, name, Type.INSTANCE_METHOD.asSet(), null)) == null || (declaration = methodSymbol.getPsiElement()) == null || processor.process(new PsiElementSymbol<PsiElement>(declaration, name, Type.INSTANCE_METHOD, root))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Collection<Symbol> getImplicitSuperClasses() {
        List<Symbol> list = Collections.emptyList();
        if (list == null) {
            ViewSymbol.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public Collection<Symbol> getImplicitExtends() {
        List<Symbol> list = Collections.emptyList();
        if (list == null) {
            ViewSymbol.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public Collection<Symbol> getImplicitIncludes() {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        ViewSymbol.addViewImplicitIncludes(this.getProject(), result, this.myView);
        ArrayList<Symbol> arrayList = result;
        if (arrayList == null) {
            ViewSymbol.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static void addViewImplicitIncludes(Project project, Collection<? super Symbol> includes, RailsBaseView layoutOrView) {
        PsiFile invocationPoint = layoutOrView.getPsiFile();
        if (!layoutOrView.isRJS() && !layoutOrView.isBuilder()) {
            includes.add((Symbol)SymbolUtil.findConstantByFQN(project, Type.CLASS, "ActionView::Base", (PsiElement)invocationPoint));
        }
        ViewSymbol.addIncludesForHelperCalls(includes, layoutOrView);
        RailsApp app = layoutOrView.getApp();
        for (RailsHelper helper : (List)app.getAllHelpers().second) {
            if (helper == null) continue;
            ViewSymbol.importHelper(includes, helper);
        }
        includes.addAll(HelperSymbol.findBuiltInHelperModules(project, (PsiElement)invocationPoint));
        RailsClassModuleSymbol.includeRailsModule(project, includes);
    }

    private static void addIncludesForHelperCalls(Collection<? super Symbol> includes, RailsBaseView layoutOrView) {
        RailsViewOwner controller = layoutOrView.getViewOwner();
        RClass controllerClass = controller != null ? controller.getRClass() : null;
        HashSet<RClass> processed = new HashSet<RClass>();
        while (controllerClass != null && !ViewSymbol.shouldStopLookingForHelpers(controllerClass, processed)) {
            List structureElements = controllerClass.getStructureElements();
            for (RPsiStructureElement structureElement : structureElements) {
                RubyCallType callType;
                if (!(structureElement instanceof RCall) || (callType = ((RCall)structureElement).getCallType()) != RailsCallTypeProvider.HELPER_CALL) continue;
                ViewSymbol.addIncludesForHelperCall(includes, (RCall)structureElement);
            }
            processed.add(controllerClass);
            List<RClass> classes = RubyClassResolveUtil.resolveSuperClass(controllerClass, (PsiElement)controllerClass);
            if (classes.isEmpty()) continue;
            controllerClass = classes.get(0);
        }
    }

    private static boolean shouldStopLookingForHelpers(RClass controllerClass, Set<RClass> processed) {
        return processed.contains(controllerClass) || ModuleUtilCore.findModuleForPsiElement((PsiElement)controllerClass) == null;
    }

    public static void importHelper(Collection<? super Symbol> result, @NotNull RailsHelper helper) {
        if (helper == null) {
            ViewSymbol.$$$reportNull$$$0(10);
        }
        result.add((Symbol)SymbolUtil.findConstantByFQN(helper.getRModule().getProject(), Type.MODULE, helper.getModuleName(), null));
    }

    private static void addIncludesForHelperCall(Collection<? super Symbol> includes, RCall call) {
        RailsApp app = RailsApp.fromPsiElement((PsiElement)call);
        if (app == null || !app.isInAppFile((PsiElement)call)) {
            return;
        }
        List args = (List)call.getData(new RubyCallType[]{RailsCallTypeProvider.HELPER_CALL});
        for (FQN arg : args) {
            RFile file;
            String helperCandidate = arg.getShortName();
            if (NamingConventions.isInUnderscoredCaseExt((String)helperCandidate)) {
                if (helperCandidate.equals("all")) {
                    for (RailsHelper helper : (List)app.getAllHelpers().second) {
                        ViewSymbol.importHelper(includes, helper);
                    }
                    continue;
                }
                RailsHelper helper = app.findHelper(helperCandidate);
                if (helper == null) continue;
                ViewSymbol.importHelper(includes, helper);
                continue;
            }
            if (!NamingConventions.isInCamelCase((String)helperCandidate) || (file = ViewSymbol.findHelperModule(app, arg)) == null) continue;
            Collection elements = (Collection)ReadAction.compute(() -> RubyClassModuleNameIndex.getInstance().getAllElements(app.getModule().getProject(), (SearchScope)GlobalSearchScope.fileScope((PsiFile)file)));
            for (RElementWithFQN element : elements) {
                ContainerUtil.addIfNotNull(includes, (Object)SymbolUtil.getSymbolByContainer(element));
            }
        }
    }

    @Nullable
    private static RFile findHelperModule(RailsApp app, FQN fqn) {
        HashSet filesVisited = new HashSet();
        @NonNls String helperFileRelativePath = NamingConventions.toUnderscoreCase((String)fqn.getFullPath(), (Module)app.getModule()) + ".rb";
        RFile file = ViewSymbol.fromFile(app, app.getPaths().findFiles("lib"), helperFileRelativePath, filesVisited);
        if (file != null) {
            return file;
        }
        List plugins = ContainerUtil.sorted((Collection)ContainerUtil.flatMap(app.getPaths().findFiles("vendor", "plugins"), it -> List.of(it.getChildren())), (Comparator)new VirtualFileUtil.VirtualFilesComparator());
        for (VirtualFile plugin : plugins) {
            file = ViewSymbol.fromFile(app, ContainerUtil.createMaybeSingletonList((Object)plugin.findChild("lib")), helperFileRelativePath, filesVisited);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @Nullable
    private static RFile fromFile(@NotNull RailsApp app, @NotNull List<VirtualFile> roots, @NotNull String relativePath, @NotNull Set<? super String> filesVisited) {
        if (app == null) {
            ViewSymbol.$$$reportNull$$$0(11);
        }
        if (roots == null) {
            ViewSymbol.$$$reportNull$$$0(12);
        }
        if (relativePath == null) {
            ViewSymbol.$$$reportNull$$$0(13);
        }
        if (filesVisited == null) {
            ViewSymbol.$$$reportNull$$$0(14);
        }
        Project project = app.getModule().getProject();
        if (roots.isEmpty() || filesVisited.contains(relativePath)) {
            return null;
        }
        for (VirtualFile root : roots) {
            VirtualFile virtualFile = root.findFileByRelativePath(relativePath);
            if (virtualFile == null) continue;
            filesVisited.add(relativePath);
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (!(psiFile instanceof RFile)) continue;
            RFile file = (RFile)psiFile;
            return file;
        }
        return null;
    }

    @Override
    @NotNull
    public String toString() {
        String string = "%s{myView=%s, myVirtualFile=%s, myType=%s}".formatted(this.getClass().getSimpleName(), this.myView, RubyPsiUtil.getVirtualFileFromElement(this.getPsiElement()), this.myType);
        if (string == null) {
            ViewSymbol.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static boolean iteratePartialUsages(RailsApp app, PsiFile viewFile, Processor<? super RPossibleCall> processor) {
        Project project = viewFile.getProject();
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)project);
        VirtualFile virtualFile = viewFile.getVirtualFile();
        VirtualFile viewFolder = virtualFile != null ? virtualFile.getParent() : null;
        List<VirtualFile> viewsRoots = app.getPaths().findFiles("app/views");
        if (viewsRoots.isEmpty() || viewFolder == null) {
            return true;
        }
        String viewName = ViewsConventions.getViewOrLayoutNameByFileName(viewFile.getName());
        String viewFullName = app.getPaths().getRelativePath("app/views", viewFolder.getUrl()) + "/" + viewName;
        ArrayList renders = new ArrayList();
        renders.addAll((Collection)ReadAction.compute(() -> RenderCallIndex.getInstance().getElements(project, (SearchScope)searchScope, viewName)));
        renders.addAll((Collection)ReadAction.compute(() -> RenderCallIndex.getInstance().getElements(project, (SearchScope)searchScope, viewFullName)));
        for (RPossibleCall render : renders) {
            if (!ViewSymbol.isMyRender(viewsRoots, virtualFile, render) || processor.process((Object)render)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMyRender(@NotNull List<VirtualFile> viewsRoots, @NotNull VirtualFile view, @NotNull RPossibleCall render) {
        if (viewsRoots == null) {
            ViewSymbol.$$$reportNull$$$0(16);
        }
        if (view == null) {
            ViewSymbol.$$$reportNull$$$0(17);
        }
        if (render == null) {
            ViewSymbol.$$$reportNull$$$0(18);
        }
        PsiFile renderer = render.getContainingFile();
        VirtualFile rendererFile = renderer.getVirtualFile();
        VirtualFile viewFolder = view.getParent();
        if (rendererFile == null) {
            return false;
        }
        for (String s : (List)render.getData(new RubyCallType[]{RailsCallTypeProvider.RENDER_CALL})) {
            if (s == null) continue;
            if (s.contains("/")) {
                return true;
            }
            if (VfsUtilCore.isUnderFiles((VirtualFile)rendererFile, viewsRoots)) {
                return Comparing.equal((Object)viewFolder, (Object)rendererFile.getParent());
            }
            RailsController controller = RailsController.fromFile(renderer);
            if (controller != null) {
                return controller.getViewsFolders().contains(viewFolder);
            }
            RailsMailer mailer = RailsMailer.fromFile(ModuleUtilCore.findModuleForPsiElement((PsiElement)render), rendererFile);
            if (mailer == null || viewFolder == null) continue;
            return mailer.getTemplatesFolders().contains(viewFolder);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 7, 8, 9, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/ViewSymbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesVisited";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewsRoots";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "render";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/ViewSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllersInstanceVariables";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitSuperClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitExtends";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitIncludes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getControllersInstanceVariables";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processJBuilderSymbols";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "importHelper";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fromFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isMyRender";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 7, 8, 9, 15 -> new IllegalStateException(string);
        };
    }

    private static class PartialLocalSymbol<T extends RPsiElement>
    extends TypedPsiElementSymbol<T> {
        private final RailsApp myApp;

        PartialLocalSymbol(T element, String name, Symbol symbol, RailsApp app) {
            super(element, name, Type.FIELD_READER, symbol);
            this.myApp = app;
        }

        @NotNull
        public RType getType(@NotNull Context context) {
            if (context == null) {
                PartialLocalSymbol.$$$reportNull$$$0(0);
            }
            Ref typeRef = Ref.create((Object)REmptyType.INSTANCE);
            if (this.isImplicit()) {
                ViewSymbol.iteratePartialUsages(this.myApp, (PsiFile)this.myPsiElement, (Processor<? super RPossibleCall>)((Processor)call -> PartialLocalSymbol.findTypeForCall(call, (Ref<? super RType>)typeRef)));
                RType rType = (RType)typeRef.get();
                if (rType == null) {
                    PartialLocalSymbol.$$$reportNull$$$0(1);
                }
                return rType;
            }
            PsiElement parent = ((RPsiElement)this.myPsiElement).getParent();
            if (parent instanceof RAssoc) {
                RType result;
                RAssoc assoc = (RAssoc)parent;
                if ("as".equals(assoc.getKeyText())) {
                    PartialLocalSymbol.findTypeForCall((RPossibleCall)RubyPsiUtil.getCoveringRCall((PsiElement)assoc), (Ref<? super RType>)typeRef);
                    RType rType = (RType)typeRef.get();
                    if (rType == null) {
                        PartialLocalSymbol.$$$reportNull$$$0(2);
                    }
                    return rType;
                }
                RPsiElement value = assoc.getValue();
                if (value instanceof RExpression && (result = (RType)RecursionManager.doPreventingRecursion((Object)value, (boolean)true, () -> RTypeUtil.getType((PsiElement)value))) != null) {
                    RType rType = result;
                    if (rType == null) {
                        PartialLocalSymbol.$$$reportNull$$$0(3);
                    }
                    return rType;
                }
            }
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                PartialLocalSymbol.$$$reportNull$$$0(4);
            }
            return rEmptyType;
        }

        private boolean isImplicit() {
            return this.myPsiElement instanceof PsiFile;
        }

        private static boolean findTypeForCall(RPossibleCall call, Ref<? super RType> typeRef) {
            if (call == null) {
                return true;
            }
            List arguments = call.getArguments();
            RPsiElement first = (RPsiElement)ContainerUtil.getFirstItem((List)arguments);
            if (first instanceof RInstanceVariable) {
                return PartialLocalSymbol.getAndSetType(first, true, typeRef);
            }
            return PartialLocalSymbol.findType(arguments, typeRef);
        }

        private static boolean getAndSetType(RPsiElement first, boolean unwrapCollection, Ref<? super RType> typeRef) {
            RType type = RTypeUtil.getType((PsiElement)first);
            type = unwrapCollection && type instanceof RCollectionType ? (RType)((RCollectionType)type).getIndexType() : type;
            typeRef.set((Object)type);
            return type != REmptyType.INSTANCE;
        }

        private static boolean findType(List<? extends RPsiElement> arguments, Ref<? super RType> typeRef) {
            for (RPsiElement rPsiElement : arguments) {
                if (rPsiElement instanceof RAssocList) {
                    if (PartialLocalSymbol.findType(((RAssocList)rPsiElement).getElements(), typeRef)) continue;
                    return false;
                }
                if (!(rPsiElement instanceof RAssoc)) continue;
                String key = ((RAssoc)rPsiElement).getKeyText();
                RPsiElement value = ((RAssoc)rPsiElement).getValue();
                if (!(value instanceof RExpression)) continue;
                if ("object".equals(key)) {
                    return PartialLocalSymbol.getAndSetType(value, false, typeRef);
                }
                if (!"collection".equals(key)) continue;
                return PartialLocalSymbol.getAndSetType(value, true, typeRef);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/ViewSymbol$PartialLocalSymbol";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/ViewSymbol$PartialLocalSymbol";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

