/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ImplicitSymbolHierarchy;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolInheritanceInfo;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolContainerUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;

public final class ImplicitModuleSymbol
extends SymbolImpl {
    @NotNull
    private final FQN myFqn;
    @NotNull
    private final Module myModule;

    public ImplicitModuleSymbol(@NotNull Module module, @NotNull FQN fqn) {
        if (module == null) {
            ImplicitModuleSymbol.$$$reportNull$$$0(0);
        }
        if (fqn == null) {
            ImplicitModuleSymbol.$$$reportNull$$$0(1);
        }
        super(module.getProject(), fqn.getShortName(), Type.MODULE, null);
        this.myModule = module;
        this.myFqn = fqn;
    }

    @NotNull
    public FQN getFQNWithNesting() {
        FQN fQN = this.myFqn;
        if (fQN == null) {
            ImplicitModuleSymbol.$$$reportNull$$$0(2);
        }
        return fQN;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ImplicitModuleSymbol.$$$reportNull$$$0(3);
        }
        return module;
    }

    @NotNull
    public Symbol getSingletonClassSymbol() {
        Symbol symbol = SymbolContainerUtil.getSingletonClassSymbol((Symbol)this);
        if (symbol == null) {
            ImplicitModuleSymbol.$$$reportNull$$$0(4);
        }
        return symbol;
    }

    @NotNull
    public SymbolInheritanceInfo getInheritanceInfo(@Nullable PsiElement invocationPoint) {
        SymbolInheritanceInfo symbolInheritanceInfo = SymbolContainerUtil.getSymbolInheritanceInfo((Symbol)this, invocationPoint);
        if (symbolInheritanceInfo == null) {
            ImplicitModuleSymbol.$$$reportNull$$$0(5);
        }
        return symbolInheritanceInfo;
    }

    public boolean isSynthetic() {
        return true;
    }

    public boolean processChildren(@NotNull SymbolPsiProcessor processor, PsiElement invocationPoint) {
        if (processor == null) {
            ImplicitModuleSymbol.$$$reportNull$$$0(6);
        }
        return this.processContainerDeclarations(processor, invocationPoint) && this.processImplicitSymbolChildren(processor, invocationPoint);
    }

    private boolean processContainerDeclarations(@NotNull SymbolPsiProcessor processor, PsiElement invocationPoint) {
        if (processor == null) {
            ImplicitModuleSymbol.$$$reportNull$$$0(7);
        }
        return SymbolContainerUtil.processOwnChildren(processor, (Symbol)this, this.myFqn, invocationPoint);
    }

    private boolean processImplicitSymbolChildren(@NotNull SymbolPsiProcessor processor, PsiElement invocationPoint) {
        RailsApp railsApp;
        if (processor == null) {
            ImplicitModuleSymbol.$$$reportNull$$$0(8);
        }
        if ((railsApp = RailsApp.fromModule(this.myModule)) == null) {
            return true;
        }
        ImplicitSymbolHierarchy hierarchy = railsApp.getImplicitSymbolHierarchy();
        for (FQN childrenFQN : hierarchy.getChildren(this.myFqn)) {
            Symbol symbol = SymbolUtil.lookupSymbolInHierarchy((Symbol)this, childrenFQN.getShortName(), Types.MODULE_OR_CLASS, invocationPoint);
            if (symbol == null || processor.process(symbol)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/ImplicitModuleSymbol";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/ImplicitModuleSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQNWithNesting";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingletonClassSymbol";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritanceInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processContainerDeclarations";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitSymbolChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

