/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RSpecTestGenerator;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsClassModuleSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.TestUnitGenerator;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ViewSymbol;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class HelperSymbol
extends RailsClassModuleSymbol
implements RSpecTestGenerator,
TestUnitGenerator {
    private static final String RSPEC_HELPER = "rspec:helper";
    private static final String TEST_UNIT_HELPER = "test_unit:helper";

    public HelperSymbol(RailsApp app, RModule rModule) {
        super(app, (RContainer)rModule);
    }

    @Override
    @NotNull
    public Collection<Symbol> getImplicitIncludes() {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        if (!"ApplicationHelper".equals(this.getName())) {
            result.add(SymbolUtil.findConstantByFQN(this.getProject(), Type.MODULE, FQN.of((String)"ApplicationHelper"), null));
        }
        result.addAll(HelperSymbol.findBuiltInHelperModules(this.getProject(), null));
        ArrayList<Symbol> arrayList = result;
        if (arrayList == null) {
            HelperSymbol.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getRSpecGeneratorName() {
        return RSPEC_HELPER;
    }

    @Override
    @Nullable
    public String getShortName(@NotNull PsiFile file) {
        RailsHelper helper;
        if (file == null) {
            HelperSymbol.$$$reportNull$$$0(1);
        }
        return (helper = RailsHelper.fromFile(file)) == null ? null : helper.getRModule().getQualifiedName();
    }

    @Override
    @NotNull
    public String getTestUnitGeneratorName() {
        return TEST_UNIT_HELPER;
    }

    @NotNull
    public static List<Symbol> findBuiltInHelperModules(Project project, @Nullable PsiElement invocationPoint) {
        Symbol helpersModule = SymbolUtil.findConstantByFQN(project, Type.MODULE, FQN.of((String)"ActionView::Helpers"), invocationPoint);
        return helpersModule == null ? Collections.emptyList() : HelperSymbol.findHelperModules(helpersModule, invocationPoint);
    }

    @NotNull
    public static List<Symbol> findHelperModules(@NotNull Symbol anchor, @Nullable PsiElement invocationPoint) {
        if (anchor == null) {
            HelperSymbol.$$$reportNull$$$0(2);
        }
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (Symbol module : Symbol.getSymbolsByFilter((Symbol)anchor, (Predicate)Symbol.Filter.byType((Type)Type.MODULE), (PsiElement)invocationPoint)) {
            String name = module.getName();
            if (name == null || !name.endsWith("Helper")) continue;
            result.add(module);
        }
        ArrayList<Symbol> arrayList = result;
        if (arrayList == null) {
            HelperSymbol.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    public boolean processChildren(SymbolPsiProcessor processor, PsiElement invocationPoint) {
        if (!super.processChildren(processor, invocationPoint)) {
            return false;
        }
        RailsHelper helper = RailsHelper.fromModule((RModule)this.getPsiElement());
        return helper == null || ViewSymbol.processInstanceVarsFromController((Processor<? super Symbol>)processor, helper.getController(), this.getPsiElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/HelperSymbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitIncludes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/HelperSymbol";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findHelperModules";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findHelperModules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

