/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.MinitestGenerator;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RSpecTestGenerator;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsClassModuleSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.TestUnitGenerator;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public class ControllerSymbol
extends RailsClassModuleSymbol
implements RSpecTestGenerator,
TestUnitGenerator,
MinitestGenerator {
    public static final String CONTROLLER_NAME = "controller";
    private static final String RSPEC_CONTROLLER = "rspec:controller";
    private static final String TEST_UNIT_CONTROLLER = "test_unit:controller";
    private static final String MINITEST_CONTROLLER = "controller";
    private static final PsiFileGist<List<FQN>> INCLUDES_GIST = GistManager.getInstance().newPsiFileGist("RAILS_INCLUDES", 1, (DataExternalizer)FQNsExternalizer.INSTANCE, (NullableFunction)((NotNullFunction)dom -> ControllerSymbol.calcModulesForClassInFile(dom)));

    public ControllerSymbol(RailsApp app, RClass rClass) {
        super(app, (RContainer)rClass);
    }

    @Override
    @NotNull
    public Collection<Symbol> getImplicitIncludes() {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        ControllerSymbol.addControllerModules(this.getProject(), result);
        ArrayList<Symbol> arrayList = result;
        if (arrayList == null) {
            ControllerSymbol.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static void addControllerModules(Project project, Collection<Symbol> result) {
        ControllerSymbol.includeRailsModule(project, result);
        Symbol base = SymbolUtil.findConstantByFQN(project, Type.CLASS, RailsFqns.ACTION_CONTROLLER_BASE, null);
        if (base != null) {
            for (PsiElement declaration : base.getAllDeclarations(null)) {
                if (!(declaration instanceof RContainer)) continue;
                RContainer container = (RContainer)declaration;
                Symbol goodSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)container);
                PsiFile file = declaration.getContainingFile();
                if (file == null || goodSymbol == null) continue;
                for (FQN fqn : (List)INCLUDES_GIST.getFileData(file)) {
                    result.add(SymbolUtil.lookupConstant(goodSymbol, (PsiElement)container, fqn, Type.MODULE.asSet(), declaration));
                }
            }
        }
    }

    @Override
    @NotNull
    public Collection<Symbol> getImplicitExtends() {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        ControllerSymbol.includeRailsModule(this.getProject(), result);
        ArrayList<Symbol> arrayList = result;
        if (arrayList == null) {
            ControllerSymbol.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getRSpecGeneratorName() {
        return RSPEC_CONTROLLER;
    }

    @Override
    @NotNull
    public String getTestUnitGeneratorName() {
        return TEST_UNIT_CONTROLLER;
    }

    @Override
    @NotNull
    public String getMinitestGeneratorName() {
        return "controller";
    }

    @Override
    @Nullable
    public String getShortName(@NotNull PsiFile file) {
        RailsController controller;
        if (file == null) {
            ControllerSymbol.$$$reportNull$$$0(2);
        }
        return (controller = RailsController.fromFile(file)) == null ? null : RubyClassResolveUtil.getQualifiedName(controller.getRClass());
    }

    @TestOnly
    public static void initGistForProject(@NotNull Project project) {
        Symbol base;
        PsiElement basePsi;
        if (project == null) {
            ControllerSymbol.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = basePsi = (base = SymbolUtil.findConstantByFQN(project, Type.CLASS, RailsFqns.ACTION_CONTROLLER_BASE, null)) != null ? base.getPsiElement() : null;
        if (basePsi == null) {
            return;
        }
        INCLUDES_GIST.getFileData(basePsi.getContainingFile());
    }

    @NotNull
    private static List<FQN> calcModulesForClassInFile(PsiFile dom) {
        final ArrayList<FQN> result = new ArrayList<FQN>();
        dom.acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRConstant(@NotNull RConstant rConstant) {
                RPsiElement value;
                if (rConstant == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!rConstant.isDeclaration() || !"MODULES".equals(rConstant.getName())) {
                    return;
                }
                RClass clazz = RubyPsiUtil.getContainingRClass((PsiElement)rConstant);
                if (clazz == null || !clazz.getFQNWithNesting().equals((Object)RailsFqns.ACTION_CONTROLLER_BASE)) {
                    return;
                }
                PsiElement parent = rConstant.getParent();
                RPsiElement rPsiElement = value = parent instanceof RAssignmentExpression ? ((RAssignmentExpression)parent).getValue() : null;
                if (value instanceof RArray) {
                    RArray array = (RArray)value;
                    for (RPsiElement element : array.getElements()) {
                        if (!(element instanceof RColonReference) && !(element instanceof RConstant) && !(element instanceof RTopConstReference)) continue;
                        result.add(FQN.Builder.fromString((String)element.getText()));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rConstant", "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/ControllerSymbol$1", "visitRConstant"));
            }
        });
        ArrayList<FQN> arrayList = result;
        if (arrayList == null) {
            ControllerSymbol.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/ControllerSymbol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitIncludes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitExtends";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/ControllerSymbol";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcModulesForClassInFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initGistForProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static enum FQNsExternalizer implements DataExternalizer<List<FQN>>
    {
        INSTANCE;


        public void save(@NotNull DataOutput out, List<FQN> value) throws IOException {
            if (out == null) {
                FQNsExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (FQN fqn : value) {
                out.writeUTF(fqn.getFullPath());
            }
        }

        public List<FQN> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                FQNsExternalizer.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            ArrayList<FQN> result = new ArrayList<FQN>();
            for (int i = 0; i < size; ++i) {
                result.add(FQN.Builder.fromString((String)in.readUTF()));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/ControllerSymbol$FQNsExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

