/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.cli.RMInspectionToolLaunchSettings;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketAssetsLoadPathManager;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RShiftExpressionNavigator;
import org.jetbrains.plugins.ruby.util.ProjectQueues;

public final class AssetsRegistrationWatcher
implements Disposable {
    public static final Topic<AssetsListener> ASSETS_CHANGED_TOPIC = new Topic(AssetsListener.class, Topic.BroadcastDirection.NONE);
    private static final Logger LOG = Logger.getInstance(AssetsRegistrationWatcher.class);
    private static final String PATHS_CALL_NAME = "paths";
    private static final String PATHS_CALL_MARKER = "assets.paths";
    private static final String RAILS_ROOT_STR_SUBSTITUTION = "#{Rails.root}";
    private final MergingUpdateQueue myQueue;
    private final Module myModule;
    private BulkFileListener myVfsListener;
    public PsiTreeChangeAdapter myPsiListener;

    public AssetsRegistrationWatcher(@NotNull Module module) {
        if (module == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(0);
        }
        this.myQueue = new MergingUpdateQueue("AssetsRegistrationWatcher", 5000, true, null, (Disposable)this).setRestartTimerOnAdd(true).usePassThroughInUnitTestMode();
        this.myModule = module;
    }

    public void dispose() {
    }

    public static AssetsRegistrationWatcher getInstance(Module module) {
        return (AssetsRegistrationWatcher)module.getService(AssetsRegistrationWatcher.class);
    }

    public void subscribe() {
        if (this.myModule.isDisposed()) {
            return;
        }
        RailsApp railsApp = RailsApp.fromModule(this.myModule);
        LOG.assertTrue(railsApp != null);
        StartupManager startupManager = StartupManager.getInstance((Project)this.myModule.getProject());
        startupManager.runWhenProjectIsInitialized(() -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            if (!RMInspectionToolLaunchSettings.getInstance().isActivated()) {
                this.enableWatchers(railsApp);
            }
            AssetsRegistrationWatcher.createScanTask(this.myModule, railsApp).run();
        });
    }

    private void enableWatchers(@NotNull RailsApp railsApp) {
        if (railsApp == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(1);
        }
        final List<String> applicationRbUrls = railsApp.getApplicationFileUrls();
        final List<String> initializersRootUrls = railsApp.getPaths().getUrls("config/initializers");
        if (applicationRbUrls.isEmpty() || initializersRootUrls.isEmpty()) {
            return;
        }
        assert (this.myVfsListener == null) : "Double assets watcher registration";
        this.myPsiListener = new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                AssetsRegistrationWatcher.this.processPsiEvent(event, applicationRbUrls, initializersRootUrls);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                AssetsRegistrationWatcher.this.processPsiEvent(event, applicationRbUrls, initializersRootUrls);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                AssetsRegistrationWatcher.this.processPsiEvent(event, applicationRbUrls, initializersRootUrls);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                AssetsRegistrationWatcher.this.processPsiEvent(event, applicationRbUrls, initializersRootUrls);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(4);
                }
                AssetsRegistrationWatcher.this.processPsiEvent(event, applicationRbUrls, initializersRootUrls);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        PsiManager.getInstance((Project)this.myModule.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiListener, (Disposable)this);
        this.myVfsListener = new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileDeleteEvent) && !(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileCopyEvent)) continue;
                    AssetsRegistrationWatcher.this.processFileEvent(vFileEvent.getFile(), applicationRbUrls, initializersRootUrls);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher$2", "after"));
            }
        };
        MessageBusConnection busConnection = this.myModule.getProject().getMessageBus().connect((Disposable)this);
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this.myVfsListener);
        busConnection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                AssetsRegistrationWatcher.this.scheduleAssetsPathsRefresh();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher$3", "rootsChanged"));
            }
        });
        busConnection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerListener(){

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (facet instanceof BaseRailsFacet && AssetsRegistrationWatcher.this.myModule == facet.getModule()) {
                    AssetsRegistrationWatcher.this.scheduleAssetsPathsRefresh();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher$4", "facetAdded"));
            }
        });
    }

    private void processPsiEvent(@NotNull PsiTreeChangeEvent event, @NotNull List<String> applicationRbUrls, @NotNull Collection<String> initializersRootUrls) {
        PsiFile file;
        if (event == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(2);
        }
        if (applicationRbUrls == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(3);
        }
        if (initializersRootUrls == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(4);
        }
        if ((file = event.getFile()) != null) {
            this.processFileEvent(file.getVirtualFile(), applicationRbUrls, initializersRootUrls);
        }
    }

    private void processFileEvent(@Nullable VirtualFile file, @NotNull List<String> applicationRbUrls, @NotNull Collection<String> initializersRootUrls) {
        if (applicationRbUrls == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(5);
        }
        if (initializersRootUrls == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(6);
        }
        if (file == null) {
            return;
        }
        String url = file.getUrl();
        if (!file.isDirectory() && applicationRbUrls.contains(url)) {
            this.scheduleAssetsPathsRefresh();
            return;
        }
        if (ContainerUtil.exists(initializersRootUrls, url::contains)) {
            this.scheduleAssetsPathsRefresh();
            return;
        }
    }

    private void scheduleAssetsPathsRefresh() {
        this.myQueue.queue((Update)new MyAssetsPathScan(this.myModule));
    }

    private static Runnable createScanTask(@NotNull Module module, @Nullable RailsApp railsApp) {
        if (module == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(7);
        }
        final Runnable doScanRunnable = () -> AssetsRegistrationWatcher.doScanAssets(module, railsApp);
        return () -> {
            Project project = module.getProject();
            DumbService.getInstance((Project)project).runWhenSmart(() -> ProjectQueues.getInstance(project).queue(RBundle.message((String)"rails.assets.scan.paths"), new Task.Backgroundable(project, RBundle.message((String)"rails.assets.scan.paths.for", (Object[])new Object[]{module.getName()}), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (this.myProject == null || this.myProject.isDisposed()) {
                        return;
                    }
                    doScanRunnable.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher$5", "run"));
                }
            }));
        };
    }

    private static void doScanAssets(Module module, RailsApp railsApp) {
        if (module.isDisposed()) {
            return;
        }
        if (railsApp == null) {
            return;
        }
        if (!SprocketsUtil.railsWithAssetsSupport(module)) {
            return;
        }
        ArrayList<String> paths = new ArrayList<String>(2);
        AssetsRegistrationWatcher.scanForAssetsRegistration(module, railsApp, paths);
        SprocketAssetsLoadPathManager.getInstance(railsApp).setUsedDefinedAssetsRootPaths(paths);
        ((AssetsListener)module.getProject().getMessageBus().syncPublisher(ASSETS_CHANGED_TOPIC)).rootsChanged(module);
    }

    private static void scanForAssetsRegistration(@NotNull Module module, @NotNull RailsApp railsApp, @NotNull List<String> foundPaths) {
        if (module == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(8);
        }
        if (railsApp == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(9);
        }
        if (foundPaths == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(10);
        }
        if (!SprocketsUtil.areAssetsEnabled(railsApp)) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        VirtualFile applicationRbFile = railsApp.getApplicationFile();
        if (applicationRbFile != null) {
            ReadAction.nonBlocking(() -> AssetsRegistrationWatcher.lookupAssetsInFile(applicationRbFile, railsApp, psiManager, foundPaths)).executeSynchronously();
        }
        for (VirtualFile initializersRootDir : RailsPaths.getInstance(module).findFiles("config/initializers")) {
            ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
            fileIndex.iterateContentUnderDirectory(initializersRootDir, fileOrDir -> {
                if (!fileOrDir.isDirectory()) {
                    ReadAction.nonBlocking(() -> AssetsRegistrationWatcher.lookupAssetsInFile(fileOrDir, railsApp, psiManager, foundPaths)).executeSynchronously();
                }
                return true;
            });
        }
    }

    private static void lookupAssetsInFile(@NotNull VirtualFile file, @NotNull RailsApp railsApp, @NotNull PsiManager psiManager, final @NotNull List<String> foundPaths) {
        VirtualFile railsApplicationRoot;
        if (file == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(11);
        }
        if (railsApp == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(12);
        }
        if (psiManager == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(13);
        }
        if (foundPaths == null) {
            AssetsRegistrationWatcher.$$$reportNull$$$0(14);
        }
        if ((railsApplicationRoot = railsApp.getRailsApplicationRoot()) == null) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(file);
        if (psiFile == null) {
            LOG.warn("Unable to find PsiFile for " + file.getPath());
            return;
        }
        RubyPsiInterpreter interpreter = new RubyPsiInterpreter(true);
        PsiCallable callable = new PsiCallable(){

            @Override
            public void processCall(RCallArguments arguments) {
                String dirPath;
                String cmdName = arguments.getCommand();
                if (!AssetsRegistrationWatcher.PATHS_CALL_NAME.equals(cmdName)) {
                    return;
                }
                PsiElement callElement = arguments.getCallElement();
                RBinaryExpression shiftExpression = RShiftExpressionNavigator.getShiftExpressionByLeftPart((PsiElement)callElement);
                if (shiftExpression == null) {
                    return;
                }
                String callElementText = callElement.getText();
                if (!callElementText.endsWith(AssetsRegistrationWatcher.PATHS_CALL_MARKER)) {
                    return;
                }
                RPsiElement shiftArgument = shiftExpression.getRightOperand();
                if (shiftArgument == null) {
                    return;
                }
                if (!(shiftArgument instanceof RStringLiteral)) {
                    LOG.debug("Asset loadpath registration: Unrecognized argument detected: " + shiftArgument.getText());
                    return;
                }
                List substitutions = ((RStringLiteral)shiftArgument).getExpressionSubstitutions();
                int substitutionsCount = substitutions.size();
                if (substitutionsCount == 0) {
                    dirPath = shiftArgument.getText();
                } else if (substitutionsCount == 1) {
                    String pathCandidate = StringUtil.unquoteString((String)shiftArgument.getText());
                    if (!pathCandidate.contains(AssetsRegistrationWatcher.RAILS_ROOT_STR_SUBSTITUTION)) {
                        LOG.debug("Asset loadpath registration: Unrecognized substitutions detected in string argument: " + pathCandidate);
                        return;
                    }
                    dirPath = pathCandidate.replace(AssetsRegistrationWatcher.RAILS_ROOT_STR_SUBSTITUTION, railsApplicationRoot.getPath());
                } else {
                    LOG.debug("Asset loadpath registration: Unrecognized substitutions detected in string argument: " + shiftArgument.getText());
                    return;
                }
                if (dirPath == null) {
                    return;
                }
                foundPaths.add(dirPath);
            }
        };
        interpreter.interpret((PsiElement)psiFile, callable);
    }

    @TestOnly
    public void flush() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myQueue.flush();
        while (true) {
            UIUtil.dispatchAllInvocationEvents();
            try {
                this.myQueue.waitForAllExecuted(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                continue;
            }
            break;
        }
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> ProjectQueues.getInstance(this.myModule.getProject()).waitForExecutedInTests(RBundle.message((String)"rails.assets.scan.paths")));
        while (!future.isDone()) {
            UIUtil.dispatchAllInvocationEvents();
        }
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsApp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationRbUrls";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializersRootUrls";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundPaths";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "enableWatchers";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processPsiEvent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processFileEvent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createScanTask";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "scanForAssetsRegistration";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupAssetsInFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyAssetsPathScan
    extends Update {
        private final Module myModule;

        MyAssetsPathScan(@NotNull Module module) {
            if (module == null) {
                MyAssetsPathScan.$$$reportNull$$$0(0);
            }
            super((Object)"Rails assets paths scan");
            this.myModule = module;
        }

        public void run() {
            if (this.myModule.isDisposed()) {
                return;
            }
            AssetsRegistrationWatcher.createScanTask(this.myModule, RailsApp.fromModule(this.myModule)).run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher$MyAssetsPathScan", "<init>"));
        }
    }

    public static interface AssetsListener {
        public void rootsChanged(Module var1);
    }
}

