/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.sprockets;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.AssetsGroup;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsReferenceSet;

public final class SprocketsReference
extends FileReference {
    @NotNull
    private final SprocketsReferenceSet myReferenceSet;

    public SprocketsReference(@NotNull SprocketsReferenceSet fileReferenceSet, @NotNull TextRange range, int index, @NotNull String text) {
        if (fileReferenceSet == null) {
            SprocketsReference.$$$reportNull$$$0(0);
        }
        if (range == null) {
            SprocketsReference.$$$reportNull$$$0(1);
        }
        if (text == null) {
            SprocketsReference.$$$reportNull$$$0(2);
        }
        super((FileReferenceSet)fileReferenceSet, range, index, text);
        this.myReferenceSet = fileReferenceSet;
    }

    protected ResolveResult @NotNull [] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        ResolveResult first;
        String referenceText;
        if (containingFile == null) {
            SprocketsReference.$$$reportNull$$$0(3);
        }
        if ((referenceText = this.getText()).isEmpty() && this.getIndex() == 0) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)this.getElement().getContainingFile())};
            if (resolveResultArray == null) {
                SprocketsReference.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        ArrayList results = new ArrayList();
        for (PsiFileSystemItem context : this.getContexts()) {
            if (context == null) continue;
            this.innerResolveInContext(referenceText, context, results, caseSensitive);
        }
        int resultSize = results.size();
        if (this.isLast() && resultSize > 1 && !this.myReferenceSet.isMultiResolveAllowed() && (first = (ResolveResult)ContainerUtil.getFirstItem(results)) != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{first};
            if (resolveResultArray == null) {
                SprocketsReference.$$$reportNull$$$0(5);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = resultSize > 0 ? results.toArray(new ResolveResult[resultSize]) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            SprocketsReference.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, @NotNull Collection<? super ResolveResult> result, boolean caseSensitive) {
        boolean somethingFoundByFullName;
        if (text == null) {
            SprocketsReference.$$$reportNull$$$0(7);
        }
        if (context == null) {
            SprocketsReference.$$$reportNull$$$0(8);
        }
        if (result == null) {
            SprocketsReference.$$$reportNull$$$0(9);
        }
        int oldSize = result.size();
        if (this.isLast()) {
            LinkedList<ResolveResult> resultInContext = new LinkedList<ResolveResult>();
            super.innerResolveInContext(text, context, resultInContext, caseSensitive);
            result.addAll(this.filterResultsAccordingToSprocketsDirective(resultInContext));
        } else {
            super.innerResolveInContext(text, context, result, caseSensitive);
        }
        boolean bl = somethingFoundByFullName = oldSize < result.size();
        if (!somethingFoundByFullName && this.isLast() && context instanceof PsiDirectory) {
            for (PsiElement child : context.getChildren()) {
                PsiFileSystemItem file;
                if (!(child instanceof PsiFileSystemItem) || !this.isAppropriateResolveResult((PsiElement)(file = (PsiFileSystemItem)child)) || !file.getName().equals(text) && !file.getName().startsWith(text + ".")) continue;
                result.add((ResolveResult)new PsiElementResolveResult((PsiElement)SprocketsReference.getOriginalFile((PsiFileSystemItem)file)));
            }
        }
    }

    protected Object createLookupItem(PsiElement candidate) {
        if (candidate instanceof PsiFile) {
            PsiFile psiFile = (PsiFile)candidate;
            String lookupString = this.createReferenceTextForFileName(psiFile.getName(), (PsiFileSystemItem)psiFile);
            LookupElementBuilder fileLookupItem = FileInfoManager.getFileLookupItem((PsiElement)psiFile, (String)lookupString, (Icon)psiFile.getIcon(0));
            return lookupString.equals(psiFile.getName()) ? fileLookupItem : fileLookupItem.withTypeText(psiFile.getName(), true);
        }
        return super.createLookupItem(candidate);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            SprocketsReference.$$$reportNull$$$0(10);
        }
        return super.handleElementRename(this.createReferenceTextForFileName(newElementName, this.myReferenceSet.resolve()));
    }

    protected PsiElement rename(@NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            SprocketsReference.$$$reportNull$$$0(11);
        }
        return super.rename(this.createReferenceTextForFileName(newName, this.myReferenceSet.resolve()));
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getUnresolvedMessagePattern() {
        String string = RBundle.message((String)"codeInsight.rails.sprockets.reference.unresolved.message", (Object[])new Object[]{AnalysisBundle.message((String)"error.cannot.resolve", (Object[])new Object[0]), IndexingBundle.message((String)"terms.file", (Object[])new Object[0]), IndexingBundle.message((String)"terms.directory", (Object[])new Object[0]), StringUtil.escapePattern((String)this.decode(this.getCanonicalText()))});
        if (string == null) {
            SprocketsReference.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String createReferenceTextForFileName(@NotNull String fileName, @Nullable PsiFileSystemItem shouldResolvesTo) {
        PsiFileSystemItem expectedParentDirectory;
        if (fileName == null) {
            SprocketsReference.$$$reportNull$$$0(13);
        }
        if (this.isLast() && !this.myReferenceSet.getAssetGroup().requiresExtension() && shouldResolvesTo != null && !shouldResolvesTo.isDirectory() && (expectedParentDirectory = shouldResolvesTo.getParent()) != null) {
            fileName = this.getMinimumReferenceText(expectedParentDirectory, fileName);
        }
        String string = fileName;
        if (string == null) {
            SprocketsReference.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private Collection<ResolveResult> filterResultsAccordingToSprocketsDirective(@NotNull Collection<ResolveResult> results) {
        if (results == null) {
            SprocketsReference.$$$reportNull$$$0(15);
        }
        List list = ContainerUtil.filter(results, result -> {
            PsiElement element = result.getElement();
            return element != null && this.isAppropriateResolveResult(element);
        });
        if (list == null) {
            SprocketsReference.$$$reportNull$$$0(16);
        }
        return list;
    }

    private boolean isAppropriateResolveResult(@NotNull PsiElement candidate) {
        if (candidate == null) {
            SprocketsReference.$$$reportNull$$$0(17);
        }
        boolean acceptsDirectories = this.myReferenceSet.isAcceptsDirectories();
        boolean isAcceptCandidate = candidate instanceof PsiDirectory ? acceptsDirectories || SprocketsReference.containsIndexFile((PsiDirectory)candidate) : !acceptsDirectories;
        return isAcceptCandidate || this.myReferenceSet.isAcceptCandidate(candidate);
    }

    @NotNull
    private String getMinimumReferenceText(@NotNull PsiFileSystemItem expectedParentDirectory, @NotNull String fileName) {
        AssetsGroup assetGroup;
        if (expectedParentDirectory == null) {
            SprocketsReference.$$$reportNull$$$0(18);
        }
        if (fileName == null) {
            SprocketsReference.$$$reportNull$$$0(19);
        }
        if ((assetGroup = this.myReferenceSet.getAssetGroup()).requiresExtension()) {
            String string = fileName;
            if (string == null) {
                SprocketsReference.$$$reportNull$$$0(20);
            }
            return string;
        }
        String fileNameWithoutExtension = assetGroup.getFileNameWithoutSupportedExtensions(fileName);
        if (!fileNameWithoutExtension.isEmpty() && this.fileWillBeResolvedInProperlyLoadPath(expectedParentDirectory, fileNameWithoutExtension)) {
            String string = fileNameWithoutExtension;
            if (string == null) {
                SprocketsReference.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = fileName;
        if (string == null) {
            SprocketsReference.$$$reportNull$$$0(22);
        }
        return string;
    }

    private boolean fileWillBeResolvedInProperlyLoadPath(@NotNull PsiFileSystemItem expectedParentDirectory, @NotNull String referenceText) {
        String parentPath;
        if (expectedParentDirectory == null) {
            SprocketsReference.$$$reportNull$$$0(23);
        }
        if (referenceText == null) {
            SprocketsReference.$$$reportNull$$$0(24);
        }
        String referenceFullPath = (parentPath = PathUtil.getParentPath((String)this.myReferenceSet.getPathString())).isEmpty() ? referenceText : parentPath + this.myReferenceSet.getSeparatorString() + referenceText;
        FileReference lastReference = SprocketsReferenceSet.getLastReference(referenceFullPath, this.myReferenceSet);
        int resolvedCountInProperDirectory = 0;
        if (lastReference != null) {
            LinkedHashSet resultSet = new LinkedHashSet();
            Collections.addAll(resultSet, lastReference.multiResolve(false));
            for (ResolveResult result : resultSet) {
                PsiFileSystemItem parent;
                PsiElement element = result.getElement();
                if (!(element instanceof PsiFileSystemItem) || (parent = ((PsiFileSystemItem)element).getParent()) == null) continue;
                if (!expectedParentDirectory.equals((Object)parent)) {
                    return resolvedCountInProperDirectory == 1;
                }
                ++resolvedCountInProperDirectory;
            }
        }
        return resolvedCountInProperDirectory <= 1;
    }

    private static boolean containsIndexFile(@NotNull PsiDirectory candidate) {
        if (candidate == null) {
            SprocketsReference.$$$reportNull$$$0(25);
        }
        return ContainerUtil.find((Object[])candidate.getFiles(), file -> file != null && file.getName().startsWith("index.")) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 12, 14, 16, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/SprocketsReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedParentDirectory";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/SprocketsReference";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceTextForFileName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterResultsAccordingToSprocketsDirective";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumReferenceText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveInContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceTextForFileName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterResultsAccordingToSprocketsDirective";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAppropriateResolveResult";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMinimumReferenceText";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fileWillBeResolvedInProperlyLoadPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "containsIndexFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 12, 14, 16, 20, 21, 22 -> new IllegalStateException(string);
        };
    }
}

