/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.sprockets;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.AssetsGroup;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths.AppAssetsPathProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths.BaseRailsAssetsPathProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths.LoadPathDescriptor;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths.SprocketAssetsPathProvider;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPathsModificationTracker;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyModificationTrackers;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public final class SprocketAssetsLoadPathManager
extends SimpleModificationTracker {
    private final Module myModule;
    private List<String> myUserDefinedAssetsPaths = new ArrayList<String>();

    public SprocketAssetsLoadPathManager(Module module) {
        this.myModule = module;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getExtendedAssetsRoots() {
        Project project = this.myModule.getProject();
        Collection collection = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this.myModule, () -> {
            HashSet<PsiDirectory> contexts = new HashSet<PsiDirectory>();
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            for (SprocketAssetsPathProvider pathProvider : (SprocketAssetsPathProvider[])SprocketAssetsPathProvider.EP_NAME.getExtensions()) {
                if (!(pathProvider instanceof BaseRailsAssetsPathProvider)) continue;
                for (LoadPathDescriptor path : ((BaseRailsAssetsPathProvider)pathProvider).getExtendedRootLoadPaths(this.myModule)) {
                    contexts.add(psiManager.findDirectory(path.getVirtualFile()));
                }
            }
            return CachedValueProvider.Result.create(contexts, (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, RailsPathsModificationTracker.getInstance(project)});
        });
        if (collection == null) {
            SprocketAssetsLoadPathManager.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public synchronized List<String> getUserDefinedAssetsPaths() {
        return this.myUserDefinedAssetsPaths;
    }

    public synchronized void setUsedDefinedAssetsRootPaths(List<String> paths) {
        this.myUserDefinedAssetsPaths = Collections.unmodifiableList(paths);
        this.incModificationCount();
    }

    public LoadPathDescriptor getDescriptor(@NotNull VirtualFile file) {
        if (file == null) {
            SprocketAssetsLoadPathManager.$$$reportNull$$$0(1);
        }
        return SprocketAssetsLoadPathManager.getAssetRootSet((Module)this.myModule).root2TypeTable.get(file);
    }

    @NotNull
    public Set<VirtualFile> getNotAppTypeAssetsRoots() {
        Set<VirtualFile> set = SprocketAssetsLoadPathManager.getAssetRootSet((Module)this.myModule).notAppTypeAssetsRoots;
        if (set == null) {
            SprocketAssetsLoadPathManager.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getAssetsRoots() {
        Set<VirtualFile> set = SprocketAssetsLoadPathManager.getAssetRootSet((Module)this.myModule).allRoots;
        if (set == null) {
            SprocketAssetsLoadPathManager.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getTypeInDependentAssetsRoots() {
        Set<VirtualFile> set = SprocketAssetsLoadPathManager.getAssetRootSet((Module)this.myModule).typeIndependentAssetsRoots;
        if (set == null) {
            SprocketAssetsLoadPathManager.$$$reportNull$$$0(4);
        }
        return set;
    }

    public List<VirtualFile> getUsedDefinedAssetsDirs() {
        List<String> assetsPaths = this.getUserDefinedAssetsPaths();
        if (assetsPaths.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (String path : assetsPaths) {
            VirtualFile element = VirtualFileUtil.findFileBy(path);
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public static SprocketAssetsLoadPathManager getInstance(@NotNull RailsApp railsApp) {
        if (railsApp == null) {
            SprocketAssetsLoadPathManager.$$$reportNull$$$0(5);
        }
        return SprocketAssetsLoadPathManager.getInstance(railsApp.getModule());
    }

    public static SprocketAssetsLoadPathManager getInstance(@NotNull Module module) {
        if (module == null) {
            SprocketAssetsLoadPathManager.$$$reportNull$$$0(6);
        }
        return (SprocketAssetsLoadPathManager)((Object)module.getService(SprocketAssetsLoadPathManager.class));
    }

    @NotNull
    private static AssetRootSet getAssetRootSet(@NotNull Module module) {
        if (module == null) {
            SprocketAssetsLoadPathManager.$$$reportNull$$$0(7);
        }
        Project project = module.getProject();
        AssetRootSet assetRootSet = (AssetRootSet)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            AssetRootSet result = new AssetRootSet();
            for (SprocketAssetsPathProvider provider : (SprocketAssetsPathProvider[])SprocketAssetsPathProvider.EP_NAME.getExtensions()) {
                List<? extends LoadPathDescriptor> typeIndependentRoots = provider.getLoadPath(module, null);
                for (LoadPathDescriptor loadPathDescriptor : typeIndependentRoots) {
                    VirtualFile file = loadPathDescriptor.getVirtualFile();
                    result.typeIndependentAssetsRoots.add(file);
                    result.allRoots.add(file);
                    result.root2TypeTable.put(file, loadPathDescriptor);
                }
                for (AssetsGroup assetsGroup : AssetsGroup.values()) {
                    List<? extends LoadPathDescriptor> roots = provider.getLoadPath(module, assetsGroup);
                    for (LoadPathDescriptor loadPathDescriptor : roots) {
                        VirtualFile file = loadPathDescriptor.getVirtualFile();
                        result.typeIndependentAssetsRoots.add(file);
                        result.allRoots.add(file);
                        if (provider instanceof AppAssetsPathProvider) {
                            result.appTypeAssetsRoots.add(file);
                        } else {
                            result.notAppTypeAssetsRoots.add(file);
                        }
                        result.root2TypeTable.put(file, loadPathDescriptor);
                    }
                }
            }
            ArrayList dependencies = new ArrayList(RubyModificationTrackers.getRailsSettingsModificationTrackers(project, module));
            dependencies.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            SprocketAssetsLoadPathManager manager = SprocketAssetsLoadPathManager.getInstance(module);
            if (manager != null) {
                dependencies.add(manager);
            }
            return CachedValueProvider.Result.create((Object)result, dependencies);
        });
        if (assetRootSet == null) {
            SprocketAssetsLoadPathManager.$$$reportNull$$$0(8);
        }
        return assetRootSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/SprocketAssetsLoadPathManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsApp";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedAssetsRoots";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/SprocketAssetsLoadPathManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotAppTypeAssetsRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssetsRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInDependentAssetsRoots";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssetRootSet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAssetRootSet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static final class AssetRootSet {
        public final Set<VirtualFile> typeIndependentAssetsRoots = new LinkedHashSet<VirtualFile>();
        public final Set<VirtualFile> appTypeAssetsRoots = new LinkedHashSet<VirtualFile>();
        public final Set<VirtualFile> notAppTypeAssetsRoots = new LinkedHashSet<VirtualFile>();
        public final Set<VirtualFile> allRoots = new LinkedHashSet<VirtualFile>();
        public final Map<VirtualFile, LoadPathDescriptor> root2TypeTable = new HashMap<VirtualFile, LoadPathDescriptor>();

        private AssetRootSet() {
        }

        public String toString() {
            return "AssetRootSet{typeIndependentAssetsRoots=" + String.valueOf(this.typeIndependentAssetsRoots) + ", appTypeAssetsRoots=" + String.valueOf(this.appTypeAssetsRoots) + ", notAppTypeAssetsRoots=" + String.valueOf(this.notAppTypeAssetsRoots) + ", allRoots=" + String.valueOf(this.allRoots) + ", root2TypeTable=" + String.valueOf(this.root2TypeTable) + "}";
        }
    }
}

