/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.sprockets;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AssetsGroup {
    STYLESHEETS("stylesheets", false, new String[]{"stylesheets", "scss", "sass"}, new String[]{"css", "sass", "scss", "less"}),
    JAVASCRIPTS("javascripts", false, "js", "coffee"),
    IMAGES("images", true, "jpg", "jpeg", "png", "gif", "bmp");

    @NotNull
    private final String myPresentableName;
    @NotNull
    private final String myName;
    private final boolean myRequiresExtension;
    private final String @NotNull [] mySupportedFileTypes;
    private final String @NotNull [] myDirectoryNames;

    private AssetsGroup(@NotNull String name, boolean requiresExtension, String ... supportedFileTypes) {
        if (name == null) {
            AssetsGroup.$$$reportNull$$$0(0);
        }
        if (supportedFileTypes == null) {
            AssetsGroup.$$$reportNull$$$0(1);
        }
        this(name, requiresExtension, new String[]{name}, supportedFileTypes);
    }

    private AssetsGroup(@NotNull String name, @NotNull boolean requiresExtension, String[] directoryNames, String ... supportedFileTypes) {
        if (name == null) {
            AssetsGroup.$$$reportNull$$$0(2);
        }
        if (directoryNames == null) {
            AssetsGroup.$$$reportNull$$$0(3);
        }
        if (supportedFileTypes == null) {
            AssetsGroup.$$$reportNull$$$0(4);
        }
        this.myRequiresExtension = requiresExtension;
        this.mySupportedFileTypes = supportedFileTypes;
        this.myPresentableName = StringUtil.capitalize((String)name);
        this.myName = name;
        this.myDirectoryNames = directoryNames;
    }

    @Nullable
    public static AssetsGroup fromString(@NotNull String type) {
        if (type == null) {
            AssetsGroup.$$$reportNull$$$0(5);
        }
        for (AssetsGroup group : AssetsGroup.values()) {
            if (!group.getName().equals(type)) continue;
            return group;
        }
        return null;
    }

    @NotNull
    public String getFileNameWithoutSupportedExtensions(String fileName) {
        int i;
        String fileNameWithoutExtension = fileName;
        while ((i = fileNameWithoutExtension.lastIndexOf(46)) > -1 && ArrayUtil.contains((String)fileNameWithoutExtension.substring(i + 1), (String[])this.mySupportedFileTypes)) {
            fileNameWithoutExtension = fileNameWithoutExtension.substring(0, i);
        }
        String string = fileNameWithoutExtension;
        if (string == null) {
            AssetsGroup.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isExtensionSupported(@Nullable String extension) {
        return ArrayUtil.contains((String)extension, (String[])this.mySupportedFileTypes);
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            AssetsGroup.$$$reportNull$$$0(7);
        }
        return string;
    }

    public String @NotNull [] getDirectoryNames() {
        if (this.myDirectoryNames == null) {
            AssetsGroup.$$$reportNull$$$0(8);
        }
        return this.myDirectoryNames;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            AssetsGroup.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean requiresExtension() {
        return this.myRequiresExtension;
    }

    public String @NotNull [] getSupportedFileTypes() {
        if (this.mySupportedFileTypes == null) {
            AssetsGroup.$$$reportNull$$$0(10);
        }
        return this.mySupportedFileTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedFileTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/AssetsGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/AssetsGroup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameWithoutSupportedExtensions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

