/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.actions.CreateNamedFileFix;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.model.RailsBaseView;
import org.jetbrains.plugins.ruby.rails.model.RailsClassItem;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsLayout;
import org.jetbrains.plugins.ruby.rails.model.RailsMailer;
import org.jetbrains.plugins.ruby.rails.model.RailsPartialView;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDependency;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.ResolveAncestor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;

public class ViewRefParam
extends ParamDefBase {
    @Nullable
    private final ParamDependency<? extends PsiElement> rootDependency;

    public ViewRefParam() {
        this(null);
    }

    public ViewRefParam(@Nullable ParamDependency<? extends PsiElement> rootDependency) {
        this.rootDependency = rootDependency;
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        if (context == null) {
            ViewRefParam.$$$reportNull$$$0(0);
        }
        if (elementsConsumer == null) {
            ViewRefParam.$$$reportNull$$$0(1);
        }
        if (lookupStringFilter == null) {
            ViewRefParam.$$$reportNull$$$0(2);
        }
        for (VirtualFile root : this.getViewRoots(context)) {
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            BiConsumer<VirtualFile, VirtualFile> processor = (folder, file) -> {
                String viewPath = this.buildViewPath((VirtualFile)folder, (VirtualFile)file);
                if (StringUtil.isEmpty((String)viewPath) || !lookupStringFilter.test(viewPath)) {
                    return;
                }
                elementsConsumer.consume((Object)ViewRefParam.createLookupItem(context, ViewRefParam.quoteNameIfSymbol(context, viewPath), LookupItemType.String, fileTypeManager.getFileTypeByFile(file).getIcon()));
            };
            this.processViewPrefixes(context, root, (Consumer<? super String>)((Consumer)viewPrefix -> {
                VirtualFile folder = VfsUtil.findRelativeFile((VirtualFile)root, (String[])new String[]{viewPrefix});
                if (folder != null && folder.isDirectory()) {
                    ViewRefParam.processRelativeViewFiles(folder, (Consumer<? super VirtualFile>)((Consumer)file -> processor.accept(folder, (VirtualFile)file)));
                }
            }));
            ViewRefParam.processAllViewFiles(context.getProject(), root, (Consumer<? super VirtualFile>)((Consumer)file -> processor.accept(root, (VirtualFile)file)));
        }
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            ViewRefParam.$$$reportNull$$$0(3);
        }
        return (PsiElement)ContainerUtil.getOnlyItem(this.multiResolve(context));
    }

    @Override
    @NotNull
    public List<? extends PsiElement> multiResolve(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            ViewRefParam.$$$reportNull$$$0(4);
        }
        ArrayList elements = new ArrayList();
        String viewPathWithExtensions = this.getViewPath(context);
        String viewPath = ViewsConventions.getViewOrLayoutNameByFileName(viewPathWithExtensions);
        List<String> viewExtensions = ViewsConventions.getViewExtensions(viewPathWithExtensions);
        for (VirtualFile root : this.getViewRoots(context)) {
            ArrayList foundElements = new ArrayList();
            BiConsumer<VirtualFile, VirtualFile> consumer = (folder, file) -> {
                String candidateViewPath = this.buildViewPath((VirtualFile)folder, (VirtualFile)file);
                List<String> candidateViewExtensions = ViewsConventions.getViewExtensions(file.getName());
                if ((viewPath.equals(candidateViewPath) || !ViewRefParam.isFullyQualifiedViewPath(viewPath) && viewPath.equals(VfsUtil.extractFileName((String)candidateViewPath))) && ContainerUtil.startsWith(candidateViewExtensions, (List)viewExtensions)) {
                    ContainerUtil.addIfNotNull((Collection)foundElements, (Object)ViewRefParam.findPsiFile(context, file));
                }
            };
            if (!ViewRefParam.isFullyQualifiedViewPath(viewPath)) {
                this.processViewPrefixes(context, root, (Consumer<? super String>)((Consumer)viewPrefix -> {
                    VirtualFile folder = root.findFileByRelativePath(viewPrefix);
                    if (folder != null && folder.isDirectory()) {
                        ViewRefParam.processRelativeViewFiles(folder, (Consumer<? super VirtualFile>)((Consumer)file -> consumer.accept(folder, (VirtualFile)file)));
                    }
                }));
            }
            if (foundElements.isEmpty()) {
                ViewRefParam.processAllViewFiles(context.getProject(), root, (Consumer<? super VirtualFile>)((Consumer)file -> consumer.accept(root, (VirtualFile)file)));
            }
            elements.addAll(foundElements);
        }
        ArrayList arrayList = elements;
        if (arrayList == null) {
            ViewRefParam.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String handleRename(@NotNull RubyCallArgumentContext context, @NotNull String newName) {
        if (context == null) {
            ViewRefParam.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            ViewRefParam.$$$reportNull$$$0(7);
        }
        String oldViewPath = this.getViewPath(context);
        List<String> oldViewExtensions = ViewsConventions.getViewExtensions(oldViewPath);
        String newRelativePath = ViewRefParam.isFullyQualifiedViewPath(oldViewPath) ? oldViewPath.substring(0, oldViewPath.indexOf("/") + 1) : "";
        String newExtensions = (!oldViewExtensions.isEmpty() ? "." : "") + String.join((CharSequence)".", oldViewExtensions);
        String newViewName = this.getViewName(newName);
        if (newViewName == null) {
            return null;
        }
        return newRelativePath + newViewName + newExtensions;
    }

    @Override
    public InspectionResult warningInspection(RubyCallArgumentContext context, RPsiElement element) {
        String warning = RBundle.message((String)"inspection.paramdef.view.warning", (Object[])new Object[]{ParamDef.getTextPresentationForPsiElement(element)});
        return this.buildWarningInspection(context, element, warning);
    }

    @Nullable
    protected String buildViewPath(@NotNull VirtualFile root, @NotNull VirtualFile file) {
        if (root == null) {
            ViewRefParam.$$$reportNull$$$0(8);
        }
        if (file == null) {
            ViewRefParam.$$$reportNull$$$0(9);
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file.getParent(), (VirtualFile)root);
        String viewName = this.getViewName(file.getName());
        if (viewName == null) {
            return null;
        }
        return StringUtil.trimStart((String)(relativePath != null ? relativePath + "/" + viewName : viewName), (String)"/");
    }

    @NotNull
    protected InspectionResult buildWarningInspection(@NotNull RubyCallArgumentContext context, @NotNull RPsiElement element, @NotNull @InspectionMessage String warning) {
        List<VirtualFile> roots;
        if (context == null) {
            ViewRefParam.$$$reportNull$$$0(10);
        }
        if (element == null) {
            ViewRefParam.$$$reportNull$$$0(11);
        }
        if (warning == null) {
            ViewRefParam.$$$reportNull$$$0(12);
        }
        if ((roots = this.getViewRoots(context)).isEmpty()) {
            InspectionResult inspectionResult = InspectionResult.createWarningResult((PsiElement)element, warning);
            if (inspectionResult == null) {
                ViewRefParam.$$$reportNull$$$0(13);
            }
            return inspectionResult;
        }
        String viewPath = this.getViewPath(context);
        String filename = this.getFileName(viewPath);
        if (StringUtil.isEmpty((String)filename)) {
            InspectionResult inspectionResult = InspectionResult.createWarningResult((PsiElement)element, warning);
            if (inspectionResult == null) {
                ViewRefParam.$$$reportNull$$$0(14);
            }
            return inspectionResult;
        }
        ArrayList<String> candidateFolders = new ArrayList<String>();
        if (ViewRefParam.isFullyQualifiedViewPath(viewPath)) {
            candidateFolders.add(StringUtil.trimStart((String)StringUtil.substringBeforeLast((String)viewPath, (String)"/"), (String)"/"));
        } else {
            for (VirtualFile root : roots) {
                this.processViewPrefixes(context, root, (Consumer<? super String>)((Consumer)viewPrefix -> {
                    ProgressManager.checkCanceled();
                    candidateFolders.add((String)viewPrefix);
                }));
            }
        }
        ArrayList<CreateNamedFileFix> fixes = new ArrayList<CreateNamedFileFix>();
        for (String candidate : candidateFolders) {
            for (VirtualFile root : roots) {
                VirtualFile folder = root.findFileByRelativePath(candidate);
                if (folder == null || !folder.isDirectory()) continue;
                fixes.add(new CreateNamedFileFix(filename, folder, "Ruby.ViewRefParam.DefaultExtension", "html.erb", "View"));
            }
        }
        InspectionResult inspectionResult = InspectionResult.createWarningResultWithFixes((PsiElement)element, warning, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        if (inspectionResult == null) {
            ViewRefParam.$$$reportNull$$$0(15);
        }
        return inspectionResult;
    }

    @Override
    @Nullable
    protected PsiElement resolveReferenceForInspectionHook(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            ViewRefParam.$$$reportNull$$$0(16);
        }
        return (PsiElement)ContainerUtil.getFirstItem(this.multiResolve(context));
    }

    @NotNull
    protected String getFileName(@NotNull String viewPath) {
        if (viewPath == null) {
            ViewRefParam.$$$reportNull$$$0(17);
        }
        String string = (String)ObjectUtils.coalesce((Object)VfsUtil.extractFileName((String)viewPath), (Object)viewPath);
        if (string == null) {
            ViewRefParam.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    protected String getViewName(@NotNull String filePath) {
        String fileName;
        String name;
        if (filePath == null) {
            ViewRefParam.$$$reportNull$$$0(19);
        }
        return !(name = (String)ObjectUtils.coalesce((Object)StringUtil.substringBefore((String)(fileName = (String)ObjectUtils.coalesce((Object)VfsUtil.extractFileName((String)filePath), (Object)filePath)), (String)"."), (Object)fileName)).startsWith("_") ? name : null;
    }

    @NotNull
    protected String getViewPath(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            ViewRefParam.$$$reportNull$$$0(20);
        }
        String string = StringUtil.trimStart((String)ViewRefParam.elementText(context), (String)"/");
        if (string == null) {
            ViewRefParam.$$$reportNull$$$0(21);
        }
        return string;
    }

    protected void processViewPrefixes(@NotNull RubyCallArgumentContext context, @NotNull VirtualFile root, @NotNull Consumer<? super String> consumer) {
        String prefix;
        VirtualFile containingFile;
        if (context == null) {
            ViewRefParam.$$$reportNull$$$0(22);
        }
        if (root == null) {
            ViewRefParam.$$$reportNull$$$0(23);
        }
        if (consumer == null) {
            ViewRefParam.$$$reportNull$$$0(24);
        }
        if ((containingFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)context.getArgumentElement())) == null) {
            return;
        }
        Module module = context.getModule();
        List ancestors = Optional.ofNullable(ViewRefParam.getRailsViewOwnerFromFile(module, containingFile)).map(RailsClassItem::getRClass).map(SymbolUtil::getSymbolByContainer).map(symbol -> SymbolHierarchy.getAncestorsCaching(symbol, null)).orElse(Collections.emptyList());
        boolean prefixFound = false;
        for (ResolveAncestor ancestor : ancestors) {
            RailsViewOwner viewOwner;
            PsiElement element = ancestor.getSymbol().getPsiElement();
            if (!(element instanceof RClass) || (viewOwner = ViewRefParam.getRailsViewOwnerFromClass((RClass)element)) == null || viewOwner.isAbstract()) continue;
            for (VirtualFile viewsFolder : viewOwner.getViewsFolders()) {
                String prefix2;
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)viewsFolder, (boolean)false) || (prefix2 = VfsUtilCore.getRelativePath((VirtualFile)viewsFolder, (VirtualFile)root)) == null) continue;
                consumer.consume((Object)prefix2);
                prefixFound = true;
            }
        }
        VirtualFile parent = containingFile.getParent();
        if (!prefixFound && parent != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)parent, (boolean)false) && (prefix = VfsUtilCore.getRelativePath((VirtualFile)parent, (VirtualFile)root)) != null) {
            consumer.consume((Object)prefix);
        }
    }

    @NotNull
    private List<VirtualFile> getViewRoots(@NotNull RubyCallArgumentContext context) {
        PsiElement candidate;
        if (context == null) {
            ViewRefParam.$$$reportNull$$$0(25);
        }
        if (this.rootDependency != null && (candidate = this.rootDependency.getValue(context)) instanceof PsiFileSystemItem) {
            List list = ContainerUtil.createMaybeSingletonList((Object)((PsiFileSystemItem)candidate).getVirtualFile());
            if (list == null) {
                ViewRefParam.$$$reportNull$$$0(26);
            }
            return list;
        }
        List<VirtualFile> list = this.viewRoots(context);
        if (list == null) {
            ViewRefParam.$$$reportNull$$$0(27);
        }
        return list;
    }

    @Nullable
    private static RailsBaseView getRailsViewFromFile(@Nullable Module module, @NotNull VirtualFile file) {
        RailsView view;
        if (file == null) {
            ViewRefParam.$$$reportNull$$$0(28);
        }
        if ((view = RailsView.fromFile(file, module)) != null) {
            return view;
        }
        RailsLayout layout = RailsLayout.fromFile(file, module);
        return layout != null ? layout : RailsPartialView.fromFile(file, module);
    }

    @Nullable
    private static RailsViewOwner getRailsViewOwnerFromClass(@NotNull RClass rClass) {
        RailsController controller;
        if (rClass == null) {
            ViewRefParam.$$$reportNull$$$0(29);
        }
        return (controller = RailsController.fromClass(rClass)) != null ? controller : RailsMailer.fromClass(rClass);
    }

    @Nullable
    private static RailsViewOwner getRailsViewOwnerFromFile(@Nullable Module module, @NotNull VirtualFile file) {
        RailsBaseView view;
        if (file == null) {
            ViewRefParam.$$$reportNull$$$0(30);
        }
        if ((view = ViewRefParam.getRailsViewFromFile(module, file)) != null && view.getViewOwner() != null) {
            return view.getViewOwner();
        }
        RailsController controller = RailsController.fromFile(module, file);
        return controller != null ? controller : RailsMailer.fromFile(module, file);
    }

    private static boolean isFullyQualifiedViewPath(@NotNull String viewPath) {
        if (viewPath == null) {
            ViewRefParam.$$$reportNull$$$0(31);
        }
        return viewPath.contains("/");
    }

    private static void processAllViewFiles(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super VirtualFile> consumer) {
        if (project == null) {
            ViewRefParam.$$$reportNull$$$0(32);
        }
        if (root == null) {
            ViewRefParam.$$$reportNull$$$0(33);
        }
        if (consumer == null) {
            ViewRefParam.$$$reportNull$$$0(34);
        }
        ViewRefParam.processFiles(project, root, (Consumer<VirtualFile>)((Consumer)arg_0 -> consumer.consume(arg_0)));
    }

    private static void processRelativeViewFiles(@NotNull VirtualFile root, @NotNull Consumer<? super VirtualFile> consumer) {
        if (root == null) {
            ViewRefParam.$$$reportNull$$$0(35);
        }
        if (consumer == null) {
            ViewRefParam.$$$reportNull$$$0(36);
        }
        for (VirtualFile file : root.getChildren()) {
            ProgressManager.checkCanceled();
            consumer.consume((Object)file);
        }
    }

    @NotNull
    private static String quoteNameIfSymbol(@NotNull RubyCallArgumentContext context, @NotNull String name) {
        if (context == null) {
            ViewRefParam.$$$reportNull$$$0(37);
        }
        if (name == null) {
            ViewRefParam.$$$reportNull$$$0(38);
        }
        Object object = context.getArgumentElement() instanceof RSymbol && name.indexOf(47) != -1 ? "'" + name + "'" : name;
        if (object == null) {
            ViewRefParam.$$$reportNull$$$0(39);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 13, 14, 15, 18, 21, 26, 27, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 26: 
            case 27: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/ViewRefParam";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: 
            case 23: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warning";
                break;
            }
            case 17: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 24: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/ViewRefParam";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildWarningInspection";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewPath";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewRoots";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "quoteNameIfSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAllVariants";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 26: 
            case 27: 
            case 39: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildViewPath";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildWarningInspection";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceForInspectionHook";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getViewName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getViewPath";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processViewPrefixes";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getViewRoots";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRailsViewFromFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRailsViewOwnerFromClass";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getRailsViewOwnerFromFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isFullyQualifiedViewPath";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processAllViewFiles";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processRelativeViewFiles";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "quoteNameIfSymbol";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 13, 14, 15, 18, 21, 26, 27, 39 -> new IllegalStateException(string);
        };
    }
}

