/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.FactoryMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.StatusCodeRefParam;

public class StatusCodeRefParamService
implements Disposable {
    private static final Pattern ourSearchPattern = Pattern.compile("^\\s*(\\d\\d\\d)\\s*=>\\s*['|\"](.*)['|\"],?\\r?$", 8);
    private static final Pattern ourObsoleteStatusSymbolToCodePattern = Pattern.compile("([_a-z\\d]+): (\\d{3})");
    private final Map<Module, StatusFileDescriptor> myStatusFilesDescriptorsMap;

    public StatusCodeRefParamService(@NotNull Project project) {
        if (project == null) {
            StatusCodeRefParamService.$$$reportNull$$$0(0);
        }
        this.myStatusFilesDescriptorsMap = FactoryMap.create(module -> StatusFileDescriptor.create(module));
        project.getMessageBus().connect((Disposable)this).subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                StatusCodeRefParamService.this.reset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/StatusCodeRefParamService$1", "rootsChanged"));
            }
        });
    }

    private void reset() {
        this.myStatusFilesDescriptorsMap.clear();
    }

    @NotNull
    public List<StatusDescriptor> getAllDescriptors(@Nullable Module module) {
        StatusFileDescriptor descriptor = this.getStatusFileDescriptor(module);
        List<Object> list = descriptor == null ? Collections.emptyList() : descriptor.getAllDescriptors();
        if (list == null) {
            StatusCodeRefParamService.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public StatusFileDescriptor getStatusFileDescriptor(@Nullable Module module) {
        return module == null || module.isDisposed() ? null : this.myStatusFilesDescriptorsMap.get(module);
    }

    public void dispose() {
    }

    public static StatusCodeRefParamService getInstance(@NotNull Project project) {
        if (project == null) {
            StatusCodeRefParamService.$$$reportNull$$$0(2);
        }
        return (StatusCodeRefParamService)project.getService(StatusCodeRefParamService.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/StatusCodeRefParamService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/StatusCodeRefParamService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static final class StatusFileDescriptor {
        @NotNull
        private final VirtualFile myVirtualFile;
        @NotNull
        private final Map<String, StatusDescriptor> myMapByCode;
        private final Map<String, StatusDescriptor> myMapByStatus;

        private StatusFileDescriptor(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                StatusFileDescriptor.$$$reportNull$$$0(0);
            }
            this.myMapByCode = new LinkedHashMap<String, StatusDescriptor>();
            this.myMapByStatus = new HashMap<String, StatusDescriptor>();
            this.myVirtualFile = virtualFile;
        }

        @NotNull
        public List<StatusDescriptor> getAllDescriptors() {
            return new ArrayList<StatusDescriptor>(this.myMapByCode.values());
        }

        @Nullable
        public StatusDescriptor getDescriptorByCode(@Nullable String code) {
            return code == null ? null : this.myMapByCode.get(code);
        }

        @Nullable
        public StatusDescriptor getDescriptorByStatus(@Nullable String status) {
            return status == null ? null : this.myMapByStatus.get(status);
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myVirtualFile;
            if (virtualFile == null) {
                StatusFileDescriptor.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        @Nullable
        public static StatusFileDescriptor create(@NotNull Module module) {
            String codesText;
            VirtualFile sourceFile;
            if (module == null) {
                StatusFileDescriptor.$$$reportNull$$$0(2);
            }
            if ((sourceFile = StatusFileDescriptor.findSourceFile(module)) == null) {
                return null;
            }
            try {
                codesText = VfsUtilCore.loadText((VirtualFile)sourceFile);
                codesText = codesText.replaceAll("\\r", "");
            }
            catch (IOException e) {
                return null;
            }
            StatusFileDescriptor result = new StatusFileDescriptor(sourceFile);
            Matcher matcher = ourSearchPattern.matcher(codesText);
            while (matcher.find()) {
                StatusDescriptor statusDescriptor = StatusDescriptor.create(matcher);
                result.myMapByCode.put(statusDescriptor.getCode(), statusDescriptor);
                result.myMapByStatus.put(StatusCodeRefParam.statusToSymbol(statusDescriptor.getStatus()), statusDescriptor);
            }
            int obsoleteSymbolToStatusCodesIndex = codesText.indexOf("OBSOLETE_SYMBOLS_TO_STATUS_CODES");
            if (obsoleteSymbolToStatusCodesIndex > 0) {
                String obsoleteSymbolToStatusCodesText = codesText.substring(obsoleteSymbolToStatusCodesIndex, codesText.indexOf("}", obsoleteSymbolToStatusCodesIndex));
                Matcher symbolToCodeMatcher = ourObsoleteStatusSymbolToCodePattern.matcher(obsoleteSymbolToStatusCodesText);
                while (symbolToCodeMatcher.find()) {
                    StatusDescriptor statusDescriptor = StatusDescriptor.create(symbolToCodeMatcher.group(2), StringUtil.capitalizeWords((String)symbolToCodeMatcher.group(1).replaceAll("_", " "), (boolean)true), TextRange.create((int)symbolToCodeMatcher.start(2), (int)symbolToCodeMatcher.end(2)).shiftRight(obsoleteSymbolToStatusCodesIndex));
                    result.myMapByCode.put(symbolToCodeMatcher.group(2), statusDescriptor);
                    result.myMapByStatus.put(symbolToCodeMatcher.group(1), statusDescriptor);
                }
            }
            return result.myMapByCode.isEmpty() ? null : result;
        }

        @Nullable
        private static VirtualFile findSourceFile(@NotNull Module module) {
            VirtualFile child;
            GemInfo rack;
            VirtualFile child2;
            if (module == null) {
                StatusFileDescriptor.$$$reportNull$$$0(3);
            }
            GemInfo actionPack = RubyProjectGemSearchService.Companion.findGem(module, "actionpack");
            VirtualFile result = null;
            if (actionPack != null && (child2 = actionPack.getFile()) != null) {
                result = child2.findFileByRelativePath("lib/action_controller/status_codes.rb");
            }
            if ((rack = RubyProjectGemSearchService.Companion.findGem(module, "rack")) != null && (child = rack.getFile()) != null && result == null) {
                result = child.findFileByRelativePath("lib/rack/utils.rb");
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/StatusCodeRefParamService$StatusFileDescriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/StatusCodeRefParamService$StatusFileDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findSourceFile";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class StatusDescriptor {
        private String myCode;
        private String myStatus;
        private TextRange myRange;

        @NotNull
        public String getCode() {
            String string = this.myCode;
            if (string == null) {
                StatusDescriptor.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getStatus() {
            String string = this.myStatus;
            if (string == null) {
                StatusDescriptor.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public TextRange getRange() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                StatusDescriptor.$$$reportNull$$$0(2);
            }
            return textRange;
        }

        @NotNull
        public static StatusDescriptor create(@NotNull Matcher matcher) {
            if (matcher == null) {
                StatusDescriptor.$$$reportNull$$$0(3);
            }
            return StatusDescriptor.create(matcher.group(1), matcher.group(2), TextRange.create((int)matcher.start(1), (int)matcher.end(1)));
        }

        @NotNull
        public static StatusDescriptor create(@NotNull String code, @NotNull String status, @NotNull TextRange codeRange) {
            if (code == null) {
                StatusDescriptor.$$$reportNull$$$0(4);
            }
            if (status == null) {
                StatusDescriptor.$$$reportNull$$$0(5);
            }
            if (codeRange == null) {
                StatusDescriptor.$$$reportNull$$$0(6);
            }
            StatusDescriptor result = new StatusDescriptor();
            result.myCode = code;
            result.myStatus = status;
            result.myRange = codeRange;
            StatusDescriptor statusDescriptor = result;
            if (statusDescriptor == null) {
                StatusDescriptor.$$$reportNull$$$0(7);
            }
            return statusDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/StatusCodeRefParamService$StatusDescriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatus";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/StatusCodeRefParamService$StatusDescriptor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

