/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.routes.RoutesParser;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

final class RailsRoutesNamespaceRefParam
extends ParamDefBase {
    static final ParamDef INSTANCE = new RailsRoutesNamespaceRefParam();

    private RailsRoutesNamespaceRefParam() {
    }

    @Override
    @NotNull
    public String handleRename(@NotNull RubyCallArgumentContext context, @NotNull String newName) {
        if (context == null) {
            RailsRoutesNamespaceRefParam.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            RailsRoutesNamespaceRefParam.$$$reportNull$$$0(1);
        }
        String string = NamingConventions.toUnderscoreCase((String)newName, (Module)context.getModule());
        if (string == null) {
            RailsRoutesNamespaceRefParam.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public InspectionResult inspectReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RailsRoutesNamespaceRefParam.$$$reportNull$$$0(3);
        }
        RPsiElement element = context.getArgumentElement();
        if (this.multiResolve(context).isEmpty()) {
            if (RubyPsiUtil.isSimpleStringOrSymbol((PsiElement)element)) {
                String moduleName = NamingConventions.toCamelCase((String)RailsRoutesNamespaceRefParam.getTextPresentationForPsiElement(element), (Module)context.getModule());
                FQN moduleFqn = FQN.Builder.concat((FQN)RailsRoutesNamespaceRefParam.getParentNamespaceFqn(context), (String)moduleName);
                InspectionResult inspectionResult = InspectionResult.createWarningResult((PsiElement)element, RBundle.message((String)"inspection.paramdef.module.warning", (Object[])new Object[]{moduleFqn.getFullPath()}));
                if (inspectionResult == null) {
                    RailsRoutesNamespaceRefParam.$$$reportNull$$$0(4);
                }
                return inspectionResult;
            }
            InspectionResult inspectionResult = InspectionResult.createProbablyAcceptibleResult((PsiElement)element);
            if (inspectionResult == null) {
                RailsRoutesNamespaceRefParam.$$$reportNull$$$0(5);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = InspectionResult.createOkResult((PsiElement)element);
        if (inspectionResult == null) {
            RailsRoutesNamespaceRefParam.$$$reportNull$$$0(6);
        }
        return inspectionResult;
    }

    @Override
    @NotNull
    public List<? extends PsiElement> multiResolve(@NotNull RubyCallArgumentContext context) {
        String name;
        if (context == null) {
            RailsRoutesNamespaceRefParam.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)(name = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)context.getArgumentElement())))) {
            List list = Collections.emptyList();
            if (list == null) {
                RailsRoutesNamespaceRefParam.$$$reportNull$$$0(8);
            }
            return list;
        }
        FQN namespaceFqn = FQN.Builder.concat((FQN)RailsRoutesNamespaceRefParam.getParentNamespaceFqn(context), (String)NamingConventions.toCamelCase((String)name, (Module)context.getModule()));
        List<RContainer> containers = RubyFQNUtil.findContainersByFQN(context.getProject(), Type.MODULE.asSet(), namespaceFqn, (PsiElement)context.getArgumentElement());
        if (!containers.isEmpty()) {
            List<RContainer> list = containers;
            if (list == null) {
                RailsRoutesNamespaceRefParam.$$$reportNull$$$0(9);
            }
            return list;
        }
        ArrayList results = new ArrayList();
        for (VirtualFile controllersRoot : RailsRoutesNamespaceRefParam.controllerRoots(context)) {
            VirtualFile relativeRoot = controllersRoot.findFileByRelativePath(NamingConventions.toUnderscoreCase((String)namespaceFqn.getFullPath(), (Module)context.getModule()));
            if (relativeRoot == null) continue;
            ContainerUtil.addIfNotNull(results, (Object)PsiManager.getInstance((Project)context.getProject()).findDirectory(relativeRoot));
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            RailsRoutesNamespaceRefParam.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        if (context == null) {
            RailsRoutesNamespaceRefParam.$$$reportNull$$$0(11);
        }
        if (elementsConsumer == null) {
            RailsRoutesNamespaceRefParam.$$$reportNull$$$0(12);
        }
        if (lookupStringFilter == null) {
            RailsRoutesNamespaceRefParam.$$$reportNull$$$0(13);
        }
        for (VirtualFile controllersRoot : RailsRoutesNamespaceRefParam.controllerRoots(context)) {
            VirtualFile relativeRoot;
            if (controllersRoot == null || (relativeRoot = controllersRoot.findFileByRelativePath(NamingConventions.toUnderscoreCase((String)RailsRoutesNamespaceRefParam.getParentNamespaceFqn(context).getFullPath(), (Module)context.getModule()))) == null) continue;
            ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex().iterateContentUnderDirectory(relativeRoot, dir -> {
                String path;
                ProgressManager.checkCanceled();
                if (dir.isDirectory() && !StringUtil.isEmpty((String)(path = VfsUtilCore.getRelativePath((VirtualFile)dir, (VirtualFile)relativeRoot))) && lookupStringFilter.test(path)) {
                    LookupItemType lookupItemType;
                    LookupItemType lookupItemType2 = lookupItemType = path.contains("/") ? LookupItemType.String : LookupItemType.Symbol;
                    if (!(context.getArgumentElement() instanceof RSymbol) || lookupItemType != LookupItemType.String) {
                        elementsConsumer.consume((Object)RailsRoutesNamespaceRefParam.createLookupItem(context, path, lookupItemType, RubyIcons.Ruby.Nodes.Module));
                    }
                }
                return true;
            });
        }
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RailsRoutesNamespaceRefParam.$$$reportNull$$$0(14);
        }
        return (PsiElement)ContainerUtil.getOnlyItem(this.multiResolve(context));
    }

    @NotNull
    private static FQN getParentNamespaceFqn(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RailsRoutesNamespaceRefParam.$$$reportNull$$$0(15);
        }
        Module module = context.getModule();
        RBlockCall blockCall = RubyPsiUtil.getContainingRBlockCall(CompletionUtil.getOriginalOrSelf((PsiElement)context.getCall().getPsiCommand()));
        FQN fQN = module != null && blockCall != null ? RoutesParser.getInstance(module).getNamespaceFqn((PsiElement)blockCall) : FQN.INVALID;
        if (fQN == null) {
            RailsRoutesNamespaceRefParam.$$$reportNull$$$0(16);
        }
        return fQN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 8, 9, 10, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/RailsRoutesNamespaceRefParam";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/RailsRoutesNamespaceRefParam";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "handleRename";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectReference";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentNamespaceFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inspectReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processAllVariants";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getParentNamespaceFqn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 8, 9, 10, 16 -> new IllegalStateException(string);
        };
    }
}

