/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.associations.AssociationsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.ActiveRecordType;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.ActionMethodRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.ActionWithChildrenRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.AssetRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.AssociationAsRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.AssociationRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.AttributeRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.ControllerMethodRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.FileRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.HelperRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.InverseOfRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.JoinFieldRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.LayoutRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.MailboxRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.MigrationFieldRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.ModelRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.PartialRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.RailsControllerRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.RailsModelAssociationRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.RailsModelClassRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.RailsRoutesControllerRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.RailsRoutesNamespaceRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.RailsStoreAccessorRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.StatusCodeRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.TableNameRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.UrlRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.ViewRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.AssetsGroup;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.routes.RoutesParser;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.AnyParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ArgumentValueParamDependency;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefExpressionConvertable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ResolvingParamDependency;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyHashParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.ParamDefComplexString;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RailsParamDefUtil {
    public static final List<@NotNull String> RAILS_HTTP_METHODS = List.of("delete", "get", "patch", "post", "put");

    public static ParamDefExpressionConvertable actionRef() {
        return RailsParamDefUtil.actionRef(null);
    }

    @NotNull
    public static ParamDefExpressionConvertable actionRef(String controllerName) {
        return new ActionMethodRefParam(controllerName != null ? new ResolvingParamDependency(controllerName) : null);
    }

    @NotNull
    public static ParamDefExpressionConvertable actionWithChildrenRef() {
        return new ActionWithChildrenRefParam();
    }

    @NotNull
    public static ParamDefExpressionConvertable associationsJoinTable() {
        ParamDefExpressionConvertable paramDefExpressionConvertable = ParamDefExpressionUtil.excludeSymbolsFilter(AnyParamDef.getInstance(), RBundle.message((String)"inspection.paramdef.warning.forbidden.symbol.in.assoc.class_name"));
        if (paramDefExpressionConvertable == null) {
            RailsParamDefUtil.$$$reportNull$$$0(0);
        }
        return paramDefExpressionConvertable;
    }

    @NotNull
    public static ParamDefExpressionConvertable associationRef() {
        return new AssociationRefParam();
    }

    @NotNull
    public static ParamDefExpressionConvertable associationAsRef() {
        return new AssociationAsRefParam();
    }

    @NotNull
    public static ParamDefExpressionConvertable associationSourceRef() {
        return new RailsModelAssociationRefParam(context -> {
            RPsiElement element = context.getArgumentElement();
            Symbol symbol = SymbolUtil.getScopeContextWithCaching((PsiElement)element);
            if (symbol == null) {
                return Collections.emptyList();
            }
            RAssoc assoc = context.getArgument("through");
            if (assoc == null) {
                return Collections.emptyList();
            }
            String through = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)assoc.getValue());
            if (StringUtil.isEmpty((String)through)) {
                return Collections.emptyList();
            }
            return ContainerUtil.mapNotNull(AssociationsUtil.findAndResolveAssociation(symbol, through, (PsiElement)element), SymbolUtil::getSymbolByContainer);
        });
    }

    @NotNull
    public static ParamDefExpressionConvertable attributeRef() {
        return new AttributeRefParam();
    }

    @NotNull
    public static ParamDefExpressionConvertable controllerPublicMethodRef(boolean showRailsActionsWarning) {
        return new ControllerMethodRefParam(Visibility.PUBLIC, showRailsActionsWarning);
    }

    @NotNull
    public static ParamDefExpressionConvertable controllerRef() {
        return new RailsControllerRefParam(LookupItemType.Symbol, LookupItemType.String);
    }

    @NotNull
    public static ParamDefExpressionConvertable routesResourceRef() {
        ParamDefExpressionConvertable paramDefExpressionConvertable = ParamDefExpressionUtil.maybeIf(new RailsRoutesControllerRefParam(LookupItemType.Symbol), context -> context.getArgument("controller") == null);
        if (paramDefExpressionConvertable == null) {
            RailsParamDefUtil.$$$reportNull$$$0(1);
        }
        return paramDefExpressionConvertable;
    }

    @NotNull
    public static ParamDefExpressionConvertable routesControllerRef(LookupItemType ... lookupItemTypes) {
        if (lookupItemTypes == null) {
            RailsParamDefUtil.$$$reportNull$$$0(2);
        }
        return new RailsRoutesControllerRefParam(lookupItemTypes);
    }

    @NotNull
    public static ParamDefExpressionConvertable routesControllerActionRef() {
        return new ActionMethodRefParam(context -> {
            Module module = context.getModule();
            if (module == null) {
                return null;
            }
            RCall call = (RCall)CompletionUtil.getOriginalOrSelf((PsiElement)context.getCall());
            RailsApp app = RailsApp.fromModule(module);
            if (app == null || !app.getRoutesFiles().contains(PsiUtilCore.getVirtualFile((PsiElement)call))) {
                return null;
            }
            FQN fqn = RoutesParser.getInstance(module).getControllerFqn((PsiElement)ObjectUtils.coalesce((Object)RBlockCallNavigator.getByCall((RPsiElement)call), (Object)call));
            return RubyFQNUtil.findContainerByFQN(context.getProject(), Type.CLASS.asSet(), fqn, (PsiElement)call);
        });
    }

    @NotNull
    public static ParamDefExpressionConvertable routesControllerWithActionRef() {
        return new ParamDefComplexString(RailsParamDefUtil.routesControllerRef(LookupItemType.String), RailsParamDefUtil.routesControllerActionRef());
    }

    @NotNull
    public static ParamDefExpressionConvertable routesNamespaceRef() {
        ParamDefExpressionConvertable paramDefExpressionConvertable = ParamDefExpressionUtil.maybeIf(RailsRoutesNamespaceRefParam.INSTANCE, context -> context.getArgument("module") == null);
        if (paramDefExpressionConvertable == null) {
            RailsParamDefUtil.$$$reportNull$$$0(3);
        }
        return paramDefExpressionConvertable;
    }

    @NotNull
    public static ParamDefExpressionConvertable routesModuleRef() {
        ParamDef paramDef = RailsRoutesNamespaceRefParam.INSTANCE;
        if (paramDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(4);
        }
        return paramDef;
    }

    @NotNull
    public static ParamDefExpressionConvertable fileRef() {
        return RailsParamDefUtil.fileRef(true);
    }

    @NotNull
    public static ParamDefExpressionConvertable fileRef(boolean globalOnly) {
        return RailsParamDefUtil.fileRef(globalOnly, null);
    }

    @NotNull
    public static ParamDefExpressionConvertable fileRef(boolean globalOnly, String rootMethod) {
        return RailsParamDefUtil.fileRef(globalOnly, rootMethod, false);
    }

    @NotNull
    public static ParamDefExpressionConvertable fileRef(boolean globalOnly, String rootMethod, boolean directory) {
        return new FileRefParam(globalOnly, rootMethod, directory);
    }

    @NotNull
    public static ParamDefExpressionConvertable helperRef() {
        return RailsParamDefUtil.helperRef(false);
    }

    @NotNull
    public static ParamDefExpressionConvertable helperRef(boolean includeOnlyRealFiles) {
        return new HelperRefParam(includeOnlyRealFiles);
    }

    @NotNull
    public static ParamDefExpressionConvertable imageRef() {
        return new AssetRefParam("getImagesRootURL", "inspection.paramdef.image.warning", AssetsGroup.IMAGES, false);
    }

    @NotNull
    public static ParamDefExpressionConvertable inverseAssocRef() {
        return new InverseOfRefParam();
    }

    @NotNull
    public static ParamDefExpressionConvertable joinFieldRef(int modelRef) {
        return new JoinFieldRefParam(new ResolvingParamDependency(modelRef));
    }

    @NotNull
    public static ParamDefExpressionConvertable layoutRef() {
        return new LayoutRefParam();
    }

    @NotNull
    public static ParamDefExpressionConvertable mailboxRef() {
        return new MailboxRefParam();
    }

    @NotNull
    public static ParamDefExpressionConvertable migrationRef() {
        return RailsParamDefUtil.migrationRef(-1, -1);
    }

    @NotNull
    public static ParamDefExpressionConvertable migrationRef(int modelRef, int tableName) {
        return new MigrationFieldRefParam(modelRef >= 0 ? new ResolvingParamDependency(modelRef) : null, tableName >= 0 ? new ArgumentValueParamDependency(tableName) : null);
    }

    @NotNull
    public static ParamDefExpressionConvertable modelRef() {
        return new ModelRefParam();
    }

    @NotNull
    public static ParamDefExpressionConvertable modelClassRef() {
        ParamDefExpressionConvertable paramDefExpressionConvertable = ParamDefExpressionUtil.excludeSymbolsFilter(RailsModelClassRefParam.INSTANCE);
        if (paramDefExpressionConvertable == null) {
            RailsParamDefUtil.$$$reportNull$$$0(5);
        }
        return paramDefExpressionConvertable;
    }

    @NotNull
    public static ParamDefExpressionConvertable modelMethodRef() {
        ParamDefExpressionConvertable paramDefExpressionConvertable = ParamDefExpressionUtil.methodRef("ActiveRecord::Base");
        if (paramDefExpressionConvertable == null) {
            RailsParamDefUtil.$$$reportNull$$$0(6);
        }
        return paramDefExpressionConvertable;
    }

    @NotNull
    public static ParamDefExpressionConvertable partialRef() {
        return new PartialRefParam();
    }

    @NotNull
    public static ParamDefExpressionConvertable relRef() {
        ParamDefExpressionConvertable paramDefExpressionConvertable = ParamDefExpressionUtil.oneOf("alternate", "stylesheet", "start", "next", "prev", "contents", "index", "glossary", "copyright", "chapter", "section", "subsection", "appendix", "help", "bookmark", "tag");
        if (paramDefExpressionConvertable == null) {
            RailsParamDefUtil.$$$reportNull$$$0(7);
        }
        return paramDefExpressionConvertable;
    }

    @NotNull
    public static ParamDefExpressionConvertable scriptRef() {
        return new AssetRefParam("getJavascriptsRootURL", "inspection.paramdef.script.warning", AssetsGroup.JAVASCRIPTS);
    }

    @NotNull
    public static ParamDefExpressionConvertable statusCodeRef() {
        return new StatusCodeRefParam();
    }

    @NotNull
    public static ParamDefExpressionConvertable stylesheetRef() {
        return new AssetRefParam("getStylesheetsRootURL", "inspection.paramdef.stylesheet.warning", AssetsGroup.STYLESHEETS);
    }

    @NotNull
    public static ParamDefExpressionConvertable tableColumnTypeRef() {
        ParamDefExpressionConvertable paramDefExpressionConvertable = ParamDefExpressionUtil.oneOfStringsOrSymbols(ContainerUtil.map2Array(ActiveRecordType.COLUMN_TYPES, Object.class, ParamDefExpressionUtil::s));
        if (paramDefExpressionConvertable == null) {
            RailsParamDefUtil.$$$reportNull$$$0(8);
        }
        return paramDefExpressionConvertable;
    }

    @NotNull
    public static ParamDefExpressionConvertable tableNameRef() {
        return new TableNameRefParam();
    }

    @NotNull
    public static ParamDefExpressionConvertable viewRef() {
        return RailsParamDefUtil.viewRef(null);
    }

    @NotNull
    public static ParamDefExpressionConvertable viewRef(String path) {
        return new ViewRefParam(path != null ? new ResolvingParamDependency(path) : null);
    }

    @NotNull
    public static ParamDefExpressionConvertable urlRef() {
        return new UrlRefParam();
    }

    @NotNull
    public static ParamDefExpressionConvertable usedAssociationRef() {
        return new RailsModelAssociationRefParam();
    }

    @NotNull
    public static ParamDefExpressionConvertable httpVerb() {
        return RailsParamDefUtil.httpVerb(false);
    }

    @NotNull
    public static ParamDefExpressionConvertable httpVerb(boolean includeAll) {
        ArrayList<String> verbs = new ArrayList<String>(RAILS_HTTP_METHODS);
        if (includeAll) {
            verbs.add("all");
        }
        ParamDefExpressionConvertable paramDefExpressionConvertable = ParamDefExpressionUtil.oneOfStringsOrSymbols(ContainerUtil.map(verbs, ParamDefExpressionUtil::s).toArray());
        if (paramDefExpressionConvertable == null) {
            RailsParamDefUtil.$$$reportNull$$$0(9);
        }
        return paramDefExpressionConvertable;
    }

    @NotNull
    public static ParamDefExpressionConvertable standardControllerAction() {
        ParamDefExpressionConvertable paramDefExpressionConvertable = ParamDefExpressionUtil.oneOfStringsOrSymbols(ParamDefExpressionUtil.s("create"), ParamDefExpressionUtil.s("destroy"), ParamDefExpressionUtil.s("edit"), ParamDefExpressionUtil.s("index"), ParamDefExpressionUtil.s("new"), ParamDefExpressionUtil.s("show"), ParamDefExpressionUtil.s("update"));
        if (paramDefExpressionConvertable == null) {
            RailsParamDefUtil.$$$reportNull$$$0(10);
        }
        return paramDefExpressionConvertable;
    }

    @NotNull
    public static RubyHashParamDef oldBeforeFilterHash() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("except"), ParamDefExpressionUtil.array(RailsParamDefUtil.actionWithChildrenRef())).add(ParamDefExpressionUtil.s("only"), ParamDefExpressionUtil.array(RailsParamDefUtil.actionWithChildrenRef()));
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(11);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef beforeFilterHash() {
        RubyHashParamDef rubyHashParamDef = RailsParamDefUtil.oldBeforeFilterHash().add(ParamDefExpressionUtil.s("if"), ParamDefExpressionUtil.instanceMethodRef()).add(ParamDefExpressionUtil.s("unless"), ParamDefExpressionUtil.instanceMethodRef());
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(12);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef callbacksHash() {
        ParamDefExpressionConvertable symbolMethodRef = ParamDefExpressionUtil.methodRef("ActiveRecord::Base", LookupItemType.Symbol);
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("if"), ParamDefExpressionUtil.either(null, symbolMethodRef)).add("unless", ParamDefExpressionUtil.either(null, symbolMethodRef)).add("prepend", ParamDefExpressionUtil.bool());
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(13);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static ParamDefExpressionConvertable activeRecordFinderIncludesListItem() {
        ParamDefExpressionConvertable paramDefExpressionConvertable = ParamDefExpressionUtil.either(ParamDefExpressionUtil.hash(true), RailsParamDefUtil.usedAssociationRef());
        if (paramDefExpressionConvertable == null) {
            RailsParamDefUtil.$$$reportNull$$$0(14);
        }
        return paramDefExpressionConvertable;
    }

    @NotNull
    public static RubyHashParamDef numericalityParamsHash() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("only_integer"), null).add(ParamDefExpressionUtil.s("greater_than"), null).add(ParamDefExpressionUtil.s("greater_than_or_equal_to"), null).add(ParamDefExpressionUtil.s("equal_to"), null).add(ParamDefExpressionUtil.s("less_than"), null).add(ParamDefExpressionUtil.s("less_than_or_equal_to"), null).add(ParamDefExpressionUtil.s("odd"), null).add(ParamDefExpressionUtil.s("even"), null).merge(RailsParamDefUtil.specialValidatorsParamsHash());
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(15);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef validationMethodParamsHash() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("if"), ParamDefExpressionUtil.instanceMethodRef()).add(ParamDefExpressionUtil.s("unless"), ParamDefExpressionUtil.instanceMethodRef()).add(ParamDefExpressionUtil.s("on"), ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("save"), ParamDefExpressionUtil.s("create"), ParamDefExpressionUtil.s("update")));
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(16);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef validatorsEachParamsHash() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("allow_nil"), null).add(ParamDefExpressionUtil.s("allow_blank"), null).merge(RailsParamDefUtil.validationMethodParamsHash());
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(17);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef specialValidatorsParamsHash() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("message"), null).merge(RailsParamDefUtil.validatorsEachParamsHash());
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(18);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef renderParamDefHash() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash(true).add(ParamDefExpressionUtil.s("action"), ParamDefExpressionUtil.either(RailsParamDefUtil.actionRef(), RailsParamDefUtil.viewRef())).add(ParamDefExpressionUtil.s("text"), null).add(ParamDefExpressionUtil.s("template"), RailsParamDefUtil.viewRef()).add(ParamDefExpressionUtil.s("partial"), RailsParamDefUtil.partialRef()).add(ParamDefExpressionUtil.s("layout"), ParamDefExpressionUtil.maybeIf(RailsParamDefUtil.partialRef(), RailsParamDefUtil.layoutRef(), context -> context.hasArgument("partial") || RBlockCallNavigator.getByCall((RPsiElement)context.getCall()) != null)).add(ParamDefExpressionUtil.s("status"), RailsParamDefUtil.statusCodeRef()).add(ParamDefExpressionUtil.s("nothing"), null).add(ParamDefExpressionUtil.s("object"), null).add(ParamDefExpressionUtil.s("use_full_path"), null).add(ParamDefExpressionUtil.s("locals"), null).add(ParamDefExpressionUtil.s("content_type"), ParamDefExpressionUtil.maybeOneOf("text/plain", "text/html", "text/javascript", "text/css", "text/calendar", "text/csv", "application/xml", "application/rss+xml", "application/atom+xml", "application/x-yaml", "multipart/form-data", "application/x-www-form-urlencoded", "application/json")).add(ParamDefExpressionUtil.s("location"), null).add(ParamDefExpressionUtil.s("inline"), null).add(ParamDefExpressionUtil.s("type"), ParamDefExpressionUtil.maybeOneOf(ParamDefExpressionUtil.s("builder"))).add(ParamDefExpressionUtil.s("xml"), null).add(ParamDefExpressionUtil.s("json"), null).add(ParamDefExpressionUtil.s("js"), null).add(ParamDefExpressionUtil.s("callback"), null).add(ParamDefExpressionUtil.s("collection"), null).add(ParamDefExpressionUtil.s("spacer_template"), null).add(ParamDefExpressionUtil.s("as"), null).add(ParamDefExpressionUtil.s("file"), RailsParamDefUtil.viewRef());
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(19);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef routesOptionsHash() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash(true).add(ParamDefExpressionUtil.s("action"), RailsParamDefUtil.routesControllerActionRef()).add(ParamDefExpressionUtil.s("anchor"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("as"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("constraints"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("controller"), RailsParamDefUtil.routesControllerRef(LookupItemType.Symbol, LookupItemType.String)).add(ParamDefExpressionUtil.s("defaults"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("format"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("module"), RailsParamDefUtil.routesModuleRef()).add(ParamDefExpressionUtil.s("on"), ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("collection"), ParamDefExpressionUtil.s("member"), ParamDefExpressionUtil.s("new"))).add(ParamDefExpressionUtil.s("param"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("path"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("to"), RailsParamDefUtil.routesControllerWithActionRef());
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(20);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef routesMatcherOptionsHash() {
        RubyHashParamDef rubyHashParamDef = RailsParamDefUtil.routesOptionsHash().add(ParamDefExpressionUtil.string(), RailsParamDefUtil.routesControllerWithActionRef());
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(21);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef routesGenerateOptions() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("action"), RailsParamDefUtil.actionRef("controller")).add(ParamDefExpressionUtil.s("controller"), RailsParamDefUtil.controllerRef()).add(ParamDefExpressionUtil.s("generate_all"), null).add(ParamDefExpressionUtil.s("method"), RailsParamDefUtil.httpVerb()).add(ParamDefExpressionUtil.s("use_route"), null);
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(22);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef routesScopingOptionsHash() {
        RubyHashParamDef rubyHashParamDef = RailsParamDefUtil.routesOptionsHash().add(ParamDefExpressionUtil.s("except"), ParamDefExpressionUtil.oneSimpleArgOrMoreOf(RailsParamDefUtil.standardControllerAction())).add(ParamDefExpressionUtil.s("format"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("only"), ParamDefExpressionUtil.oneSimpleArgOrMoreOf(RailsParamDefUtil.standardControllerAction())).add(ParamDefExpressionUtil.s("param"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("path"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("path_names"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("shallow"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("shallow_path"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("shallow_prefix"), ParamDefExpressionUtil.any());
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(23);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef urlForOptionsParamDefHash() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash(true).add(ParamDefExpressionUtil.s("anchor"), null).add(ParamDefExpressionUtil.s("escape"), null).add(ParamDefExpressionUtil.s("host"), null).add(ParamDefExpressionUtil.s("only_path"), null).add(ParamDefExpressionUtil.s("password"), null).add(ParamDefExpressionUtil.s("port"), null).add(ParamDefExpressionUtil.s("protocol"), null).add(ParamDefExpressionUtil.s("skip_relative_url_root"), null).add(ParamDefExpressionUtil.s("trailing_slash"), null).add(ParamDefExpressionUtil.s("user"), null).merge(RailsParamDefUtil.routesGenerateOptions());
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(24);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef findersParamsHash() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("conditions"), ParamDefExpressionUtil.array(null)).add(ParamDefExpressionUtil.s("order"), null).add(ParamDefExpressionUtil.s("group"), null).add(ParamDefExpressionUtil.s("limit"), null).add(ParamDefExpressionUtil.s("offset"), null).add(ParamDefExpressionUtil.s("joins"), null).add(ParamDefExpressionUtil.s("include"), ParamDefExpressionUtil.arrayOf(RailsParamDefUtil.activeRecordFinderIncludesListItem())).add(ParamDefExpressionUtil.s("select"), null).add(ParamDefExpressionUtil.s("from"), null).add(ParamDefExpressionUtil.s("readonly"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("lock"), null);
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(25);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef associationsCommonHashParams() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("class_name"), RailsParamDefUtil.modelClassRef()).add(ParamDefExpressionUtil.s("validate"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("autosave"), ParamDefExpressionUtil.bool());
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(26);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef hasOneManyCommonHashParams() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("as"), RailsParamDefUtil.associationAsRef()).add(ParamDefExpressionUtil.s("autosave"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("foreign_key"), RailsParamDefUtil.migrationRef(0, -1)).add(ParamDefExpressionUtil.s("foreign_type"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("inverse_of"), RailsParamDefUtil.inverseAssocRef()).add(ParamDefExpressionUtil.s("primary_key"), RailsParamDefUtil.modelMethodRef()).add(ParamDefExpressionUtil.s("source"), RailsParamDefUtil.associationSourceRef()).add(ParamDefExpressionUtil.s("source_type"), RailsParamDefUtil.modelClassRef()).add(ParamDefExpressionUtil.s("through"), RailsParamDefUtil.usedAssociationRef()).add(ParamDefExpressionUtil.s("validate"), ParamDefExpressionUtil.bool());
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(27);
        }
        return rubyHashParamDef;
    }

    @NotNull
    public static RubyHashParamDef calculationsOptionsHash() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("conditions"), null).add(ParamDefExpressionUtil.s("joins"), null).add(ParamDefExpressionUtil.s("include"), null).add(ParamDefExpressionUtil.s("order"), null).add(ParamDefExpressionUtil.s("group"), null).add(ParamDefExpressionUtil.s("select"), null).add(ParamDefExpressionUtil.s("distinct"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("from"), null);
        if (rubyHashParamDef == null) {
            RailsParamDefUtil.$$$reportNull$$$0(28);
        }
        return rubyHashParamDef;
    }

    public static RubyHashParamDef tableColumnChangeParamDefHash() {
        return ParamDefExpressionUtil.hash(true).add(ParamDefExpressionUtil.s("limit"), null).add(ParamDefExpressionUtil.s("precision"), null).add(ParamDefExpressionUtil.s("scale"), null).add(ParamDefExpressionUtil.s("default"), null).add(ParamDefExpressionUtil.s("column"), null).add(ParamDefExpressionUtil.s("null"), ParamDefExpressionUtil.bool());
    }

    @NotNull
    public static ParamDef storeAccessorRef() {
        return new RailsStoreAccessorRefParam();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/RailsParamDefUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupItemTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "associationsJoinTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "routesResourceRef";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/RailsParamDefUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "routesNamespaceRef";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "routesModuleRef";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "modelClassRef";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "modelMethodRef";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "relRef";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "tableColumnTypeRef";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "httpVerb";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "standardControllerAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "oldBeforeFilterHash";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeFilterHash";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "callbacksHash";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "activeRecordFinderIncludesListItem";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "numericalityParamsHash";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "validationMethodParamsHash";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "validatorsEachParamsHash";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "specialValidatorsParamsHash";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "renderParamDefHash";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "routesOptionsHash";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "routesMatcherOptionsHash";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "routesGenerateOptions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "routesScopingOptionsHash";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "urlForOptionsParamDefHash";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findersParamsHash";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "associationsCommonHashParams";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "hasOneManyCommonHashParams";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "calculationsOptionsHash";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "routesControllerRef";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

