/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsModelSymbol;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

final class RailsModelClassRefParam
extends ParamDef {
    static final ParamDef INSTANCE = new RailsModelClassRefParam();

    private RailsModelClassRefParam() {
    }

    @Override
    @NotNull
    public InspectionResult inspectReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RailsModelClassRefParam.$$$reportNull$$$0(0);
        }
        RPsiElement argumentElement = context.getArgumentElement();
        if (this.multiResolve(context).isEmpty()) {
            if (RubyPsiUtil.isSimpleStringOrSymbol((PsiElement)argumentElement)) {
                InspectionResult inspectionResult = InspectionResult.createWarningResult((PsiElement)argumentElement, RBundle.message((String)"inspection.paramdef.rails.model.class.ref.warning"));
                if (inspectionResult == null) {
                    RailsModelClassRefParam.$$$reportNull$$$0(1);
                }
                return inspectionResult;
            }
            InspectionResult inspectionResult = InspectionResult.createProbablyAcceptibleResult((PsiElement)argumentElement);
            if (inspectionResult == null) {
                RailsModelClassRefParam.$$$reportNull$$$0(2);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = InspectionResult.createOkResult((PsiElement)argumentElement);
        if (inspectionResult == null) {
            RailsModelClassRefParam.$$$reportNull$$$0(3);
        }
        return inspectionResult;
    }

    @NotNull
    public List<PsiElement> multiResolve(@NotNull RubyCallArgumentContext context) {
        RPsiElement argumentElement;
        String className;
        if (context == null) {
            RailsModelClassRefParam.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)(className = NamingConventions.toCamelCase((String)RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)(argumentElement = context.getArgumentElement())), (Module)context.getModule())))) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RailsModelClassRefParam.$$$reportNull$$$0(5);
            }
            return list;
        }
        Symbol symbol = SymbolUtil.findConstantByFQN(context.getProject(), FQN.ofNullable((String)className), (PsiElement)argumentElement);
        if (!ActiveRecordModel.isActiveRecordClass(symbol)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RailsModelClassRefParam.$$$reportNull$$$0(6);
            }
            return list;
        }
        return new ArrayList<PsiElement>(symbol.getAllDeclarations((PsiElement)argumentElement));
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        if (context == null) {
            RailsModelClassRefParam.$$$reportNull$$$0(7);
        }
        if (elementsConsumer == null) {
            RailsModelClassRefParam.$$$reportNull$$$0(8);
        }
        if (lookupStringFilter == null) {
            RailsModelClassRefParam.$$$reportNull$$$0(9);
        }
        RPsiElement argumentElement = context.getArgumentElement();
        RailsModelSymbol.processModels(context.getProject(), (PsiElement)argumentElement, (Processor<? super Symbol>)((Processor)symbol -> {
            ProgressManager.checkCanceled();
            String lookupString = symbol.getFQNWithNesting().getFullPath();
            if (lookupStringFilter.test(lookupString)) {
                elementsConsumer.consume((Object)ParamDefBase.createLookupItem(context, lookupString, LookupItemType.String, RailsIcons.RAILS_MODEL_ICON));
            }
            return true;
        }));
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RailsModelClassRefParam.$$$reportNull$$$0(10);
        }
        return (PsiElement)ContainerUtil.getOnlyItem(this.multiResolve(context));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/RailsModelClassRefParam";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/RailsModelClassRefParam";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inspectReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAllVariants";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

