/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;

public class FileRefParam
extends ParamDefBase {
    protected boolean globalOnly;
    protected String rootMethod;
    protected boolean directory;

    public FileRefParam(boolean globalOnly, @Nullable String rootMethod, boolean directory) {
        this.globalOnly = globalOnly;
        this.rootMethod = rootMethod;
        this.directory = directory;
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        List roots;
        boolean atRoot;
        String text;
        if (context == null) {
            FileRefParam.$$$reportNull$$$0(0);
        }
        if ((text = FileRefParam.elementText(context)).isEmpty()) {
            return null;
        }
        boolean bl = atRoot = text.charAt(0) == '/';
        if (this.globalOnly && !atRoot) {
            return null;
        }
        RailsApp app = FileRefParam.railsApp(context);
        if (app == null) {
            return null;
        }
        if (this.rootMethod != null) {
            roots = switch (this.rootMethod) {
                case "view_root" -> this.viewRoots(context);
                case "model_root" -> FileRefParam.modelRoots(context);
                case "controller_root" -> FileRefParam.controllerRoots(context);
                default -> null;
            };
        } else if (this.globalOnly || atRoot) {
            roots = ContainerUtil.createMaybeSingletonList((Object)app.getRailsApplicationRoot());
            if (atRoot) {
                text = text.substring(1);
            }
        } else {
            VirtualFile containingFile = context.getArgumentElement().getContainingFile().getVirtualFile();
            roots = ContainerUtil.createMaybeSingletonList((Object)(containingFile != null ? containingFile.getParent() : null));
        }
        if (roots == null || roots.isEmpty()) {
            return null;
        }
        int pos = text.lastIndexOf(47);
        for (VirtualFile root : roots) {
            VirtualFile folder = pos > 0 ? root.findFileByRelativePath(text.substring(0, pos + 1)) : root;
            if (folder == null) continue;
            String name = pos > 0 ? text.substring(pos + 1) : text;
            for (VirtualFile child : folder.getChildren()) {
                PsiManager manager = PsiManager.getInstance((Project)context.getProject());
                String childName = child.getName();
                if (this.directory && name.equals(childName)) {
                    return manager.findDirectory(child);
                }
                if (childName.indexOf(name + ".") != 0) continue;
                return manager.findFile(child);
            }
        }
        return null;
    }

    @Override
    public InspectionResult warningInspection(RubyCallArgumentContext context, RPsiElement element) {
        String message = RBundle.message((String)"inspection.paramdef.file.warning", (Object[])new Object[]{ParamDef.getTextPresentationForPsiElement(element)});
        return InspectionResult.createWarningResult((PsiElement)element, message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/FileRefParam", "resolveReference"));
    }
}

