/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.actions.CreateNamedFileFix;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.AssetsGroup;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsReference;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsReferenceSet;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsUtil;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;

public class AssetRefParam
extends ParamDefBase {
    private final String url;
    private final String inspectionMessage;
    private final boolean hasQuickFix;
    private final AssetsGroup assetType;

    public AssetRefParam(String url, String inspectionMessage, AssetsGroup assetType) {
        this(url, inspectionMessage, assetType, true);
    }

    public AssetRefParam(String url, String inspectionMessage, AssetsGroup assetType, boolean hasQuickFix) {
        this.url = url;
        this.inspectionMessage = inspectionMessage;
        this.hasQuickFix = hasQuickFix;
        this.assetType = assetType;
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        RPsiElement valueElement;
        if (context == null) {
            AssetRefParam.$$$reportNull$$$0(0);
        }
        if (elementsConsumer == null) {
            AssetRefParam.$$$reportNull$$$0(1);
        }
        if (lookupStringFilter == null) {
            AssetRefParam.$$$reportNull$$$0(2);
        }
        if ((valueElement = context.getArgumentElement()) instanceof RSymbol) {
            return;
        }
        RailsApp railsApp = AssetRefParam.railsApp(context);
        if (railsApp != null && SprocketsUtil.areAssetsEnabled(railsApp)) {
            boolean found = false;
            SprocketsReferenceSet referenceSet = this.createSprocketsReferenceSet(context);
            FileReference reference = referenceSet.getLastReference();
            if (reference != null) {
                Object[] variants = reference.getVariants();
                String path = referenceSet.getPathString();
                String parentPath = PathUtil.getParentPath((String)path);
                Object pathToItem = parentPath.isEmpty() && !path.startsWith("/") ? "" : parentPath + referenceSet.getSeparatorString();
                for (Object variant : variants) {
                    String elementName = null;
                    if (variant instanceof LookupElementBuilder) {
                        elementName = ((LookupElementBuilder)variant).getLookupString();
                        variant = ((LookupElementBuilder)variant).getObject();
                    }
                    if (!(variant instanceof PsiFileSystemItem)) continue;
                    String string = elementName = elementName == null ? ((PsiFileSystemItem)variant).getName() : elementName;
                    if (lookupStringFilter.test((String)pathToItem + elementName)) {
                        elementsConsumer.consume((Object)LookupElementBuilder.create((String)((String)pathToItem + elementName)).withIcon(((PsiFileSystemItem)variant).getIcon(0)));
                    }
                    found = true;
                }
            }
            if (found) {
                return;
            }
        }
        for (VirtualFile publicRoot : AssetRefParam.getPublicRoots(context)) {
            String publicRootPath = publicRoot.getPath();
            List<VirtualFile> defaultRoots = this.getDefaultRoots(context);
            if (defaultRoots.isEmpty()) continue;
            List stylishRootPaths = ContainerUtil.map(defaultRoots, VirtualFile::getPath);
            AssetRefParam.processFiles(context.getProject(), publicRoot, (Consumer<VirtualFile>)((Consumer)file -> {
                String extension = file.getExtension();
                if (extension == null) {
                    return;
                }
                boolean extensionIsSupported = false;
                for (String supportedExtension : this.assetType.getSupportedFileTypes()) {
                    if (!extension.equals(supportedExtension)) continue;
                    extensionIsSupported = true;
                    break;
                }
                if (!extensionIsSupported) {
                    return;
                }
                String name = this.getShortName((VirtualFile)file, List.of(publicRootPath), stylishRootPaths);
                elementsConsumer.consume((Object)AssetRefParam.createLookupItem(context, name, LookupItemType.String, FileTypeManager.getInstance().getFileTypeByFile(file).getIcon()));
            }));
        }
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        SprocketsReferenceSet referenceSet;
        PsiFileSystemItem resolved;
        RailsApp railsApp;
        if (context == null) {
            AssetRefParam.$$$reportNull$$$0(3);
        }
        if ((railsApp = AssetRefParam.railsApp(context)) != null && SprocketsUtil.areAssetsEnabled(railsApp) && (resolved = (referenceSet = this.createSprocketsReferenceSet(context)).resolve()) != null) {
            return resolved;
        }
        for (Pair<String, VirtualFile> path : this.getExpectedPaths(context, true)) {
            PsiFile psi;
            String fileRelativePath = (String)path.getFirst();
            VirtualFile root = (VirtualFile)path.getSecond();
            if (root == null) continue;
            for (String ext : this.assetType.getSupportedFileTypes()) {
                if (!fileRelativePath.matches(".+\\." + ext) || (psi = AssetRefParam.findPsiFile(context, root.findFileByRelativePath(fileRelativePath))) == null) continue;
                return psi;
            }
            if (this.assetType.requiresExtension()) continue;
            for (String ext : this.assetType.getSupportedFileTypes()) {
                psi = AssetRefParam.findPsiFile(context, root.findFileByRelativePath(fileRelativePath + "." + ext));
                if (psi == null) continue;
                return psi;
            }
        }
        return null;
    }

    @Override
    public String handleRename(@NotNull RubyCallArgumentContext context, @NotNull String newName) {
        RPsiElement element;
        String path;
        Object prefix;
        if (context == null) {
            AssetRefParam.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            AssetRefParam.$$$reportNull$$$0(5);
        }
        Object object = prefix = StringUtil.isEmpty((String)(path = PathUtil.getParentPath((String)StringUtil.notNullize((String)RubyPsiUtilCore.getElementText((PsiElement)(element = context.getArgumentElement())))))) ? "" : path + "/";
        if (this.assetType.requiresExtension()) {
            return (String)prefix + newName;
        }
        return (String)prefix + ViewsConventions.getViewOrLayoutNameByFileName(newName);
    }

    @Override
    public String handleBindToElement(@NotNull RubyCallArgumentContext context, @NotNull PsiElement element) {
        if (context == null) {
            AssetRefParam.$$$reportNull$$$0(6);
        }
        if (element == null) {
            AssetRefParam.$$$reportNull$$$0(7);
        }
        if (element instanceof PsiFile) {
            Module module = context.getModule();
            VirtualFile file = ((PsiFile)element).getVirtualFile();
            if (file != null && module != null && RailsUtil.isRailsGemAttached(module)) {
                SprocketsReferenceSet referenceSet = this.createSprocketsReferenceSet(context);
                FileReference lastReference = referenceSet.getLastReference();
                if (lastReference instanceof SprocketsReference) {
                    SprocketsReference sprocketsReference = (SprocketsReference)lastReference;
                    PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)element;
                    String parentPath = PathUtil.getParentPath((String)referenceSet.getRelativePathForFile(fileSystemItem));
                    String referenceTextForFileName = sprocketsReference.createReferenceTextForFileName(file.getName(), fileSystemItem);
                    return parentPath.isEmpty() ? referenceTextForFileName : parentPath + referenceSet.getSeparatorString() + referenceTextForFileName;
                }
                return null;
            }
            List<VirtualFile> publicRoots = AssetRefParam.getPublicRoots(context);
            List<VirtualFile> defaultRoots = this.getDefaultRoots(context);
            if (!publicRoots.isEmpty() && !defaultRoots.isEmpty() && file != null) {
                return this.getShortName(file, ContainerUtil.map(publicRoots, VirtualFile::getPath), ContainerUtil.map(defaultRoots, VirtualFile::getPath));
            }
        }
        return null;
    }

    @NotNull
    private static List<VirtualFile> getPublicRoots(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            AssetRefParam.$$$reportNull$$$0(8);
        }
        List<VirtualFile> list = AssetRefParam.railsStdPathsFiles(context, "getPublicRootURL");
        if (list == null) {
            AssetRefParam.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private List<VirtualFile> getDefaultRoots(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            AssetRefParam.$$$reportNull$$$0(10);
        }
        List<VirtualFile> list = AssetRefParam.railsStdPathsFiles(context, this.url);
        if (list == null) {
            AssetRefParam.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    protected List<Pair<String, VirtualFile>> getExpectedPaths(@NotNull RubyCallArgumentContext context, boolean forcePublic) {
        if (context == null) {
            AssetRefParam.$$$reportNull$$$0(12);
        }
        ArrayList<Pair<String, VirtualFile>> expectedPaths = new ArrayList<Pair<String, VirtualFile>>();
        String fileRelativeName = AssetRefParam.elementText(context);
        RailsApp railsApp = AssetRefParam.railsApp(context);
        if (!forcePublic && railsApp != null && SprocketsUtil.areAssetsEnabled(railsApp)) {
            List<VirtualFile> assetsDirs = AssetRefParam.railsStdPathsFiles(context, "getAppAssetsRootURL");
            for (VirtualFile assetsDir : assetsDirs) {
                for (String subdir : this.assetType.getDirectoryNames()) {
                    VirtualFile assetsDirChild = assetsDir.findChild(subdir);
                    if (assetsDirChild == null) continue;
                    expectedPaths.add((Pair<String, VirtualFile>)Pair.create((Object)fileRelativeName, (Object)assetsDirChild));
                }
            }
            if (!expectedPaths.isEmpty()) {
                ArrayList<Pair<String, VirtualFile>> arrayList = expectedPaths;
                if (arrayList == null) {
                    AssetRefParam.$$$reportNull$$$0(13);
                }
                return arrayList;
            }
            List<Pair<String, VirtualFile>> list = List.of(Pair.create((Object)fileRelativeName, null));
            if (list == null) {
                AssetRefParam.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (!fileRelativeName.isEmpty() && fileRelativeName.charAt(0) == '/') {
            fileRelativeName = fileRelativeName.substring(1);
            for (VirtualFile root : AssetRefParam.getPublicRoots(context)) {
                expectedPaths.add((Pair<String, VirtualFile>)Pair.create((Object)fileRelativeName, (Object)root));
            }
        } else {
            for (VirtualFile root : this.getDefaultRoots(context)) {
                expectedPaths.add((Pair<String, VirtualFile>)Pair.create((Object)fileRelativeName, (Object)root));
            }
        }
        ArrayList<Pair<String, VirtualFile>> arrayList = expectedPaths;
        if (arrayList == null) {
            AssetRefParam.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Override
    public InspectionResult warningInspection(RubyCallArgumentContext context, RPsiElement element) {
        String msg = RBundle.message((String)this.inspectionMessage, (Object[])new Object[]{ParamDef.getTextPresentationForPsiElement(element)});
        ArrayList<CreateNamedFileFix> fixes = new ArrayList<CreateNamedFileFix>();
        for (Pair<String, VirtualFile> path : this.getExpectedPaths(context, false)) {
            String fileRelativePath = (String)path.getFirst();
            VirtualFile root = (VirtualFile)path.getSecond();
            if (!this.hasQuickFix || root == null || !root.isDirectory()) continue;
            fixes.add(new CreateNamedFileFix(fileRelativePath, root, "Ruby.AssetRefParam." + String.valueOf((Object)this.assetType), (String)ArrayUtil.getFirstElement((Object[])this.assetType.getSupportedFileTypes()), StringUtil.trimEnd((String)this.assetType.getName(), (String)"s")));
        }
        return InspectionResult.createWarningResultWithFixes((PsiElement)element, msg, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    @NotNull
    private String getShortName(@NotNull VirtualFile file, @NotNull List<String> publicRootPaths, @NotNull List<String> stylishRootPaths) {
        if (file == null) {
            AssetRefParam.$$$reportNull$$$0(16);
        }
        if (publicRootPaths == null) {
            AssetRefParam.$$$reportNull$$$0(17);
        }
        if (stylishRootPaths == null) {
            AssetRefParam.$$$reportNull$$$0(18);
        }
        String filePath = file.getPath();
        int nameOffset = 0;
        for (String stylishRootPath : stylishRootPaths) {
            if (!filePath.startsWith(stylishRootPath)) continue;
            nameOffset = Math.max(nameOffset, stylishRootPath.length() + 1);
            break;
        }
        for (String publicRootPath : publicRootPaths) {
            if (!filePath.startsWith(publicRootPath)) continue;
            nameOffset = Math.max(nameOffset, publicRootPath.length());
            break;
        }
        String fileExtension = file.getExtension();
        int suffixLength = this.assetType.requiresExtension() || fileExtension == null ? 0 : fileExtension.length() + 1;
        String string = filePath.substring(nameOffset < filePath.length() ? nameOffset : 0, filePath.length() - suffixLength);
        if (string == null) {
            AssetRefParam.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private SprocketsReferenceSet createSprocketsReferenceSet(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            AssetRefParam.$$$reportNull$$$0(20);
        }
        RPsiElement valueElement = context.getArgumentElement();
        String elementText = AssetRefParam.elementText(context);
        boolean offset = false;
        return new SprocketsReferenceSet((PsiElement)valueElement, elementText, 0, this.assetType, false, (Condition<? super PsiElement>)Conditions.alwaysFalse(), false, false, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11, 13, 14, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/AssetRefParam";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publicRootPaths";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylishRootPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/AssetRefParam";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRoots";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedPaths";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAllVariants";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleBindToElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPublicRoots";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRoots";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedPaths";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createSprocketsReferenceSet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11, 13, 14, 15, 19 -> new IllegalStateException(string);
        };
    }
}

