/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.Consumer;
import icons.RubyIcons;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.ControllerActionRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.ControllerMethodRefParam;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDependency;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class ActionMethodRefParam
extends ControllerMethodRefParam {
    private static final String SPLIT_CHAR = "#";

    public ActionMethodRefParam(@Nullable ParamDependency classDependency) {
        super(Visibility.PUBLIC, true);
        this.containerDependency = classDependency;
    }

    @Override
    public String handleRename(@NotNull RubyCallArgumentContext context, @NotNull String newName) {
        int pos;
        if (context == null) {
            ActionMethodRefParam.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            ActionMethodRefParam.$$$reportNull$$$0(1);
        }
        String newActionName = (pos = newName.indexOf(".")) != -1 ? newName.substring(0, pos) : newName;
        String controllerName = ControllerActionRefParam.getControllerName((PsiElement)context.getArgumentElement());
        if (controllerName != null) {
            return controllerName + SPLIT_CHAR + newActionName;
        }
        return newActionName;
    }

    @Override
    @Nullable
    protected Symbol resolveReferenceInContainer(@NotNull String name, @Nullable RContainer container) {
        List<RailsView> views;
        RailsController controller;
        Symbol ref;
        if (name == null) {
            ActionMethodRefParam.$$$reportNull$$$0(2);
        }
        if ((ref = super.resolveReferenceInContainer(name, container)) != null) {
            return ref;
        }
        RailsController railsController = controller = container instanceof RClass ? RailsController.fromClass((RClass)container) : null;
        if (controller != null && !(views = controller.getViews(name)).isEmpty()) {
            PsiFile file = views.get(0).getPsiFile();
            if (!(file instanceof RFile)) {
                return null;
            }
            return SymbolUtil.getSymbolByContainer((RElementWithFQN)((RFile)file));
        }
        return null;
    }

    @Override
    protected boolean processVariantsFromClass(RubyCallArgumentContext context, RContainer container, @NotNull Consumer<? super LookupElement> elementConsumer, @NotNull Predicate<String> lookupStringFilter) {
        RailsController controller;
        if (elementConsumer == null) {
            ActionMethodRefParam.$$$reportNull$$$0(3);
        }
        if (lookupStringFilter == null) {
            ActionMethodRefParam.$$$reportNull$$$0(4);
        }
        if (!super.processVariantsFromClass(context, container, elementConsumer, lookupStringFilter)) {
            return false;
        }
        RailsController railsController = controller = container instanceof RClass ? RailsController.fromClass((RClass)container) : null;
        if (controller != null) {
            for (RailsView railsView : controller.getAllViews()) {
                if (!lookupStringFilter.test(railsView.getName())) continue;
                elementConsumer.consume((Object)ActionMethodRefParam.createLookupItem(context, railsView.getName(), this.itemType, RubyIcons.Rails.ActionMethod));
            }
        }
        return true;
    }

    @Override
    protected PsiElement resolveReferenceForInspectionHook(@NotNull RubyCallArgumentContext context) {
        Symbol symbolMethod;
        if (context == null) {
            ActionMethodRefParam.$$$reportNull$$$0(5);
        }
        return (this.isValidMethod(symbolMethod = this.resolveReferenceToSymbol(context)) || symbolMethod instanceof PsiFile) && symbolMethod != null ? symbolMethod.getPsiElement() : null;
    }

    @Override
    public boolean isValidMethod(@Nullable Symbol method) {
        if (method == null) {
            return false;
        }
        PsiElement declaration = method.getPsiElement();
        RailsAction railsAction = declaration instanceof RMethod ? RailsAction.fromMethod((RMethod)declaration) : null;
        return railsAction != null && !railsAction.isHiddenAction();
    }

    @Override
    @Nullable
    protected PsiNamedElement findTargetClass(RubyCallArgumentContext context) {
        RailsController controller;
        String controllerName;
        RPsiElement element;
        PsiNamedElement targetClass = super.findTargetClass(context);
        if (targetClass != null) {
            return targetClass;
        }
        Module module = context.getModule();
        if (module != null && (element = context.getArgumentElement()) instanceof RStringLiteral && (controllerName = ControllerActionRefParam.getControllerName((PsiElement)element)) != null && (controller = RailsController.fromName(module, controllerName)) != null) {
            return controller.getRClass();
        }
        return null;
    }

    @Override
    @NotNull
    public TextRange getRange(@NotNull RubyCallArgumentContext context) {
        String content;
        int offset;
        RPsiElement element;
        if (context == null) {
            ActionMethodRefParam.$$$reportNull$$$0(6);
        }
        if ((element = context.getArgumentElement()) instanceof RStringLiteral && (offset = (content = ((RStringLiteral)element).getContent()).lastIndexOf(SPLIT_CHAR)) != -1) {
            TextRange textRange = TextRange.create((int)(offset + 2), (int)(content.length() + 1));
            if (textRange == null) {
                ActionMethodRefParam.$$$reportNull$$$0(7);
            }
            return textRange;
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            ActionMethodRefParam.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/ActionMethodRefParam";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/ActionMethodRefParam";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInContainer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processVariantsFromClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceForInspectionHook";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRange";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

