/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterName;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.navigation.PsiElementNavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.TargetPresentationUtil;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.rails.codeInsight.callTypes.RailsCreateTableCallType;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsModelSymbol;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyGutterIconNavigationHandler;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyNamedTargetLineMarkerTooltipSupplier;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RailsSchemaModelLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @GutterName
    @NotNull
    public String getName() {
        String string = RBundle.message((String)"rails.lineMarker.gutter.schema.model");
        if (string == null) {
            RailsSchemaModelLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = RubyIcons.Rails.ModelClass_14x14;
        if (icon == null) {
            RailsSchemaModelLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return icon;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            RailsSchemaModelLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            RailsSchemaModelLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            RailsSchemaModelLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (elements.isEmpty()) {
            return;
        }
        Project project = elements.get(0).getProject();
        PsiElement invocationPoint = elements.get(0);
        NotNullLazyValue modelsSupplier = NotNullLazyValue.lazy(() -> {
            List<? extends Symbol> models = RailsModelSymbol.getModels(project, invocationPoint);
            return ContainerUtil.mapNotNull(models, it -> ActiveRecordModel.fromFile((PsiFile)ObjectUtils.doIfNotNull((Object)it.getPsiElement(), PsiElement::getContainingFile)));
        });
        for (PsiElement element : ContainerUtil.filterIsInstance(elements, LeafPsiElement.class)) {
            LineMarkerInfo<?> lineMarkerInfo;
            RCall call = RubyPsiUtil.getCoveringRCall(element);
            RIdentifier identifier = (RIdentifier)PsiTreeUtil.getParentOfType((PsiElement)element, RIdentifier.class);
            if (!RubyPsiUtil.isCallOfType((PsiElement)call, RailsCreateTableCallType.class::isInstance) || identifier == null || !call.equals((Object)RCallNavigator.getByCommand((PsiElement)identifier)) || (lineMarkerInfo = RailsSchemaModelLineMarkerProvider.getLineMarker((NotNullLazyValue<List<ActiveRecordModel>>)modelsSupplier, call, element)) == null) continue;
            result.add(lineMarkerInfo);
        }
    }

    @Nullable
    private static LineMarkerInfo<?> getLineMarker(@NotNull NotNullLazyValue<List<ActiveRecordModel>> modelsSupplier, @NotNull RCall call, @NotNull PsiElement element) {
        String tableName;
        if (modelsSupplier == null) {
            RailsSchemaModelLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (call == null) {
            RailsSchemaModelLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RailsSchemaModelLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if ((tableName = (String)ObjectUtils.doIfNotNull((Object)((RPsiElement)ContainerUtil.getFirstItem((List)call.getArguments())), NavigationItem::getName)) == null) {
            return null;
        }
        Project project = call.getProject();
        RailsModel model = (RailsModel)ContainerUtil.find((Iterable)((Iterable)modelsSupplier.get()), it -> tableName.equals(it.getTableName()));
        if (model == null) {
            return null;
        }
        Symbol modelSymbol = SymbolUtil.findConstantByFQN(project, Type.CLASS, model.getRClass().getFQNWithNesting(), null);
        if (modelSymbol == null) {
            return null;
        }
        List<PsiElementNavigationTarget> targets = modelSymbol.getAllDeclarations(null).stream().mapMulti(StreamUtil.select(RPsiElement.class, (Class[])new Class[0])).map(it -> {
            PsiElementNavigationTarget<RPsiElement> target = new PsiElementNavigationTarget<RPsiElement>((RPsiElement)it, TargetPresentationUtil.createTargetPresentation((String)ObjectUtils.coalesce((Object)it.getName(), (Object)""), RailsIcons.RAILS_MODEL_ICON, (PsiElement)it));
            target.setLinkTextAttributes(RubyHighlighter.CONSTANT);
            return target;
        }).sorted().toList();
        if (targets.isEmpty()) {
            return null;
        }
        RubyGutterIconNavigationHandler navigationHandler = new RubyGutterIconNavigationHandler(targets){

            @Override
            @Nls
            @NotNull
            protected String getPopupTitle() {
                String string = RBundle.message((String)"rails.lineMarker.gutter.schema.model.title");
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsSchemaModelLineMarkerProvider$1", "getPopupTitle"));
            }
        };
        RubyNamedTargetLineMarkerTooltipSupplier tooltipSupplier = new RubyNamedTargetLineMarkerTooltipSupplier(targets){

            @Override
            @Nls
            @NotNull
            protected String getFewTooltip() {
                String string = RBundle.message((String)"rails.lineMarker.gutter.schema.model.tooltip.few");
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @Nls
            @NotNull
            protected String getManyTooltip() {
                String string = RBundle.message((String)"rails.lineMarker.gutter.schema.model.tooltip.many");
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @Nls
            @NotNull
            protected String getOneTooltip() {
                String string = RBundle.message((String)"rails.lineMarker.gutter.schema.model.tooltip.one");
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsSchemaModelLineMarkerProvider$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFewTooltip";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getManyTooltip";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOneTooltip";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        return new LineMarkerInfo(element, element.getTextRange(), RubyIcons.Rails.ModelClass_14x14, arg_0 -> RailsSchemaModelLineMarkerProvider.lambda$getLineMarker$4((Supplier)tooltipSupplier, arg_0), (GutterIconNavigationHandler)navigationHandler, GutterIconRenderer.Alignment.RIGHT, (Supplier)tooltipSupplier);
    }

    private static /* synthetic */ String lambda$getLineMarker$4(Supplier tooltipSupplier, PsiElement __) {
        return (String)tooltipSupplier.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsSchemaModelLineMarkerProvider";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsSupplier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsSchemaModelLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarker";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

