/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.completion;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import icons.RubyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.rails.associations.AssociationsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsRouteHelperSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.MethodInsertHandlerCreator;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyPsiLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.presentation.SymbolLookupUtil;

public final class RailsCompletionProvider
extends RubyCompletionProvider {
    @Override
    public LookupElement createLookupItem(@NotNull Symbol symbol, String name, boolean bold, @Nullable Symbol typeSourceSymbol, RType originalType, boolean isInsertHandlerCanBeApplied, MethodInsertHandlerCreator insertHandler, FQN symbolFQN) {
        boolean nameAndLastDeclarationAreOk;
        if (symbol == null) {
            RailsCompletionProvider.$$$reportNull$$$0(0);
        }
        Type type = symbol.getType();
        PsiElement lastDeclaration = SymbolLookupUtil.getSymbolOriginalElement(symbol);
        String symbolName = symbol.getName();
        boolean bl = nameAndLastDeclarationAreOk = StringUtil.isNotEmpty((String)symbolName) && lastDeclaration != null;
        if (nameAndLastDeclarationAreOk && type == Type.FIELD_READER && AssociationsUtil.isAssociationCall((PsiElement)ArgumentFakePsiElement.getCallByArgument((PsiElement)lastDeclaration))) {
            Symbol parent = symbol.getParentSymbol();
            String typeText = parent != null && parent.getType() != Type.FILE ? parent.getFQNWithNesting().toString() : "";
            return PrioritizedLookupElement.withPriority((LookupElement)new RubyPsiLookupElement(symbolName, null, typeText, lastDeclaration, true, RailsIcons.RAILS_MODEL_ASSOCIATION_ICON), (double)RubyCompletionGrouping.INSTANCE_FIELDS.getValue());
        }
        if (nameAndLastDeclarationAreOk && symbol.getExplicitIcon() == RailsIcons.RAILS_MODEL_ATTRIBUTE_ICON) {
            RContainer clazz = RubyPsiUtilCore.getParentContainer((PsiElement)lastDeclaration);
            Symbol clazzSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)clazz);
            Symbol parent = clazzSymbol != null ? clazzSymbol : symbol.getParentSymbol();
            String clazzName = clazz != null ? clazz.getFQN().getShortName() : "";
            String typeText = parent != null && parent.getType() != Type.FILE ? parent.getFQNWithNesting().toString() : clazzName;
            return PrioritizedLookupElement.withPriority((LookupElement)new RubyPsiLookupElement(symbolName, null, typeText, lastDeclaration, true, RailsIcons.RAILS_MODEL_ATTRIBUTE_ICON), (double)RubyCompletionGrouping.INSTANCE_FIELDS.getValue());
        }
        if (symbol instanceof RailsRouteHelperSymbol && typeSourceSymbol != null) {
            return SymbolLookupUtil.createLookupItemForMethod(name, lastDeclaration, true, typeSourceSymbol.getFQNWithNesting().getFullPath(), RubyCompletionGrouping.RAILS_IMPORTANT_METHOD, RubyIcons.Rails.ActionMethod, symbol, isInsertHandlerCanBeApplied, insertHandler);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/rails/codeInsight/completion/RailsCompletionProvider", "createLookupItem"));
    }
}

