/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.callTypes;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsConstants;
import org.jetbrains.plugins.ruby.rails.database.RailsSchemaCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.CallTypeWithStructurePresentation;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeBase;

public final class RailsCreateTableCallType
extends RubyCallTypeBase<Data>
implements CallTypeWithStructurePresentation {
    private static final String CREATE_TABLE = "create_table";

    public RailsCreateTableCallType() {
        super(CREATE_TABLE);
    }

    public boolean canHaveChildren(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsCreateTableCallType.$$$reportNull$$$0(0);
        }
        return this.isCompatible(call);
    }

    @NotNull
    public Data getCallData(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsCreateTableCallType.$$$reportNull$$$0(1);
        }
        String tableName = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)ContainerUtil.getFirstItem((List)call.getArguments()));
        String id = (String)ObjectUtils.coalesce((Object)RubyInterpretUtil.evaluateOptionValue(call, "id"), (Object)"serial");
        String primaryKeyName = !id.equals("false") ? RubyInterpretUtil.evaluateOptionValue(call, "primary_key", "id") : null;
        String primaryKeyType = !id.equals("false") ? RailsSchemaCallable.PRIMARY_KEY_TYPES.getOrDefault(id, "integer") : null;
        return new Data(tableName, primaryKeyName, primaryKeyType);
    }

    @NotNull
    public ItemPresentation getPresentation(final @NotNull RPossibleCall call) {
        if (call == null) {
            RailsCreateTableCallType.$$$reportNull$$$0(2);
        }
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                RPsiElement firstArgument = (RPsiElement)ContainerUtil.getFirstItem((List)call.getArguments());
                return (String)ObjectUtils.doIfNotNull((Object)((RStringLiteral)ObjectUtils.tryCast((Object)firstArgument, RStringLiteral.class)), RStringLiteral::getContentValue);
            }

            @NotNull
            public Icon getIcon(boolean unused) {
                Icon icon = AllIcons.Nodes.DataTables;
                if (icon == null) {
                    1.$$$reportNull$$$0(0);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/RailsCreateTableCallType$1", "getIcon"));
            }
        };
    }

    @Nullable
    public String getPrimaryKeyName(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsCreateTableCallType.$$$reportNull$$$0(3);
        }
        return ((Data)call.getData(new RubyCallType[]{this})).primaryKeyName();
    }

    @Nullable
    public String getPrimaryKeyType(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsCreateTableCallType.$$$reportNull$$$0(4);
        }
        return ((Data)call.getData(new RubyCallType[]{this})).primaryKeyType();
    }

    @Nullable
    public String getTableName(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsCreateTableCallType.$$$reportNull$$$0(5);
        }
        return ((Data)call.getData(new RubyCallType[]{this})).tableName();
    }

    public boolean isCompatible(@NotNull RPossibleCall possibleCall) {
        if (possibleCall == null) {
            RailsCreateTableCallType.$$$reportNull$$$0(6);
        }
        return RailsCreateTableCallType.isInSchemaBlockCall(possibleCall);
    }

    public boolean isPersistent() {
        return true;
    }

    private static boolean isInSchemaBlockCall(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsCreateTableCallType.$$$reportNull$$$0(7);
        }
        return CREATE_TABLE.equals(call.getCommand()) && call.getContainingFile() != null && RailsConstants.SCHEMA_FILES.contains(call.getContainingFile().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/RailsCreateTableCallType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canHaveChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrimaryKeyName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrimaryKeyType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTableName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompatible";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSchemaBlockCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public record Data(@Nullable String tableName, @Nullable String primaryKeyName, @Nullable String primaryKeyType) {
    }
}

