/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.callTypes;

import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeBase;

public final class RailsClassAttributeCallType
extends RubyCallTypeBase<MyData> {
    private final boolean mySupportsInstancePredicate;

    public RailsClassAttributeCallType(@NotNull String commandName) {
        if (commandName == null) {
            RailsClassAttributeCallType.$$$reportNull$$$0(0);
        }
        this(commandName, true);
    }

    public RailsClassAttributeCallType(@NotNull String commandName, boolean supportsInstancePredicate) {
        if (commandName == null) {
            RailsClassAttributeCallType.$$$reportNull$$$0(1);
        }
        super(commandName);
        this.mySupportsInstancePredicate = supportsInstancePredicate;
    }

    @NotNull
    public MyData getCallData(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsClassAttributeCallType.$$$reportNull$$$0(2);
        }
        List attributes = ContainerUtil.mapNotNull((Collection)call.getArguments(), RubyInterpretUtil::evaluateStringOrSymbolElement);
        boolean instanceAccessor = !RubyInterpretUtil.evaluateOptionValue(call, "instance_accessor", "true").equals("false");
        boolean instancePredicate = this.mySupportsInstancePredicate && !RubyInterpretUtil.evaluateOptionValue(call, "instance_predicate", "true").equals("false");
        boolean instanceReader = !RubyInterpretUtil.evaluateOptionValue(call, "instance_reader", "true").equals("false");
        boolean instanceWriter = !RubyInterpretUtil.evaluateOptionValue(call, "instance_writer", "true").equals("false");
        return new MyData(attributes, instanceAccessor, instancePredicate, instanceReader, instanceWriter);
    }

    public boolean isCompatible(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsClassAttributeCallType.$$$reportNull$$$0(3);
        }
        return !call.getArguments().isEmpty();
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean process(@NotNull Processor<? super Symbol> processor, @NotNull Symbol symbol, @NotNull RCall call, PsiElement invocationPoint) {
        if (processor == null) {
            RailsClassAttributeCallType.$$$reportNull$$$0(4);
        }
        if (symbol == null) {
            RailsClassAttributeCallType.$$$reportNull$$$0(5);
        }
        if (call == null) {
            RailsClassAttributeCallType.$$$reportNull$$$0(6);
        }
        MyData data = (MyData)call.getData(new RubyCallType[]{this});
        for (String attribute : data.getAttributes()) {
            if (!processor.process(new PsiElementSymbol<RCall>(call, attribute, Type.CLASS_FIELD_READER))) {
                return false;
            }
            if (!processor.process(new PsiElementSymbol<RCall>(call, attribute + "=", Type.CLASS_FIELD_WRITER))) {
                return false;
            }
            if (data.hasSingletonPredicate() && !processor.process(new PsiElementSymbol<RCall>(call, attribute + "?", Type.CLASS_METHOD))) {
                return false;
            }
            if (data.hasInstanceReader() && !processor.process(new PsiElementSymbol<RCall>(call, attribute, Type.FIELD_READER))) {
                return false;
            }
            if (data.hasInstanceWriter() && !processor.process(new PsiElementSymbol<RCall>(call, attribute + "=", Type.FIELD_WRITER))) {
                return false;
            }
            if (!data.hasInstancePredicate() || processor.process(new PsiElementSymbol<RCall>(call, attribute + "?", Type.INSTANCE_METHOD))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/RailsClassAttributeCallType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompatible";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class MyData {
        final List<String> myAttributes;
        final boolean myInstanceAccessor;
        final boolean myInstancePredicate;
        final boolean myInstanceReader;
        final boolean myInstanceWriter;

        MyData(@NotNull List<String> attributes, boolean instanceAccessor, boolean instancePredicate, boolean instanceReader, boolean instanceWriter) {
            if (attributes == null) {
                MyData.$$$reportNull$$$0(0);
            }
            this.myAttributes = Collections.unmodifiableList(new ArrayList<String>(attributes));
            this.myInstanceAccessor = instanceAccessor;
            this.myInstancePredicate = instancePredicate;
            this.myInstanceReader = instanceReader;
            this.myInstanceWriter = instanceWriter;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MyData data = (MyData)other;
            return this.myInstanceAccessor == data.myInstanceAccessor && this.myInstancePredicate == data.myInstancePredicate && this.myInstanceReader == data.myInstanceReader && this.myInstanceWriter == data.myInstanceWriter && Objects.equals(this.myAttributes, data.myAttributes);
        }

        @NotNull
        public List<String> getAttributes() {
            List<String> list = this.myAttributes;
            if (list == null) {
                MyData.$$$reportNull$$$0(1);
            }
            return list;
        }

        public int hashCode() {
            int result = this.myAttributes.hashCode();
            result = 31 * result + Boolean.hashCode(this.myInstanceAccessor);
            result = 31 * result + Boolean.hashCode(this.myInstancePredicate);
            result = 31 * result + Boolean.hashCode(this.myInstanceReader);
            result = 31 * result + Boolean.hashCode(this.myInstanceWriter);
            return result;
        }

        public boolean hasInstancePredicate() {
            return this.myInstancePredicate && this.myInstanceReader && this.myInstanceAccessor;
        }

        public boolean hasInstanceReader() {
            return this.myInstanceReader && this.myInstanceAccessor;
        }

        public boolean hasInstanceWriter() {
            return this.myInstanceWriter && this.myInstanceAccessor;
        }

        public boolean hasSingletonPredicate() {
            return this.myInstancePredicate;
        }

        public String toString() {
            return String.format("MyData{myAttributes=%s, myInstanceAccessor=%s, myInstancePredicate=%s, myInstanceReader=%s, myInstanceWriter=%s}", this.myAttributes, this.myInstanceAccessor, this.myInstancePredicate, this.myInstanceReader, this.myInstanceWriter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/RailsClassAttributeCallType$MyData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/RailsClassAttributeCallType$MyData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

