/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.callTypes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.DelegateProducedSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesService;

public final class DelegateCallType
extends RubyCallTypeBase<MyData> {
    public static final DelegateCallType INSTANCE = new DelegateCallType();

    private DelegateCallType() {
        super("delegate");
    }

    @NotNull
    public MyData getCallData(@NotNull RPossibleCall call) {
        if (call == null) {
            DelegateCallType.$$$reportNull$$$0(0);
        }
        List<String> delegates = call.getArguments().stream().flatMap(argument -> RubyCallTypesService.instance().evaluateArgument(argument, true).getAllStrings().stream()).collect(Collectors.toList());
        String to = RubyInterpretUtil.evaluateOptionValue(call, "to", "");
        String prefix = Optional.ofNullable(RubyInterpretUtil.evaluateOptionValue(call, "prefix")).map(value -> (value.equals("true") ? to : value) + "_").orElse("");
        return new MyData(delegates, to, prefix);
    }

    public boolean isCompatible(@NotNull RPossibleCall call) {
        if (call == null) {
            DelegateCallType.$$$reportNull$$$0(1);
        }
        return !call.getArguments().isEmpty();
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean process(@NotNull Processor<? super Symbol> processor, @NotNull Symbol parent, @NotNull RCall call, PsiElement invocationPoint) {
        if (processor == null) {
            DelegateCallType.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            DelegateCallType.$$$reportNull$$$0(3);
        }
        if (call == null) {
            DelegateCallType.$$$reportNull$$$0(4);
        }
        MyData data = (MyData)call.getData(new RubyCallType[]{this});
        for (String delegate : data.myDelegates) {
            if (processor.process((Object)DelegateCallType.createSymbol(new MyPsiElement(call, data.myPrefix + delegate, delegate), parent, data.myTo))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static String getPrefix(@NotNull RPossibleCall call) {
        RubyCallType callType;
        if (call == null) {
            DelegateCallType.$$$reportNull$$$0(5);
        }
        return (callType = call.getCallType()) instanceof DelegateCallType ? ((MyData)call.getData((RubyCallType[])new RubyCallType[]{(DelegateCallType)callType})).myPrefix : "";
    }

    @NotNull
    private static Symbol createSymbol(@NotNull MyPsiElement declaration, @NotNull Symbol parent, @NotNull String to) {
        if (declaration == null) {
            DelegateCallType.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            DelegateCallType.$$$reportNull$$$0(7);
        }
        if (to == null) {
            DelegateCallType.$$$reportNull$$$0(8);
        }
        return new DelegateProducedSymbol((PsiElement)declaration, declaration.getName(), declaration.myNavigationElementName, to, Type.INSTANCE_METHOD, parent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/DelegateCallType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompatible";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrefix";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createSymbol";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class MyData {
        final List<String> myDelegates;
        final String myTo;
        final String myPrefix;

        public MyData(@NotNull List<String> delegates, @NotNull String to, @NotNull String prefix) {
            if (delegates == null) {
                MyData.$$$reportNull$$$0(0);
            }
            if (to == null) {
                MyData.$$$reportNull$$$0(1);
            }
            if (prefix == null) {
                MyData.$$$reportNull$$$0(2);
            }
            this.myDelegates = delegates;
            this.myTo = to;
            this.myPrefix = prefix;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MyData data = (MyData)other;
            return this.myDelegates.equals(data.myDelegates) && this.myTo.equals(data.myTo) && this.myPrefix.equals(data.myPrefix);
        }

        public int hashCode() {
            int result = this.myDelegates.hashCode();
            result = 31 * result + this.myTo.hashCode();
            result = 31 * result + this.myPrefix.hashCode();
            return result;
        }

        @NotNull
        public String toString() {
            String string = String.format("MyData{myDelegates=%s, myTo='%s', myPrefix='%s'}", this.myDelegates, this.myTo, this.myPrefix);
            if (string == null) {
                MyData.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/DelegateCallType$MyData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/DelegateCallType$MyData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class MyPsiElement
    extends ArgumentFakePsiElement {
        private final String myNavigationElementName;

        private MyPsiElement(@NotNull RCall call, @NotNull String name, @NotNull String navigationElementName) {
            if (call == null) {
                MyPsiElement.$$$reportNull$$$0(0);
            }
            if (name == null) {
                MyPsiElement.$$$reportNull$$$0(1);
            }
            if (navigationElementName == null) {
                MyPsiElement.$$$reportNull$$$0(2);
            }
            super(call, name);
            this.myNavigationElementName = navigationElementName;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            MyPsiElement element = (MyPsiElement)((Object)other);
            return this.myNavigationElementName.equals(element.myNavigationElementName);
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.Nodes.Method;
            if (icon == null) {
                MyPsiElement.$$$reportNull$$$0(3);
            }
            return icon;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getArgumentByName(this.myNavigationElementName);
        }

        @NotNull
        public String getTypeName() {
            String string = RBundle.message((String)"delegated.method");
            if (string == null) {
                MyPsiElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        public int hashCode() {
            return super.hashCode() * 31 + this.myNavigationElementName.hashCode();
        }

        @Nullable
        public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
            String prefix;
            if (name == null) {
                MyPsiElement.$$$reportNull$$$0(5);
            }
            if (!name.startsWith(prefix = StringUtil.trimEnd((String)this.myName, (String)this.myNavigationElementName))) {
                throw new IncorrectOperationException();
            }
            PsiElement identifier = this.getNameIdentifier();
            if (!(identifier instanceof PsiNamedElement)) {
                return null;
            }
            String newName = StringUtil.trimStart((String)name, (String)prefix);
            PsiElement newIdentifier = ((PsiNamedElement)identifier).setName(newName);
            RCall newCall = RCallNavigator.getByRArgument((PsiElement)newIdentifier);
            return newCall != null ? new MyPsiElement(newCall, name, newName) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationElementName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/DelegateCallType$MyPsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/DelegateCallType$MyPsiElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

