/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.ActiveRecordType;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsTypeUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsActiveRecordAssociationSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsActiveRecordRelationSymbol;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyTypeProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class RailsTypeProvider
implements RubyTypeProvider {
    public static final String ACTIVE_RECORD_PERSISTENCE_CLASS_METHODS = "ActiveRecord::Persistence::ClassMethods";
    public static final String ACTIVE_RECORD_RELATION = "ActiveRecord::Relation";
    public static final String ACTIVE_RECORD_SCOPING = "ActiveRecord::Scoping::Named::ClassMethods";
    public static final String ACTIVE_RECORD_QUERYING = "ActiveRecord::Querying";
    public static final String ACTIVE_RECORD_ASSOCIATIONS_COLLECTION_PROXY = "ActiveRecord::Associations::CollectionProxy";
    public static final String ACTIVE_RECORD_QUERY_METHODS = "ActiveRecord::QueryMethods";
    public static final String ACTIVE_RECORD_QUERY_METHODS_WHERE_CHAIN = "ActiveRecord::QueryMethods::WhereChain";
    public static final String ACTIVE_RECORD_CORE_CLASS_METHODS = "ActiveRecord::Core::ClassMethods";
    public static final String ACTIVE_RECORD_DEPRECATED_FINDERS = "ActiveRecord::DeprecatedFinders";
    public static final String ACTIVE_RECORD_FINDER_METHODS = "ActiveRecord::FinderMethods";
    public static final Set<String> ACTIVE_RECORD_FINDERS = Set.of("find", "find_by", "first", "last", "all");
    public static final Set<String> ACTIVE_RECORD_FINDERS_MODULES = Set.of("ApplicationRecord", "ActiveRecord::Base", "ActiveRecord::Base::$$SINGLETON$$", "ActiveRecord::Querying", "ActiveRecord::Core::ClassMethods", "ActiveRecord::DeprecatedFinders", "ActiveRecord::FinderMethods", "ActiveRecord::Associations::CollectionProxy");
    public static final Set<String> ACTIVE_CALCULATIONS = Set.of("average", "count", "maximum", "minimum", "sum", "calculate");
    public static final Set<String> ACTIVE_CALCULATIONS_MODULES = Set.of("ApplicationRecord", "ActiveRecord::Base", "ActiveRecord::Calculations", "ActiveRecord::Calculations::ClassMethods", "ActiveRecord::Querying");
    public static final Set<String> ACTIVE_RELATIONS = Set.of("annotate", "where", "having", "select", "group", "order", "limit", "offset", "joins", "includes", "lock", "readonly", "from");
    public static final Set<String> ACTIVE_RELATIONS_MODULES = Set.of("ApplicationRecord", "ActiveRecord::Base", "ActiveRecord::Relation", "ActiveRecord::Querying", "ActiveRecord::QueryMethods", "ActiveRecord::Core::ClassMethods", "ActiveRecord::Associations::CollectionProxy");
    private static final Set<String> ACTIVE_RECORD_CONSTRUCTORS = Set.of("build", "create", "create!", "find_or_create_by", "find_or_create_by!", "find_or_initialize_by", "new");
    private static final Set<String> ACTIVE_RECORD_CONSTRUCTOR_MODULES = Set.of("ActiveRecord::Relation", "ActiveRecord::Querying", "ActiveRecord::Associations::Association", "ActiveRecord::Associations::CollectionAssociation", "ActiveRecord::Associations::CollectionProxy", "ActiveRecord::Inheritance::ClassMethods", "ActiveRecord::QueryMethods");
    public static final Set<String> ACTIVE_SCOPINGS = new HashSet<String>(Collections.singletonList("all"));
    public static final Set<String> ACTIVE_SCOPING_MODULES = Set.of("ActiveRecord::Scoping::Named::ClassMethods", "ActiveRecord::DeprecatedFinders");
    private static final String WITH_OPTIONS = "with_options";
    private static final String OBJECT_WITH_OPTIONS = "Object.with_options";

    @Nullable
    public RType createTypeBySymbol(@NotNull Symbol symbol, @NotNull List<RType> typeArguments) {
        RType inquirerType;
        if (symbol == null) {
            RailsTypeProvider.$$$reportNull$$$0(0);
        }
        if (typeArguments == null) {
            RailsTypeProvider.$$$reportNull$$$0(1);
        }
        if ((inquirerType = RailsTypeUtil.createStringInquirerType(symbol)) != null) {
            return inquirerType;
        }
        RType activeResourceType = RailsTypeUtil.createActiveResourceType(symbol);
        if (activeResourceType != null) {
            return activeResourceType;
        }
        if (symbol.getModule() == null) {
            return null;
        }
        ActiveRecordType activeRecordType = ActiveRecordType.createActiveRecordType(symbol);
        if (activeRecordType != null) {
            return activeRecordType;
        }
        RType actionMailerType = RailsTypeUtil.createActionMailerType(symbol);
        if (actionMailerType != null) {
            return actionMailerType;
        }
        RailsApp app = RailsApp.fromModule(symbol.getModule());
        if (app != null) {
            return RailsTypeUtil.createApplicationType(app.getProject(), app.getProjectName(), symbol.getFQNWithNesting().getFullPath());
        }
        return null;
    }

    public RType createTypeByRExpression(@NotNull RExpression expression) {
        RailsApp app;
        if (expression == null) {
            RailsTypeProvider.$$$reportNull$$$0(2);
        }
        if ((app = RailsApp.fromPsiElement((PsiElement)expression)) == null) {
            return null;
        }
        return RailsTypeProvider.createTypeForCommand(expression, app);
    }

    @Nullable
    private static RType createTypeForCommand(@NotNull RExpression expression, @NotNull RailsApp app) {
        RPsiElement value;
        RIdentifier identifier;
        if (expression == null) {
            RailsTypeProvider.$$$reportNull$$$0(3);
        }
        if (app == null) {
            RailsTypeProvider.$$$reportNull$$$0(4);
        }
        if (expression instanceof RIdentifier && !(identifier = (RIdentifier)expression).isParameterDeclaration() && !identifier.isLocalVariable()) {
            return RailsTypeProvider.getTypeByCommand((RExpression)identifier, null);
        }
        if (expression instanceof RFid) {
            return RailsTypeProvider.getTypeByCommand(expression, null);
        }
        Project project = expression.getProject();
        if (expression instanceof RCall) {
            RPsiElement value2;
            RCall call = (RCall)expression;
            PsiElement command = call.getPsiCommand();
            if (command instanceof RIdentifier || command instanceof RFid) {
                return RailsTypeProvider.getTypeByCommand((RExpression)command, call.getArguments());
            }
            if (command instanceof RReference && ((value2 = ((RReference)command).getValue()) instanceof RIdentifier || value2 instanceof RFid)) {
                return RailsTypeProvider.getTypeByCommand((RExpression)value2, call.getArguments());
            }
        }
        if (expression instanceof RDotReference && ((value = ((RDotReference)expression).getValue()) instanceof RIdentifier || value instanceof RFid)) {
            return RailsTypeProvider.getTypeByCommand((RExpression)value, null);
        }
        if (expression instanceof RColonReference || expression instanceof RTopConstReference) {
            String projectName = app.getProjectName();
            String typeName = expression.getText();
            return RailsTypeUtil.createApplicationType(project, projectName, typeName);
        }
        return null;
    }

    @Nullable
    private static RType getTypeByCommand(@NotNull RExpression command, @Nullable List<RPsiElement> arguments) {
        RType selfType;
        Symbol selfSymbol;
        RExpression expression;
        RPsiElement receiver;
        String methodName;
        if (command == null) {
            RailsTypeProvider.$$$reportNull$$$0(5);
        }
        if ((methodName = command.getName()) == null) {
            return null;
        }
        RType type = RailsTypeProvider.getType(command, methodName, ACTIVE_SCOPINGS, ACTIVE_SCOPING_MODULES, (Function<Symbol, RType>)((NullableFunction)container -> RailsTypeUtil.createActiveRecordRelationType(container, (PsiElement)command)));
        if (RTypeUtilCore.isNotEmpty((RType)type)) {
            return type;
        }
        type = RailsTypeProvider.getType(command, methodName, ACTIVE_CALCULATIONS, ACTIVE_CALCULATIONS_MODULES, (Function<Symbol, RType>)((NullableFunction)container -> RailsTypeUtil.getActiveCalculationType(methodName, command, container)));
        if (RTypeUtilCore.isNotEmpty((RType)type)) {
            return type;
        }
        type = RailsTypeProvider.getType(command, methodName, ACTIVE_RELATIONS, ACTIVE_RELATIONS_MODULES, (Function<Symbol, RType>)((Function)container -> {
            if (methodName.equals("where") && ContainerUtil.isEmpty((Collection)arguments)) {
                return RTypeFactory.createTypeByFQN(container.getProject(), ACTIVE_RECORD_QUERY_METHODS_WHERE_CHAIN);
            }
            return RailsTypeUtil.createActiveRecordRelationType(container, (PsiElement)command);
        }));
        if (RTypeUtilCore.isNotEmpty((RType)type)) {
            return type;
        }
        type = RailsTypeProvider.getType(command, methodName, ACTIVE_RECORD_CONSTRUCTORS, ACTIVE_RECORD_CONSTRUCTOR_MODULES, (Function<Symbol, RType>)((Function)container -> RTypeFactory.createTypeBySymbol(container)));
        if (RTypeUtilCore.isNotEmpty((RType)type)) {
            return type;
        }
        if (methodName.equals("not") && (receiver = (RPsiElement)ObjectUtils.doIfNotNull((Object)RReferenceNavigator.getReferenceByRightPart((PsiElement)command), RReference::getReceiver)) instanceof RExpression && (type = RailsTypeProvider.getType(expression = (RExpression)receiver, receiver.getName(), Collections.singleton("where"), ACTIVE_RELATIONS_MODULES, (Function<Symbol, RType>)((Function)container -> RailsTypeUtil.createActiveRecordRelationType(container, (PsiElement)command)))) != null && (selfSymbol = RTypeUtilCore.getBirthTypeSymbol((RType)(selfType = command instanceof RPossibleCall ? RTypeUtil.getTypeForReceiver((RPossibleCall)command) : RTypeUtil.getTypeForSelf((PsiElement)command)))) != null && FQN.same((FQN)selfSymbol.getFQNWithNesting(), (String)ACTIVE_RECORD_QUERY_METHODS_WHERE_CHAIN)) {
            return type;
        }
        return null;
    }

    @Nullable
    private static RType getType(@NotNull RExpression expression, @Nullable String methodName, Set<String> shortNames, Set<String> moduleNames, Function<Symbol, RType> computable) {
        if (expression == null) {
            RailsTypeProvider.$$$reportNull$$$0(6);
        }
        if (methodName != null && shortNames.contains(methodName)) {
            Symbol modelSymbol = RailsTypeProvider.getModelContextSymbol(expression);
            if (!ActiveRecordModel.isActiveRecordClass(modelSymbol)) {
                return null;
            }
            RReference reference = RReferenceNavigator.getReferenceByRightPart((PsiElement)expression);
            if (reference != null) {
                return RailsTypeProvider.createIfResolveTargetCorrect(moduleNames, computable, modelSymbol, reference.getReference());
            }
            if (!(expression instanceof RIdentifier) || !((RIdentifier)expression).isLocalVariable()) {
                return RailsTypeProvider.createIfResolveTargetCorrect(moduleNames, computable, modelSymbol, expression.getReference());
            }
        }
        return null;
    }

    @Nullable
    private static RType createIfResolveTargetCorrect(@NotNull Set<String> moduleNames, @NotNull Function<Symbol, RType> computable, @NotNull Symbol selfSymbol, @Nullable PsiReference reference) {
        String moduleName;
        Symbol symbol;
        if (moduleNames == null) {
            RailsTypeProvider.$$$reportNull$$$0(7);
        }
        if (computable == null) {
            RailsTypeProvider.$$$reportNull$$$0(8);
        }
        if (selfSymbol == null) {
            RailsTypeProvider.$$$reportNull$$$0(9);
        }
        if ((symbol = ResolveUtil.resolveToSymbolWithCaching(reference)) != null && moduleNames.contains(moduleName = symbol.getFQNWithNesting().getCallerFQN().getFullPath())) {
            return (RType)computable.fun((Object)selfSymbol);
        }
        return null;
    }

    public RType getBlockParameterType(RPsiElement parameter, RPsiElement scope) {
        Symbol symbol;
        RPossibleCall callElement;
        RPossibleCall psiCommand;
        String commandName;
        if (scope instanceof RBlockCall && (commandName = (psiCommand = (callElement = ((RBlockCall)scope).getCall()) instanceof RCall ? ((RCall)callElement).getPsiCommand() : callElement).getText()).endsWith(WITH_OPTIONS) && (symbol = ResolveUtil.resolveToSymbolWithCaching(psiCommand.getReference())) != null && FQN.same((FQN)symbol.getFQNWithNesting(), (String)OBJECT_WITH_OPTIONS)) {
            RPsiElement receiver;
            RPsiElement rPsiElement = receiver = psiCommand instanceof RReference ? ((RReference)psiCommand).getReceiver() : null;
            if (receiver instanceof RExpression) {
                return RTypeUtil.getType((PsiElement)receiver);
            }
            Symbol containerSymbol = SymbolUtil.getScopeContextWithCaching((PsiElement)scope);
            if (containerSymbol == null) {
                return null;
            }
            return RTypeUtil.getTypeForSelf((PsiElement)scope, containerSymbol);
        }
        return null;
    }

    @Nullable
    public static Symbol getModelContextSymbol(@NotNull RExpression expression) {
        if (expression == null) {
            RailsTypeProvider.$$$reportNull$$$0(10);
        }
        if (expression instanceof RPossibleCall) {
            return RailsTypeProvider.getModelContextSymbol(RTypeUtil.getTypeForReceiver((RPossibleCall)expression));
        }
        return RailsTypeProvider.getModelContextSymbol(RTypeUtil.getTypeForSelf((PsiElement)expression));
    }

    @Nullable
    public static Symbol getModelContextSymbol(@NotNull RType type) {
        Symbol selfSymbol;
        if (type == null) {
            RailsTypeProvider.$$$reportNull$$$0(11);
        }
        if ((selfSymbol = RTypeUtilCore.getBirthTypeSymbol((RType)type)) instanceof RailsActiveRecordRelationSymbol) {
            selfSymbol = ((RailsActiveRecordRelationSymbol)selfSymbol).getModelSymbol();
        } else if (selfSymbol instanceof RailsActiveRecordAssociationSymbol) {
            selfSymbol = ((RailsActiveRecordAssociationSymbol)selfSymbol).getModelSymbol();
        }
        if (selfSymbol instanceof SingletonClassSymbol) {
            selfSymbol = ((SingletonClassSymbol)selfSymbol).getOriginSymbol();
        }
        return selfSymbol;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfSymbol";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeBySymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeByRExpression";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeForCommand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeByCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createIfResolveTargetCorrect";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getModelContextSymbol";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

