/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsTypeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicTypeInferenceProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.TypeInferenceComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.TypeInferenceInstance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCall;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;

public final class RailsSymbolicTypeInferenceProvider
implements SymbolicTypeInferenceProvider {
    @Override
    @Nullable
    public SymbolicExpression evaluateSymbolicCall(@NotNull SymbolicExpressionProvider provider, @NotNull SymbolicExecutionContext context, @NotNull SymbolicCall symbolicCall, @NotNull TypeInferenceInstance.CallContext callContext) {
        RType type;
        if (provider == null) {
            RailsSymbolicTypeInferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RailsSymbolicTypeInferenceProvider.$$$reportNull$$$0(1);
        }
        if (symbolicCall == null) {
            RailsSymbolicTypeInferenceProvider.$$$reportNull$$$0(2);
        }
        if (callContext == null) {
            RailsSymbolicTypeInferenceProvider.$$$reportNull$$$0(3);
        }
        Project project = provider.getProject();
        if (!RailsTypeProvider.ACTIVE_RECORD_FINDERS.contains(symbolicCall.getName())) {
            return null;
        }
        RType receiverType = SymbolicTypeInferenceProvider.getReceiverType(symbolicCall, (TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class), callContext);
        Symbol target = receiverType.getMemberForName(symbolicCall.getName(), Symbol.Filter.ACCEPT_ALL, callContext.getInvocationPoint());
        if (target == null || !RailsTypeProvider.ACTIVE_RECORD_FINDERS_MODULES.contains(target.getFQNWithNesting().getCallerFQN().getFullPath())) {
            return null;
        }
        RSymbolType symbolType = RTypeUtil.extractSymbolType(receiverType);
        if (symbolType == null) {
            return null;
        }
        Symbol modelSymbol = RailsTypeProvider.getModelContextSymbol(receiverType);
        if (modelSymbol == null) {
            return null;
        }
        RType modelType = RTypeFactory.createTypeBySymbol(modelSymbol, Collections.emptyList());
        switch (symbolicCall.getName()) {
            case "all": {
                RType rType = RTypeFactory.createArrayType(project, modelType);
                break;
            }
            case "find": {
                RType rType;
                if (symbolicCall.getArguments().size() <= 1) {
                    rType = modelType;
                    break;
                }
                rType = RTypeFactory.createArrayType(project, modelType);
                break;
            }
            case "find_by": {
                RType rType = modelType;
                break;
            }
            case "first": 
            case "last": {
                RType rType;
                if (symbolicCall.getArguments().isEmpty()) {
                    rType = modelType;
                    break;
                }
                rType = RTypeFactory.createArrayType(project, modelType);
                break;
            }
            default: {
                RType rType = type = null;
            }
        }
        if (type == null) {
            return null;
        }
        ThreeState canBeNil = switch (symbolicCall.getName()) {
            case "all", "find" -> ThreeState.NO;
            case "find_by", "first", "last" -> ThreeState.YES;
            default -> ThreeState.UNSURE;
        };
        SymbolicExpression expression = provider.createSymbolicVariable();
        context.withComponent(TypeInferenceComponent.class, it -> it.updateSymbolicExpressionType(expression, type));
        context.withComponent(NilAnalysisComponent.class, it -> it.updateCanBeNil(expression, canBeNil));
        return expression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "provider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "symbolicCall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "callContext";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsSymbolicTypeInferenceProvider";
        objectArray[2] = "evaluateSymbolicCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

