/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public final class RailsRequireUtil {
    private RailsRequireUtil() {
    }

    public static List<VirtualFile> getRailsOuterLoadPath(@NotNull Module module) {
        if (module == null) {
            RailsRequireUtil.$$$reportNull$$$0(0);
        }
        RailsPaths paths = RailsPaths.getInstance(module);
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>(paths.findFiles("vendor"));
        for (VirtualFile root : paths.findFiles("vendor", "rails")) {
            RailsRequireUtil.addAdditionalLoadPathLibsRoots(list, root);
        }
        for (VirtualFile root : paths.findFiles("vendor", "plugins")) {
            RailsRequireUtil.addAdditionalLoadPathLibsRoots(list, root);
        }
        for (VirtualFile root : paths.findFiles("vendor")) {
            RailsRequireUtil.addAdditionalLoadPathLibsRoots(list, root);
        }
        return list;
    }

    public static List<VirtualFile> getRailsDefaultLoadPath(@NotNull Module module) {
        if (module == null) {
            RailsRequireUtil.$$$reportNull$$$0(1);
        }
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        RailsApp app = RailsApp.fromModule(module);
        if (app == null) {
            return list;
        }
        ContainerUtil.addIfNotNull(list, (Object)RailsUtil.getTestsStdUnitRoot(module));
        ContainerUtil.addIfNotNull(list, (Object)RailsUtil.getTestMockEnvironmentRoot(module));
        list.addAll(RailsPaths.getInstance(module).findFiles("app"));
        list.addAll(RailsPaths.getInstance(module).findFiles("app", "services"));
        list.addAll(RailsPaths.getInstance(module).findFiles("app", "apis"));
        list.addAll(RailsPaths.getInstance(module).findFiles("config"));
        list.addAll(RailsPaths.getInstance(module).findFiles("lib"));
        return list;
    }

    public static List<VirtualFile> getRailsImplicitLoadPath(@NotNull Module module) {
        if (module == null) {
            RailsRequireUtil.$$$reportNull$$$0(2);
        }
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        RailsApp app = RailsApp.fromModule(module);
        if (app == null) {
            return Collections.emptyList();
        }
        for (VirtualFile root : RailsPaths.getInstance(module).findFiles("lib")) {
            RailsRequireUtil.addRelativeDirsUnderRoot(list, root, false);
        }
        for (VirtualFile root : RailsPaths.getInstance(module).findFiles("app")) {
            RailsRequireUtil.addRelativeDirsUnderRoot(list, root, false);
        }
        for (VirtualFile root : RailsPaths.getInstance(module).findFiles("config")) {
            RailsRequireUtil.addRelativeDirsUnderRoot(list, root, false);
        }
        return list;
    }

    private static void addRelativeDirsUnderRoot(@NotNull Collection<VirtualFile> list, @Nullable VirtualFile root, boolean checkName) {
        if (list == null) {
            RailsRequireUtil.$$$reportNull$$$0(3);
        }
        if (root != null) {
            for (VirtualFile virtualFile : RubyVirtualFileScanner.getRelativeFilesUnderRoot(root, checkName, false, true)) {
                ContainerUtil.addIfNotNull(list, (Object)virtualFile);
            }
        }
    }

    private static void addAdditionalLoadPathLibsRoots(@NotNull List<VirtualFile> list, @Nullable VirtualFile root) {
        if (list == null) {
            RailsRequireUtil.$$$reportNull$$$0(4);
        }
        if (root != null) {
            for (VirtualFile virtualFile : RubyVirtualFileScanner.findLibsSubDirectories(root.getChildren())) {
                ContainerUtil.addIfNotNull(list, (Object)virtualFile);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsRequireUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRailsOuterLoadPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRailsDefaultLoadPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRailsImplicitLoadPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addRelativeDirsUnderRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addAdditionalLoadPathLibsRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

