/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.associations;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.associations.AssociatedItem;
import org.jetbrains.plugins.ruby.associations.Association;
import org.jetbrains.plugins.ruby.associations.AssociationFactory;
import org.jetbrains.plugins.ruby.rails.associations.AssociationType;
import org.jetbrains.plugins.ruby.rails.associations.RailsAssociatedItem;
import org.jetbrains.plugins.ruby.rails.associations.RailsAssociation;
import org.jetbrains.plugins.ruby.rails.associations.RailsAssociationsCallTypes;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;

public final class RailsAssociationFactory
extends AssociationFactory {
    private static final Set<RubyCallType> TYPES = RailsAssociationsCallTypes.TYPES;
    private static final Set<AssociationType> SINGULAR_ASSOCIATIONS = RailsAssociationsCallTypes.SINGULAR_ASSOCIATIONS;

    private RailsAssociationFactory() {
    }

    public static RailsAssociationFactory getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    @NotNull
    public AssociatedItem createFromClass(@NotNull RClass rClass) {
        if (rClass == null) {
            RailsAssociationFactory.$$$reportNull$$$0(0);
        }
        return new RailsAssociatedItem(rClass);
    }

    @Override
    public boolean isApplicable(@Nullable RClass rClass) {
        return RailsModel.fromClass(rClass) != null;
    }

    @Override
    @Nullable
    public Association createAssociation(AssociatedItem from, RCall call) {
        if (!this.isValidCall((PsiElement)call)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)call);
        if (module == null) {
            return null;
        }
        return new RailsAssociation(module, from, call);
    }

    @Override
    public Set<RubyCallType> getCallTypes() {
        return TYPES;
    }

    @Override
    public Set<AssociationType> getSingularCallTypes() {
        return SINGULAR_ASSOCIATIONS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rClass", "org/jetbrains/plugins/ruby/rails/associations/RailsAssociationFactory", "createFromClass"));
    }

    private static final class InstanceHolder {
        public static final RailsAssociationFactory INSTANCE = new RailsAssociationFactory();

        private InstanceHolder() {
        }
    }
}

