/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.associations;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.associations.AssociatedItem;
import org.jetbrains.plugins.ruby.associations.Association;
import org.jetbrains.plugins.ruby.associations.AssociationFactory;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.ruby.RubyPsiManager;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public final class AssociationsParser
implements Disposable {
    private final Module myModule;
    private Map<AssociatedItem, Set<Association>> myAssociations;

    public static AssociationsParser getInstance(Module module) {
        return (AssociationsParser)module.getService(AssociationsParser.class);
    }

    public AssociationsParser(Module module) {
        this.myModule = module;
        Project project = this.myModule.getProject();
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile modelsRoot : RailsPaths.getInstance(this.myModule).findFiles("app/models")) {
            RubyPsiManager.getInstance(project).addChangeWatcher((PsiElement)manager.findDirectory(modelsRoot), __ -> {
                this.myAssociations = null;
            });
        }
    }

    public synchronized Set<Association> getAllAssociations(@NotNull AssociatedItem model) {
        if (model == null) {
            AssociationsParser.$$$reportNull$$$0(0);
        }
        return this.ensureMapsLoaded(model);
    }

    public synchronized Set<Association> getAllAssociations(RClass rClass) {
        HashSet<Association> associations = new HashSet<Association>();
        for (AssociationFactory factory : (AssociationFactory[])AssociationFactory.EP_NAME.getExtensions()) {
            AssociatedItem item = factory.createAssociatedItem(rClass);
            if (item == null) continue;
            associations.addAll(this.getAllAssociations(item));
        }
        return associations;
    }

    private Set<Association> ensureMapsLoaded(@NotNull AssociatedItem model) {
        if (model == null) {
            AssociationsParser.$$$reportNull$$$0(1);
        }
        if (this.myAssociations == null) {
            this.myAssociations = new HashMap<AssociatedItem, Set<Association>>();
        }
        this.parseAssociations(model);
        return this.myAssociations.get(model);
    }

    private void parseAssociations(@NotNull AssociatedItem model) {
        if (model == null) {
            AssociationsParser.$$$reportNull$$$0(2);
        }
        HashSet<Association> assoc = new HashSet<Association>();
        List<RContainer> classes = RubyFQNUtil.getFQNBasedPartialDeclarations((RContainer)model.getRClass(), true, null);
        for (RContainer aClass : classes) {
            if (!(aClass instanceof RClass)) continue;
            AssociationsParser.addAssociations(model, assoc);
        }
        this.myAssociations.put(model, assoc);
    }

    private static void addAssociations(AssociatedItem model, Set<Association> assoc) {
        List<Association> associations = model.getAssociations();
        assoc.addAll(associations);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "model";
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/associations/AssociationsParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllAssociations";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureMapsLoaded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseAssociations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

