/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.navigation;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.rails.actions.navigation.RailsNavigateFromProvider;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsBaseView;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsMailer;
import org.jetbrains.plugins.ruby.rails.model.RailsMailerTemplate;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;

public final class RailsRelatedFilesProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = PsiUtilCore.getTemplateLanguageFile((PsiElement)((PsiElement)CommonDataKeys.PSI_FILE.getData(dataContext)));
        if (editor == null || file == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RailsRelatedFilesProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        PsiElement element = BaseRefactoringAction.getElementAtCaret((Editor)editor, (PsiFile)file);
        if (element == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RailsRelatedFilesProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<Object> items = new ArrayList<Object>();
        ContainerUtil.addIfNotNull(items, (Object)RailsRelatedFilesProvider.getModelRelatedItem(file, element));
        ContainerUtil.addIfNotNull(items, (Object)RailsRelatedFilesProvider.getViewOwnerRelatedItem(file, element));
        ContainerUtil.addIfNotNull(items, (Object)RailsRelatedFilesProvider.getHelperRelatedItem(file, element));
        items.addAll(RailsRelatedFilesProvider.getViewsRelatedItems(file, element));
        items.addAll(RailsRelatedFilesProvider.getLayoutsRelatedItems(element));
        ContainerUtil.addIfNotNull(items, (Object)RailsRelatedFilesProvider.getSchemaRelatedItem(element));
        ContainerUtil.addIfNotNull(items, (Object)RailsRelatedFilesProvider.getRoutesRelatedItem(element));
        List list = Collections.unmodifiableList(items);
        if (list == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private static GotoRelatedItem getModelRelatedItem(@NotNull PsiFile file, @NotNull PsiElement element) {
        if (file == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(4);
        }
        if (element == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(5);
        }
        for (RailsNavigateFromProvider provider : RailsNavigateFromProvider.EP_NAME.getExtensionList()) {
            RailsModel model = provider.modelBy(element);
            if (model == null || model.getPsiFile() == file) continue;
            return new RailsGotoRelatedItem((PsiElement)model.getRClass(), RBundle.message((String)"ruby.rails.gotoRelated.model.group"), RailsIcons.RAILS_MODEL_ICON, 1);
        }
        return null;
    }

    @Nullable
    private static GotoRelatedItem getViewOwnerRelatedItem(@NotNull PsiFile file, @NotNull PsiElement element) {
        RailsMailerTemplate template;
        if (file == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(7);
        }
        if ((template = RailsMailerTemplate.fromFile(file)) != null && template.getMethod() != null) {
            return new RailsGotoRelatedItem((PsiElement)template.getMethod(), RBundle.message((String)"ruby.rails.gotoRelated.mailer.group"), RubyIcons.Rails.Mailer, 2);
        }
        for (RailsNavigateFromProvider provider : RailsNavigateFromProvider.EP_NAME.getExtensionList()) {
            RailsAction action = provider.viewOwnerActionBy(element);
            if (action != null && action.getViewOwner().getPsiFile() != file) {
                return new RailsGotoRelatedItem((PsiElement)action.getMethod(), RBundle.message((String)"ruby.rails.gotoRelated.controller.group"), AllIcons.Nodes.Controller, 2);
            }
            RailsViewOwner owner = provider.viewOwnerBy(element);
            if (owner == null || owner.getPsiFile() == file) continue;
            if (owner instanceof RailsMailer) {
                return new RailsGotoRelatedItem((PsiElement)owner.getRClass(), RBundle.message((String)"ruby.rails.gotoRelated.mailer.group"), RubyIcons.Rails.Mailer, 2);
            }
            return new RailsGotoRelatedItem((PsiElement)owner.getRClass(), RBundle.message((String)"ruby.rails.gotoRelated.controller.group"), AllIcons.Nodes.Controller, 2);
        }
        return null;
    }

    @Nullable
    private static GotoRelatedItem getHelperRelatedItem(@NotNull PsiFile file, @NotNull PsiElement element) {
        if (file == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(8);
        }
        if (element == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(9);
        }
        for (RailsNavigateFromProvider provider : RailsNavigateFromProvider.EP_NAME.getExtensionList()) {
            RailsHelper helper = provider.helperBy(element);
            if (helper == null || helper.getPsiFile() == file) continue;
            return new RailsGotoRelatedItem((PsiElement)helper.getRModule(), RBundle.message((String)"ruby.rails.gotoRelated.helper.group"), helper.getRModule().getIcon(0), 3);
        }
        return null;
    }

    @NotNull
    private static List<? extends GotoRelatedItem> getViewsRelatedItems(@NotNull PsiFile file, @NotNull PsiElement element) {
        if (file == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(10);
        }
        if (element == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(11);
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        PsiManager psiManager = element.getManager();
        ArrayList<PsiFile> views = new ArrayList<PsiFile>();
        ArrayList viewsDirectories = new ArrayList();
        for (RailsNavigateFromProvider provider : RailsNavigateFromProvider.EP_NAME.getExtensionList()) {
            for (PsiFile viewFile : ContainerUtil.mapNotNull(provider.viewsBy(element, false), RailsBaseView::getPsiFile)) {
                if (viewFile == file) continue;
                views.add(viewFile);
            }
            for (VirtualFile folder : ContainerUtil.mapNotNull(provider.viewsFolderUrlsBy(element), arg_0 -> ((VirtualFileManager)virtualFileManager).findFileByUrl(arg_0))) {
                ContainerUtil.addIfNotNull(viewsDirectories, (Object)psiManager.findDirectory(folder));
            }
        }
        if (views.size() == 1) {
            PsiFile viewFile = (PsiFile)views.get(0);
            List<RailsGotoRelatedItem> list = List.of(new RailsGotoRelatedItem((PsiElement)viewFile, RBundle.message((String)"ruby.rails.gotoRelated.view.group"), viewFile.getIcon(0), 4));
            if (list == null) {
                RailsRelatedFilesProvider.$$$reportNull$$$0(12);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RailsRelatedFilesProvider.$$$reportNull$$$0(13);
            }
            return list;
        }
        VirtualFile root = RailsFacetUtil.getRailsAppHomeDir(module);
        if (root == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RailsRelatedFilesProvider.$$$reportNull$$$0(14);
            }
            return list;
        }
        ArrayList<RailsGotoRelatedItem> items = new ArrayList<RailsGotoRelatedItem>();
        for (PsiDirectory directory : viewsDirectories) {
            String name = RBundle.message((String)"ruby.rails.gotoRelated.views.group");
            String containerName = "(" + (viewsDirectories.size() == 1 ? directory.getName() : VfsUtilCore.getRelativePath((VirtualFile)directory.getVirtualFile(), (VirtualFile)root)) + ")";
            Icon icon = directory.getIcon(0);
            int mnemonic = items.isEmpty() ? 4 : -1;
            items.add(new RailsGotoRelatedItem((PsiElement)directory, name, containerName, icon, mnemonic));
        }
        ArrayList<RailsGotoRelatedItem> arrayList = items;
        if (arrayList == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private static List<? extends GotoRelatedItem> getLayoutsRelatedItems(@NotNull PsiElement element) {
        if (element == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(16);
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        PsiManager psiManager = element.getManager();
        ArrayList layouts = new ArrayList();
        ArrayList layoutsDirectories = new ArrayList();
        for (RailsNavigateFromProvider provider : RailsNavigateFromProvider.EP_NAME.getExtensionList()) {
            layouts.addAll(ContainerUtil.mapNotNull(provider.layoutsBy(element), RailsBaseView::getPsiFile));
            for (VirtualFile folder : ContainerUtil.mapNotNull(provider.layoutsFolderUrlsBy(element), arg_0 -> ((VirtualFileManager)virtualFileManager).findFileByUrl(arg_0))) {
                ContainerUtil.addIfNotNull(layoutsDirectories, (Object)psiManager.findDirectory(folder));
            }
        }
        if (layouts.size() == 1) {
            PsiFile layoutFile = (PsiFile)layouts.get(0);
            List<RailsGotoRelatedItem> list = List.of(new RailsGotoRelatedItem((PsiElement)layoutFile, RBundle.message((String)"ruby.rails.gotoRelated.layout.group"), layoutFile.getIcon(0), 5));
            if (list == null) {
                RailsRelatedFilesProvider.$$$reportNull$$$0(17);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RailsRelatedFilesProvider.$$$reportNull$$$0(18);
            }
            return list;
        }
        VirtualFile root = RailsFacetUtil.getRailsAppHomeDir(module);
        if (root == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RailsRelatedFilesProvider.$$$reportNull$$$0(19);
            }
            return list;
        }
        ArrayList<RailsGotoRelatedItem> items = new ArrayList<RailsGotoRelatedItem>();
        for (PsiDirectory directory : layoutsDirectories) {
            String name = RBundle.message((String)"ruby.rails.gotoRelated.layouts.group");
            String containerName = "(" + (layoutsDirectories.size() == 1 ? directory.getName() : VfsUtilCore.getRelativePath((VirtualFile)directory.getVirtualFile(), (VirtualFile)root)) + ")";
            Icon icon = directory.getIcon(0);
            int mnemonic = items.isEmpty() ? 5 : -1;
            items.add(new RailsGotoRelatedItem((PsiElement)directory, name, containerName, icon, mnemonic));
        }
        ArrayList<RailsGotoRelatedItem> arrayList = items;
        if (arrayList == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Nullable
    private static GotoRelatedItem getSchemaRelatedItem(@NotNull PsiElement element) {
        if (element == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(21);
        }
        for (RailsNavigateFromProvider provider : RailsNavigateFromProvider.EP_NAME.getExtensionList()) {
            PsiElement schemaElement = provider.schemaBy(element);
            if (schemaElement == null) continue;
            return new RailsGotoRelatedItem(schemaElement, RBundle.message((String)"ruby.rails.gotoRelated.schema.group"), AllIcons.Nodes.DataSchema, 6);
        }
        return null;
    }

    @Nullable
    private static GotoRelatedItem getRoutesRelatedItem(@NotNull PsiElement element) {
        if (element == null) {
            RailsRelatedFilesProvider.$$$reportNull$$$0(22);
        }
        for (RailsNavigateFromProvider provider : RailsNavigateFromProvider.EP_NAME.getExtensionList()) {
            PsiElement routesElement = provider.routesBy(element);
            if (routesElement == null) continue;
            return new RailsGotoRelatedItem(routesElement, RBundle.message((String)"ruby.rails.gotoRelated.routes.group"), RailsIcons.RAILS_ROUTES_ICON, 7);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 12, 13, 14, 15, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/navigation/RailsRelatedFilesProvider";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/navigation/RailsRelatedFilesProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewsRelatedItems";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutsRelatedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModelRelatedItem";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getViewOwnerRelatedItem";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHelperRelatedItem";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getViewsRelatedItems";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutsRelatedItems";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaRelatedItem";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRoutesRelatedItem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 12, 13, 14, 15, 17, 18, 19, 20 -> new IllegalStateException(string);
        };
    }

    public static final class RailsGotoRelatedItem
    extends GotoRelatedItem {
        private final @NlsContexts.ListItem String myName;
        @Nullable
        @Nls
        private final String myContainerName;
        @Nullable
        private final Icon myIcon;

        public RailsGotoRelatedItem(@NotNull PsiElement element, @NlsContexts.ListItem @NotNull String name, @Nullable @Nls String containerName, @Nullable Icon icon, int mnemonic) {
            if (element == null) {
                RailsGotoRelatedItem.$$$reportNull$$$0(0);
            }
            if (name == null) {
                RailsGotoRelatedItem.$$$reportNull$$$0(1);
            }
            super(element, RBundle.message((String)"ruby.rails.gotoRelated.application.title"), mnemonic);
            this.myName = name;
            this.myContainerName = containerName;
            this.myIcon = icon;
        }

        public RailsGotoRelatedItem(@NotNull PsiElement element, @NlsContexts.ListItem @NotNull String name, @Nullable Icon icon, int mnemonic) {
            if (element == null) {
                RailsGotoRelatedItem.$$$reportNull$$$0(2);
            }
            if (name == null) {
                RailsGotoRelatedItem.$$$reportNull$$$0(3);
            }
            this(element, name, null, icon, mnemonic);
        }

        public void navigate() {
            PsiDirectory psiDirectory;
            PsiElement psiElement = this.getElement();
            if (psiElement instanceof PsiDirectory && (psiDirectory = (PsiDirectory)psiElement).canNavigate()) {
                psiDirectory.navigate(true);
                return;
            }
            super.navigate();
        }

        @Nullable
        @Nls
        public String getCustomContainerName() {
            return this.myContainerName;
        }

        @NlsContexts.ListItem
        @NotNull
        public String getCustomName() {
            String string = this.myName;
            if (string == null) {
                RailsGotoRelatedItem.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public Icon getCustomIcon() {
            return this.myIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/navigation/RailsRelatedFilesProvider$RailsGotoRelatedItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/navigation/RailsRelatedFilesProvider$RailsGotoRelatedItem";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCustomName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

