/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.actions.navigation.RailsNavigateFromProvider;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsItem;
import org.jetbrains.plugins.ruby.rails.model.RailsMailer;
import org.jetbrains.plugins.ruby.rails.model.RailsMailerTemplate;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;

public final class RailsGoToViewOwnerAction
extends CodeInsightAction {
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new MyHandler();
    }

    protected void update(@NotNull Presentation presentation, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull DataContext dataContext, @Nullable String actionPlace) {
        if (presentation == null) {
            RailsGoToViewOwnerAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            RailsGoToViewOwnerAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            RailsGoToViewOwnerAction.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            RailsGoToViewOwnerAction.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            RailsGoToViewOwnerAction.$$$reportNull$$$0(4);
        }
        super.update(presentation, project, editor, psiFile, dataContext, actionPlace);
        RailsItem item = RailsGoToViewOwnerAction.getViewOwner(editor, psiFile);
        if (item instanceof RailsMailer || item instanceof RailsMailerTemplate) {
            if ("MainMenu".equals(actionPlace)) {
                presentation.setText(RBundle.messagePointer((String)"rails.go.to.mailer.action.title.short"));
            } else {
                presentation.setText(RBundle.messagePointer((String)"rails.go.to.mailer.action.title"));
            }
        } else if (item instanceof RailsController || item instanceof RailsAction) {
            if ("MainMenu".equals(actionPlace)) {
                presentation.setText(RBundle.messagePointer((String)"rails.go.to.controller.action.title.short"));
            } else {
                presentation.setText(RBundle.messagePointer((String)"rails.go.to.controller.action.title"));
            }
        } else if ("MainMenu".equals(actionPlace)) {
            presentation.setText(RBundle.messagePointer((String)"rails.go.to.viewOwner.action.title.short"));
        } else {
            presentation.setText(RBundle.messagePointer((String)"rails.go.to.viewOwner.action.title"));
        }
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            RailsGoToViewOwnerAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RailsGoToViewOwnerAction.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            RailsGoToViewOwnerAction.$$$reportNull$$$0(7);
        }
        return RailsGoToViewOwnerAction.getViewOwner(editor, psiFile) != null;
    }

    @Nullable
    private static RailsItem getViewOwner(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            RailsGoToViewOwnerAction.$$$reportNull$$$0(8);
        }
        if (file == null) {
            RailsGoToViewOwnerAction.$$$reportNull$$$0(9);
        }
        PsiElement element = (PsiElement)ObjectUtils.coalesce((Object)BaseRefactoringAction.getElementAtCaret((Editor)editor, (PsiFile)file), (Object)file);
        RailsMailerTemplate template = RailsMailerTemplate.fromFile(file);
        if (template != null && template.getMethod() != null) {
            return template;
        }
        for (RailsNavigateFromProvider provider : RailsNavigateFromProvider.EP_NAME.getExtensionList()) {
            RailsAction action = provider.viewOwnerActionBy(element);
            if (action == null || file.getManager().areElementsEquivalent((PsiElement)file, (PsiElement)action.getViewOwner().getPsiFile())) continue;
            return action;
        }
        for (RailsNavigateFromProvider provider : RailsNavigateFromProvider.EP_NAME.getExtensionList()) {
            RailsViewOwner owner = provider.viewOwnerBy(element);
            if (owner == null || owner.getPsiFile() == file) continue;
            return owner;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/navigation/RailsGoToViewOwnerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidForFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getViewOwner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyHandler
    implements CodeInsightActionHandler {
        private MyHandler() {
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            RailsItem item;
            if (project == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                MyHandler.$$$reportNull$$$0(1);
            }
            if (psiFile == null) {
                MyHandler.$$$reportNull$$$0(2);
            }
            if ((item = RailsGoToViewOwnerAction.getViewOwner(editor, psiFile)) instanceof RailsMailerTemplate) {
                RailsMailerTemplate template = (RailsMailerTemplate)item;
                RMethod method = template.getMethod();
                if (method != null) {
                    method.navigate(true);
                }
            } else if (item instanceof RailsAction) {
                RailsAction action = (RailsAction)item;
                action.getMethod().navigate(true);
            } else if (item instanceof RailsViewOwner) {
                RailsViewOwner viewOwner = (RailsViewOwner)item;
                viewOwner.getRClass().navigate(true);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiFile";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/rails/actions/navigation/RailsGoToViewOwnerAction$MyHandler";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

