/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators.actions.special;

import com.intellij.DynamicBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorOptions;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorPanel;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsOptionsPane;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.AbstractGenerateForActiveRecordPanel;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;
import org.jetbrains.plugins.ruby.testing.shoulda.ShouldaUtil;

public class GenerateNiftyScaffoldPanel
implements GeneratorPanel {
    private JPanel myContentPanel;
    private GeneratorsOptionsPane myGeneratorsOptionsPane;
    private JComboBox<String> myComboTestFramework;
    private LabeledComponent myGeneratorArgsComponent;
    private TextFieldWithAutoCompletion myGeneratorArgsTextField;
    private GeneratorOptions myOptions;
    @NlsSafe
    private static final String FRAMEWORK_RSPEC = "rspec";
    @NlsSafe
    private static final String FRAMEWORK_TESTUNIT = "testunit";
    @NlsSafe
    private static final String FRAMEWORK_SHOULDA = "shoulda";
    @NlsSafe
    private static final String[] SUPPORTED_FRAMEWORKS = new String[]{null, "testunit", "rspec", "shoulda"};
    private final Module myModule;
    private NiftyScaffoldOptionsPanel myOptionsPanel;

    public GenerateNiftyScaffoldPanel(Module module) {
        this.myModule = module;
        this.$$$setupUI$$$();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(SUPPORTED_FRAMEWORKS);
        this.myComboTestFramework.setRenderer((ListCellRenderer<String>)SimpleListCellRenderer.create((String)RBundle.message((String)"dialog.generate.scaffold.combo.default"), String::valueOf));
        this.myComboTestFramework.setModel(model);
        String defaultFramework = RSpecUtil.isRSpecRailsSupportEnabled(module) ? FRAMEWORK_RSPEC : (ShouldaUtil.isShouldaSupportEnabled(module) ? FRAMEWORK_SHOULDA : null);
        this.myComboTestFramework.setSelectedItem(defaultFramework);
    }

    private void createUIComponents() {
        this.myGeneratorArgsComponent = this.createGeneratorArgsComponent();
    }

    private LabeledComponent<TextFieldWithAutoCompletion<String>> createGeneratorArgsComponent() {
        Ref generatorsArgsFieldWrapper = new Ref();
        LabeledComponent<TextFieldWithAutoCompletion<String>> myComponent = AbstractGenerateForActiveRecordPanel.createGeneratorArgsComponent(this.myModule.getProject(), RBundle.message((String)"dialog.generate.scaffold.label.arguments.text"), (Ref<? super TextFieldWithAutoCompletion>)generatorsArgsFieldWrapper);
        this.myGeneratorArgsTextField = (TextFieldWithAutoCompletion)generatorsArgsFieldWrapper.get();
        return myComponent;
    }

    @Override
    public void initPanel(@NotNull GeneratorOptions options, @NotNull Module module) {
        if (options == null) {
            GenerateNiftyScaffoldPanel.$$$reportNull$$$0(0);
        }
        if (module == null) {
            GenerateNiftyScaffoldPanel.$$$reportNull$$$0(1);
        }
        this.myOptions = options;
        this.myOptionsPanel = new NiftyScaffoldOptionsPanel();
        this.myGeneratorsOptionsPane.initPanel(options, module);
        this.myOptionsPanel.myCBSkipTimestamps.setSelected(options.MODEL_SKIP_TIMESTAMPS);
        this.myOptionsPanel.myCBSkipMigration.setSelected(options.MODEL_SKIP_MIGRATION);
        this.myOptionsPanel.myCBSkipModel.setSelected(options.NSCAFFOLD_SKIP_MODEL);
        this.myOptionsPanel.myCBSkipController.setSelected(options.NSCAFFOLD_SKIP_CONTROLLER);
        this.myOptionsPanel.myCBHaml.setSelected(options.NSCAFFOLD_HAML);
        this.myOptionsPanel.myCBInvert.setSelected(options.NSCAFFOLD_INVERT);
        if (ArrayUtil.contains((String)options.TEST_FRAMEWORK, (String[])SUPPORTED_FRAMEWORKS)) {
            this.myComboTestFramework.setSelectedItem(options.TEST_FRAMEWORK);
        }
    }

    @Override
    @NotNull
    public JPanel getContent() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            GenerateNiftyScaffoldPanel.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Override
    public JComponent getOptionsPanel() {
        return this.myOptionsPanel.myPanel;
    }

    @Override
    @NotNull
    public String getGeneratorArgs() {
        Object selectedFramework;
        StringBuilder buff = new StringBuilder();
        buff.append(this.myGeneratorArgsTextField.getText().trim());
        if (this.myOptionsPanel.myCBSkipTimestamps.isSelected()) {
            GeneratorsUtil.GeneratorsCmdOption.MODEL_SKIP_TIMESTAMPS.addTo(buff);
        }
        if (this.myOptionsPanel.myCBSkipMigration.isSelected()) {
            GeneratorsUtil.GeneratorsCmdOption.MODEL_SKIP_MIGRATION.addTo(buff);
        }
        if (this.myOptionsPanel.myCBSkipModel.isSelected()) {
            GeneratorsUtil.GeneratorsCmdOption.NSCAFFOLD_SKIP_MODEL.addTo(buff);
        }
        if (this.myOptionsPanel.myCBSkipController.isSelected()) {
            GeneratorsUtil.GeneratorsCmdOption.NSCAFFOLD_SKIP_CONTROLLER.addTo(buff);
        }
        if (this.myOptionsPanel.myCBInvert.isSelected()) {
            GeneratorsUtil.GeneratorsCmdOption.NSCAFFOLD_INVERT.addTo(buff);
        }
        if (this.myOptionsPanel.myCBHaml.isSelected()) {
            GeneratorsUtil.GeneratorsCmdOption.NSCAFFOLD_HAML.addTo(buff);
        }
        if ((selectedFramework = this.myComboTestFramework.getSelectedItem()) != null) {
            buff.append(" --").append(selectedFramework).append(' ');
        }
        buff.append(this.myGeneratorsOptionsPane.getGeneratorArgs());
        String string = buff.toString();
        if (string == null) {
            GenerateNiftyScaffoldPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public String getDataToValidate() {
        return this.myGeneratorArgsTextField.getText().trim();
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        TextFieldWithAutoCompletion textFieldWithAutoCompletion = this.myGeneratorArgsTextField;
        if (textFieldWithAutoCompletion == null) {
            GenerateNiftyScaffoldPanel.$$$reportNull$$$0(4);
        }
        return textFieldWithAutoCompletion;
    }

    @Override
    public void saveSettings(Project project) {
        this.myGeneratorsOptionsPane.saveSettings(project, this.myOptions);
        this.myOptions.MODEL_SKIP_TIMESTAMPS = this.myOptionsPanel.myCBSkipTimestamps.isSelected();
        this.myOptions.MODEL_SKIP_MIGRATION = this.myOptionsPanel.myCBSkipMigration.isSelected();
        this.myOptions.NSCAFFOLD_SKIP_MODEL = this.myOptionsPanel.myCBSkipModel.isSelected();
        this.myOptions.NSCAFFOLD_SKIP_CONTROLLER = this.myOptionsPanel.myCBSkipController.isSelected();
        this.myOptions.NSCAFFOLD_HAML = this.myOptionsPanel.myCBHaml.isSelected();
        this.myOptions.NSCAFFOLD_INVERT = this.myOptionsPanel.myCBInvert.isSelected();
        Object selectedTestFramework = this.myComboTestFramework.getSelectedItem();
        if (selectedTestFramework != null) {
            this.myOptions.TEST_FRAMEWORK = (String)selectedTestFramework;
        }
    }

    @Override
    @NotNull
    public String getEnvironment() {
        String string = this.myGeneratorsOptionsPane.getEnvironment();
        if (string == null) {
            GenerateNiftyScaffoldPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/generators/actions/special/GenerateNiftyScaffoldPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/actions/special/GenerateNiftyScaffoldPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorArgs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initPanel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myComboTestFramework = jComboBox;
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RBundle", GenerateNiftyScaffoldPanel.class).getString("dialog.generate.scaffold.combo.testframework"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        LabeledComponent labeledComponent = this.myGeneratorArgsComponent;
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", GenerateNiftyScaffoldPanel.class).getString("dialog.generate.scaffold.label.arguments.text"));
        jPanel.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static class NiftyScaffoldOptionsPanel {
        private JCheckBox myCBSkipTimestamps;
        private JCheckBox myCBSkipMigration;
        private JCheckBox myCBSkipModel;
        private JCheckBox myCBSkipController;
        private JCheckBox myCBInvert;
        private JCheckBox myCBHaml;
        private JPanel myPanel;

        public NiftyScaffoldOptionsPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JPanel jPanel;
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myCBSkipTimestamps = jCheckBox6 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/RBundle", NiftyScaffoldOptionsPanel.class).getString("dialog.generate.model.cb.skip-timestamps"));
            jPanel.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCBSkipMigration = jCheckBox5 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/RBundle", NiftyScaffoldOptionsPanel.class).getString("dialog.generate.model.cb.skip-migration"));
            jPanel.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCBSkipModel = jCheckBox4 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/RBundle", NiftyScaffoldOptionsPanel.class).getString("dialog.generate.scaffold.cb.skip-model"));
            jPanel.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCBSkipController = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/RBundle", NiftyScaffoldOptionsPanel.class).getString("dialog.generate.scaffold.cb.skip-controller"));
            jPanel.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCBInvert = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/RBundle", NiftyScaffoldOptionsPanel.class).getString("dialog.generate.scaffold.cb.invert"));
            jCheckBox2.setToolTipText("");
            jPanel.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCBHaml = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", NiftyScaffoldOptionsPanel.class).getString("dialog.generate.scaffold.cb.haml"));
            jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

