/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators.actions.special;

import com.intellij.DynamicBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorOptions;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorPanel;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsOptionsPane;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class GenerateControllerPanel
implements GeneratorPanel {
    private final GenerateControllerOptionsPanel myOptionsPanel;
    private JTextField myControllerName;
    private JPanel myContentPanel;
    private GeneratorsOptionsPane myGeneratorsOptionsPane;
    private JLabel myDescription;
    private JTextField myActionsField;
    private JLabel myNameCaption;
    private GeneratorOptions myOptions;
    @Nullable
    private final Module myModule;

    public GenerateControllerPanel(@NotNull String entityName, @Nullable String defaultName, @Nullable String path, @Nullable Module module) {
        if (entityName == null) {
            GenerateControllerPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myOptionsPanel = new GenerateControllerOptionsPanel();
        this.myOptionsPanel.myControllerDir.setText(path == null ? "" : path);
        this.myNameCaption.setText(RBundle.message((String)"dialog.generate.controller.label.name.text", (Object[])new Object[]{entityName}));
        if (defaultName != null) {
            this.myControllerName.setText(defaultName);
        }
        this.myContentPanel.doLayout();
        this.myModule = module;
    }

    @Override
    public void initPanel(@NotNull GeneratorOptions options, @NotNull Module module) {
        if (options == null) {
            GenerateControllerPanel.$$$reportNull$$$0(1);
        }
        if (module == null) {
            GenerateControllerPanel.$$$reportNull$$$0(2);
        }
        this.myOptions = options;
        this.myGeneratorsOptionsPane.initPanel(options, module);
    }

    @Override
    @NotNull
    public JPanel getContent() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            GenerateControllerPanel.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Override
    @Nullable
    public JComponent getOptionsPanel() {
        return this.myOptionsPanel.myRoot;
    }

    @Override
    @NotNull
    public String getGeneratorArgs() {
        String additionalParameters;
        StringBuilder buff = new StringBuilder();
        String path = FileUtil.toSystemIndependentName((String)this.getControllerDirName());
        if (!StringUtil.isEmpty((String)path)) {
            buff.append(path);
            buff.append("/");
        }
        buff.append(this.getUnderscoredControllerName());
        String actionsString = this.myActionsField.getText();
        if (!actionsString.isEmpty()) {
            buff.append(" ").append(actionsString);
        }
        if (!(additionalParameters = this.myOptionsPanel.myAdditionalParameters.getText()).isEmpty()) {
            buff.append(" ").append(additionalParameters);
        }
        buff.append(this.myGeneratorsOptionsPane.getGeneratorArgs());
        String string = buff.toString();
        if (string == null) {
            GenerateControllerPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public String getDataToValidate() {
        return this.getUnderscoredControllerName();
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JTextField jTextField = this.myControllerName;
        if (jTextField == null) {
            GenerateControllerPanel.$$$reportNull$$$0(5);
        }
        return jTextField;
    }

    @Override
    public void saveSettings(Project project) {
        this.myGeneratorsOptionsPane.saveSettings(project, this.myOptions);
    }

    private String getControllerDirName() {
        return StringUtil.toLowerCase((String)this.myOptionsPanel.myControllerDir.getText().trim());
    }

    private String getUnderscoredControllerName() {
        return NamingConventions.toUnderscoreCase((String)this.myControllerName.getText().trim(), (Module)this.myModule);
    }

    private void createUIComponents() {
        this.myDescription = new JBLabel();
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.myDescription);
    }

    @Override
    @NotNull
    public String getEnvironment() {
        String string = this.myGeneratorsOptionsPane.getEnvironment();
        if (string == null) {
            GenerateControllerPanel.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/generators/actions/special/GenerateControllerPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/actions/special/GenerateControllerPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorArgs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initPanel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        GeneratorsOptionsPane generatorsOptionsPane;
        JLabel jLabel;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myControllerName = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel.add((Component)jTextField2, new GridConstraints(1, 0, 1, 1, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        this.myNameCaption = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RBundle", GenerateControllerPanel.class).getString("dialog.generate.controller.label.name.text"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGeneratorsOptionsPane = generatorsOptionsPane = new GeneratorsOptionsPane();
        jPanel2.add((Component)generatorsOptionsPane, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/RBundle", GenerateControllerPanel.class).getString("new.generate.controller.actions"));
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myActionsField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = this.myDescription;
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/RBundle", GenerateControllerPanel.class).getString("new.generate.controller.actions.text.field.info"));
        jPanel.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        jLabel.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static class GenerateControllerOptionsPanel {
        private JTextField myAdditionalParameters;
        private JTextField myControllerDir;
        private JPanel myRoot;

        public GenerateControllerOptionsPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTextField jTextField;
            JTextField jTextField2;
            JPanel jPanel;
            this.myRoot = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBLabel jBLabel = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/RBundle", GenerateControllerOptionsPanel.class).getString("dialog.generate.controller.label.dir.text"));
            jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RBundle", GenerateControllerOptionsPanel.class).getString("dialog.generate.controller.label.addition.options.text"));
            jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myControllerDir = jTextField2 = new JTextField();
            jPanel.add((Component)jTextField2, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.myAdditionalParameters = jTextField = new JTextField();
            jPanel.add((Component)jTextField, new GridConstraints(3, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myRoot;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

