/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators.actions;

import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.GenerateDialogs;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsModuleCache;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.AbstractScriptAction;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.SimpleGeneratorInputValidator;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class SimpleGeneratorAction
extends AbstractScriptAction {
    private static final Logger LOG = Logger.getInstance(SimpleGeneratorAction.class);
    private static final Object GENERATED_TEST_DELETION_REQUESTOR = new Object();
    private static final int FILES_GENERATED_ROLLBACK_TIMEOUT = 5000;
    @NotNull
    @NlsSafe
    private final String myGeneratorName;

    public SimpleGeneratorAction(@NotNull String name) {
        if (name == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(0);
        }
        this(() -> RBundle.message((String)"new.generate.common.action.description", (Object[])new Object[]{name}), AllIcons.FileTypes.Config, name);
    }

    public SimpleGeneratorAction(@NotNull Supplier<@Nullable @NlsActions.ActionDescription String> descriptionSupplier, @Nullable Icon icon, @NotNull @NlsSafe String name) {
        if (descriptionSupplier == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(1);
        }
        if (name == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(2);
        }
        super(() -> name, descriptionSupplier, icon);
        this.myGeneratorName = name;
        this.addTextOverride("GoToAction", () -> RBundle.message((String)"new.generate.common.action.title", (Object[])new Object[]{this.myGeneratorName}));
    }

    @NotNull
    @NlsSafe
    public String getGeneratorName() {
        String string = this.myGeneratorName;
        if (string == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invokeAction(@NotNull String scriptArguments, @NotNull String environment, @NotNull Module module) {
        if (scriptArguments == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(4);
        }
        if (environment == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(5);
        }
        if (module == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(6);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        assert (sdk != null);
        ArrayList<String> generatedFiles = new ArrayList<String>();
        Ref filesToOpenCount = Ref.create((Object)0);
        ThrowableRunnable runnable = () -> {
            if (!generatedFiles.isEmpty()) {
                for (int i = (Integer)filesToOpenCount.get() - 1; i >= 0; --i) {
                    String filePath = (String)generatedFiles.get(i);
                    GeneratorsUtil.openFileInEditor(module.getProject(), filePath, RailsFacetUtil.getRailsAppHomeDirPath(module));
                }
                SimpleGeneratorAction.notifyByRollback(module, generatedFiles, this.getGeneratorName());
            }
        };
        String[] scriptParameters = this.createScriptParameters(scriptArguments, module);
        if (scriptParameters == null) {
            return;
        }
        GeneratorsUtil.invokeGenerator(module, RBundle.message((String)"new.generate.common.generating.title"), this.getErrorTitle(), scriptParameters, null, (ThrowableRunnable<? extends RuntimeException>)runnable, sdk, generatedFiles, (Ref<Integer>)filesToOpenCount, SimpleGeneratorAction.getEnv(environment, module));
    }

    @NotNull
    private static Map<String, String> getEnv(@NotNull String environment, @NotNull Module module) {
        if (environment == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(7);
        }
        if (module == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(8);
        }
        VirtualFile generateScript = GeneratorsUtil.getGenerateScript(module, true);
        assert (generateScript != null);
        HashMap envs = Maps.newHashMap();
        if (!GeneratorsUtil.isZeusGenerator(generateScript.getPath())) {
            envs.put("RAILS_ENV", environment);
        }
        HashMap hashMap = envs;
        if (hashMap == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(10);
        }
        super.update(event);
        Presentation presentation = event.getPresentation();
        if (!presentation.isVisible()) {
            return;
        }
        Module module = RModuleUtil.getInstance().getModule(event.getDataContext());
        boolean isVisible = module != null && RailsFacetUtil.hasRailsSupport(module);
        boolean isEnabled = isVisible && RModuleUtil.getInstance().findRubySdkForModule(module) != null;
        presentation.setVisible(isVisible);
        presentation.setEnabled(isEnabled);
    }

    protected SimpleGeneratorInputValidator createValidator(@NotNull Module module, @Nullable PsiDirectory directory) {
        if (module == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(11);
        }
        return new SimpleGeneratorInputValidator(this, module, directory);
    }

    @Override
    protected void checkArgsBeforeInvoke(@NotNull String generatorArgs, @Nullable PsiDirectory directory) throws IncorrectOperationException {
        if (generatorArgs == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(12);
        }
    }

    @Override
    protected String @Nullable [] createScriptParameters(String inputString, @NotNull Module module) {
        if (module == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(13);
        }
        String railsAppHomePath = RailsFacetUtil.getRailsAppHomeDirPath(module);
        assert (railsAppHomePath != null);
        ArrayList<String> parameters = new ArrayList<String>();
        VirtualFile generateScript = GeneratorsUtil.getGenerateScript(module, true);
        if (generateScript == null) {
            ToolWindowManager.getInstance((Project)module.getProject()).notifyByBalloon("Run", MessageType.ERROR, RBundle.message((String)"notification.content.cannot.find.corresponding.generator"));
            return null;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        LOG.assertTrue(sdk != null, (Object)"sdk must not be null here");
        String generateScriptPath = generateScript.getPath();
        parameters.add(RubySdkUtil.convertToRemote(sdk, module, generateScriptPath));
        Collections.addAll(parameters, GeneratorsUtil.buildParamsForRailsGenerator(generateScriptPath));
        parameters.add(this.myGeneratorName);
        MergingCommandLineArgumentsProvider.collectArguments(inputString, parameters);
        return ArrayUtilRt.toStringArray(parameters);
    }

    @Override
    @NlsContexts.DialogTitle
    protected String getGenerateDialogTitle(@Nullable Module module) {
        if (RModuleUtil.getInstance().isInMultiProject(module)) {
            return RBundle.message((String)"new.generate.common.action.prompt.title.ex", (Object[])new Object[]{this.myGeneratorName, module.getName()});
        }
        return RBundle.message((String)"new.generate.common.action.prompt.title", (Object[])new Object[]{this.myGeneratorName});
    }

    @Override
    @NlsContexts.DialogTitle
    @NlsSafe
    protected String getErrorTitle() {
        return RBundle.message((String)"new.generate.common.error.title");
    }

    @Override
    protected PsiElement[] invokeDialog(@NotNull Module module, @Nullable PsiDirectory directory) {
        if (module == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(14);
        }
        SimpleGeneratorInputValidator validator = this.createValidator(module, directory);
        GenerateDialogs.showGenerateDialog(module, this.getGenerateDialogTitle(module), validator);
        return validator.getCreatedElements();
    }

    @Override
    protected boolean validateBeforeInvokeDialog(Module module) {
        if (!RailsUtil.hasRailsSupportInSDKOrModule(RModuleUtil.getInstance().findRubySdkForModule(module), module)) {
            Messages.showErrorDialog((Project)module.getProject(), (String)RBundle.message((String)"new.generate.common.error.no.rails"), (String)RBundle.message((String)"action.registered.shortcut.execute.disabled.title"));
            return false;
        }
        return true;
    }

    public static void notifyByRollback(@NotNull Module module, @NotNull List<String> generatedFiles, @NotNull String generatorName) {
        if (module == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(15);
        }
        if (generatedFiles == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(16);
        }
        if (generatorName == null) {
            SimpleGeneratorAction.$$$reportNull$$$0(17);
        }
        GeneratorsModuleCache.getInstance(module).registerGeneratorUndoAction(() -> {
            if (module.isDisposed()) {
                return;
            }
            for (String relativePath : generatedFiles) {
                String railsAppHomeDirPath = RailsFacetUtil.getRailsAppHomeDirPath(module);
                File file = new File(railsAppHomeDirPath, relativePath);
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                if (virtualFile == null) continue;
                try {
                    virtualFile.delete(GENERATED_TEST_DELETION_REQUESTOR);
                }
                catch (IOException e) {
                    LOG.error("Cannot delete generated test; " + e.getMessage());
                }
            }
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Notification notification = GeneratorsModuleCache.getInstance(module).createGeneratorRollbackNotification(generatorName);
        notification.notify(module.getProject());
        Timer timer = new Timer(5000, event -> {
            if (module.isDisposed()) {
                return;
            }
            Balloon balloon = ToolWindowManager.getInstance((Project)module.getProject()).getToolWindowBalloon("Run");
            if (balloon != null) {
                balloon.hide();
            }
            notification.expire();
        });
        timer.setRepeats(false);
        timer.start();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionSupplier";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/generators/actions/SimpleGeneratorAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptArguments";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorArgs";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedFiles";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/actions/SimpleGeneratorAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEnv";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createValidator";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkArgsBeforeInvoke";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createScriptParameters";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invokeDialog";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "notifyByRollback";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9 -> new IllegalStateException(string);
        };
    }
}

