/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import java.util.List;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.workspace.storage.ExtensionsKt;
import org.jetbrains.plugins.ruby.rails.workspace.storage.RailsGeneratorEntity;

public final class GeneratorKeymapExtension
implements KeymapExtension {
    public KeymapGroup createGroup(Condition<? super AnAction> filtered, Project project) {
        Module module = GeneratorKeymapExtension.findModuleWithRailsSupport(project);
        if (module == null) {
            return null;
        }
        List generators = SequencesKt.toList(ExtensionsKt.getRailsGenerators(module));
        if (generators.isEmpty()) {
            return null;
        }
        KeymapGroup group = KeymapGroupFactory.getInstance().createGroup("Generators");
        for (RailsGeneratorEntity generator : generators) {
            String actionId = generator.getActionId();
            if (filtered != null && !filtered.value((Object)ActionManager.getInstance().getActionOrStub(actionId))) continue;
            group.addActionId(actionId);
        }
        return group;
    }

    @Nullable
    private static Module findModuleWithRailsSupport(Project project) {
        Module[] modules;
        if (project == null) {
            return null;
        }
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            if (!RailsFacetUtil.hasRailsSupport(module)) continue;
            return module;
        }
        return null;
    }
}

