/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.actions.RailsActionsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.workspace.sync.RailsGeneratorsManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public class ReloadGeneratorsAction
extends AnAction
implements DumbAware {
    private static AnAction myInstance;

    public static AnAction getInstance() {
        if (myInstance == null) {
            myInstance = ActionManager.getInstance().getAction("org.jetbrains.plugins.ruby.rails.actions.generators.ReloadGeneratorsAction");
        }
        return myInstance;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            ReloadGeneratorsAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)ObjectUtils.coalesce((Object)event.getProject(), (Object)((Project)event.getData(CommonDataKeys.PROJECT)))) == null || project.isDisposed()) {
            return;
        }
        Module module = RModuleUtil.getInstance().getModule(event.getDataContext());
        assert (module != null);
        FileDocumentManager.getInstance().saveAllDocuments();
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            String msg = RBundle.message((String)"rails.facet.action.regenerate.generators.error.wrong.sdk");
            String title = RBundle.message((String)"action.registered.shortcut.execute.disabled.title");
            Messages.showErrorDialog((Project)module.getProject(), (String)msg, (String)title);
            return;
        }
        RailsGeneratorsManager.getInstance(project).refresh(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ReloadGeneratorsAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent event) {
        Module module;
        if (event == null) {
            ReloadGeneratorsAction.$$$reportNull$$$0(2);
        }
        boolean isEnabled = (module = RModuleUtil.getInstance().getModule(event.getDataContext())) != null && RailsFacetUtil.hasRailsSupport(module);
        event.getPresentation().setEnabled(isEnabled);
        RailsActionsUtil.setRailsActionVisibility(event.getDataContext(), event.getPresentation());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/generators/ReloadGeneratorsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/ReloadGeneratorsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

