/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;

public final class GeneratorsModuleCache
implements Disposable {
    private static final Logger LOG = Logger.getInstance(GeneratorsModuleCache.class);
    private final Module myModule;
    private final List<Runnable> myUndoActions = ContainerUtil.createConcurrentList();

    public static GeneratorsModuleCache getInstance(@NotNull Module module) {
        if (module == null) {
            GeneratorsModuleCache.$$$reportNull$$$0(0);
        }
        return (GeneratorsModuleCache)module.getService(GeneratorsModuleCache.class);
    }

    public void dispose() {
    }

    public GeneratorsModuleCache(Module module) {
        this.myModule = module;
    }

    public static boolean appendGemToGemfile(@NotNull Module module, @NotNull String gemName) {
        VirtualFile gemfile;
        if (module == null) {
            GeneratorsModuleCache.$$$reportNull$$$0(1);
        }
        if (gemName == null) {
            GeneratorsModuleCache.$$$reportNull$$$0(2);
        }
        if ((gemfile = BundlerUtil.getGemfile(module)) == null) {
            return false;
        }
        try {
            StringBuilder builder2 = new StringBuilder(VfsUtilCore.loadText((VirtualFile)gemfile));
            String oldContent = builder2.toString();
            builder2.append("\n\ngem '").append(gemName).append('\'');
            return (Boolean)ApplicationManager.getApplication().runWriteAction(() -> {
                VfsUtil.saveText((VirtualFile)gemfile, (String)builder2.toString());
                GeneratorsModuleCache.getInstance(module).registerGeneratorUndoAction(() -> {
                    try {
                        VfsUtil.saveText((VirtualFile)gemfile, (String)oldContent);
                    }
                    catch (IOException e) {
                        LOG.error("Cannot rollback Gemfile; " + e.getMessage());
                    }
                });
                return true;
            });
        }
        catch (IOException e) {
            LOG.warn("Cannot update Gemfile; " + e.getMessage());
            return false;
        }
    }

    public void registerGeneratorUndoAction(@NotNull Runnable undoAction) {
        if (undoAction == null) {
            GeneratorsModuleCache.$$$reportNull$$$0(3);
        }
        this.myUndoActions.add(undoAction);
    }

    private void unregisterGeneratorUndoActions() {
        this.myUndoActions.clear();
    }

    @NotNull
    public Notification createGeneratorNotFoundNotification(@NotNull String generatorName) {
        if (generatorName == null) {
            GeneratorsModuleCache.$$$reportNull$$$0(4);
        }
        final Notification notification = new Notification("Generate Rails test", RBundle.message((String)"generator.notification.not.found.title"), RBundle.message((String)"generator.notification.not.found.content", (Object[])new Object[]{generatorName}), NotificationType.WARNING).whenExpired(() -> this.unregisterGeneratorUndoActions());
        notification.addAction((AnAction)new DumbAwareAction(RBundle.message((String)"generator.notification.not.found.action.rollback")){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                GeneratorsModuleCache.this.rollbackTestGenerationSteps();
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsModuleCache$1", "actionPerformed"));
            }
        });
        Notification notification2 = notification;
        if (notification2 == null) {
            GeneratorsModuleCache.$$$reportNull$$$0(5);
        }
        return notification2;
    }

    public Notification createGeneratorRollbackNotification(@NotNull String generatorName) {
        if (generatorName == null) {
            GeneratorsModuleCache.$$$reportNull$$$0(6);
        }
        final Notification notification = new Notification("Generate Rails test", RBundle.message((String)"generator.notification.after.title"), RBundle.message((String)"generator.notification.after.content", (Object[])new Object[]{generatorName}), NotificationType.INFORMATION).whenExpired(() -> this.unregisterGeneratorUndoActions());
        notification.addAction((AnAction)new DumbAwareAction(RBundle.message((String)"generator.notification.not.found.action.rollback")){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                GeneratorsModuleCache.this.rollbackTestGenerationSteps();
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsModuleCache$2", "actionPerformed"));
            }
        });
        return notification;
    }

    private void rollbackTestGenerationSteps() {
        WriteCommandAction.runWriteCommandAction((Project)this.myModule.getProject(), () -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            for (Runnable action : this.myUndoActions) {
                action.run();
            }
            this.myUndoActions.clear();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoAction";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsModuleCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsModuleCache";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createGeneratorNotFoundNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendGemToGemfile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerGeneratorUndoAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createGeneratorNotFoundNotification";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createGeneratorRollbackNotification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

