/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.execution;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.ArrayUtilRt;
import icons.RubyIcons;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.actions.RailsActionsUtil;
import org.jetbrains.plugins.ruby.rails.actions.execution.RunRailsScriptForm;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunnerOptions;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyScriptRunner;
import org.jetbrains.plugins.ruby.ruby.run.filters.FileLinksFilterUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class RunRailsScriptAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(RunRailsScriptAction.class);

    public RunRailsScriptAction() {
        this.getTemplatePresentation().setIcon(RubyIcons.Ruby.RubyScript);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            RunRailsScriptAction.$$$reportNull$$$0(0);
        }
        Module module = RModuleUtil.getInstance().getModule(event.getDataContext());
        assert (module != null);
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile scriptsFolder = RailsUtil.getScriptsRoot(module);
        LOG.assertTrue(RunRailsScriptAction.checkScriptsDir(module), (Object)"./script directory doesn't exist!");
        RunRailsScriptDialog dialog = new RunRailsScriptDialog(module.getProject(), module.getName(), scriptsFolder);
        dialog.setTitle(RBundle.message((String)"rails.actions.execution.run.rails.script.title"));
        if (dialog.showAndGet()) {
            String scriptFolderPath;
            File scriptFile;
            String scriptName = dialog.getScriptName();
            String arguments = dialog.getArguments();
            if (!RunRailsScriptAction.checkScriptsDir(module)) {
                String errorMsg = RBundle.message((String)"rails.actions.execution.run.rails.script.error.no.scripts.folder", (Object[])new Object[]{module.getName()});
                String errorTitle = RBundle.message((String)"actions.types.ruby.script.errors.execution.error.title");
                Messages.showErrorDialog((Project)module.getProject(), (String)errorMsg, (String)errorTitle);
            }
            if ((scriptFile = FileLinksFilterUtil.getFileByRubyLink((scriptFolderPath = scriptsFolder.getPath()) + File.separator + scriptName)) == null) {
                scriptFile = FileLinksFilterUtil.getFileByRubyLink(scriptName);
            }
            if (scriptFile == null) {
                String errorMsg = RBundle.message((String)"rails.actions.execution.run.rails.script.error.script.want.found", (Object[])new Object[]{scriptName});
                String errorTitle = RBundle.message((String)"actions.types.ruby.script.errors.execution.error.title");
                Messages.showErrorDialog((Project)module.getProject(), (String)errorMsg, (String)errorTitle);
                return;
            }
            RunRailsScriptAction.runRailsScript(module, scriptFile.getPath(), arguments);
        }
    }

    private static void runRailsScript(final Module module, String scriptName, String arguments) {
        String title = RBundle.message((String)"rails.actions.execution.run.rails.script.title");
        Filter[] filters = new Filter[]{new RStackTraceFilter(module)};
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        LOG.assertTrue(sdk != null);
        String[] params = RunRailsScriptAction.getRailsScriptRunParams(RubySdkUtil.convertToRemote(sdk, module, scriptName), arguments);
        MergingCommandLineArgumentsProvider provider = new MergingCommandLineArgumentsProvider(params, null, null, null);
        ProcessListener processListener = new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                RailsFacetUtil.refreshRailsAppHomeContent(module);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/rails/actions/execution/RunRailsScriptAction$1", "processTerminated"));
            }
        };
        ConsoleRunnerOptions consoleRunnerOptions = ConsoleRunnerOptions.builder(module, title).withProcessListeners(processListener).withFilters(filters).withWorkingDirectory(RailsFacetUtil.getRailsAppHomeDirPath(module)).build();
        RubyScriptRunner.runRubyScriptInConsole(provider, sdk, consoleRunnerOptions);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunRailsScriptAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            RunRailsScriptAction.$$$reportNull$$$0(2);
        }
        RunRailsScriptAction.setEnableAndVisibilityFlags(event);
    }

    private static void setEnableAndVisibilityFlags(AnActionEvent event) {
        boolean isEnabled;
        Module module = RModuleUtil.getInstance().getModule(event.getDataContext());
        boolean isVisible = module != null && RailsFacetUtil.hasRailsSupport(module);
        boolean bl = isEnabled = isVisible && RunRailsScriptAction.checkScriptsDir(module);
        if (!ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace())) {
            event.getPresentation().setVisible(isVisible);
        }
        event.getPresentation().setEnabled(isEnabled);
        RailsActionsUtil.setRailsActionVisibility(event.getDataContext(), event.getPresentation());
    }

    private static boolean checkScriptsDir(Module module) {
        VirtualFile scriptsRoot = RailsUtil.getScriptsRoot(module);
        return scriptsRoot != null && scriptsRoot.isValid();
    }

    private static String[] getRailsScriptRunParams(String scriptName, String arguments) {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(scriptName);
        MergingCommandLineArgumentsProvider.collectArguments(arguments, parameters);
        String[] params = ArrayUtilRt.toStringArray(parameters);
        return params;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/execution/RunRailsScriptAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/execution/RunRailsScriptAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class RunRailsScriptDialog
    extends DialogWrapper {
        private final Project myProject;
        private final String myModuleName;
        private final VirtualFile myModuleScriptFolder;
        private TextFieldWithBrowseButton myScriptNameComponent;
        private RawCommandLineEditor myArgumentsComponent;

        protected RunRailsScriptDialog(Project project, @NotNull String moduleName, @NotNull VirtualFile moduleScriptFolder) {
            if (moduleName == null) {
                RunRailsScriptDialog.$$$reportNull$$$0(0);
            }
            if (moduleScriptFolder == null) {
                RunRailsScriptDialog.$$$reportNull$$$0(1);
            }
            super(project, true);
            this.myProject = project;
            this.myModuleName = moduleName;
            this.myModuleScriptFolder = moduleScriptFolder;
            this.init();
        }

        @NotNull
        public String getArguments() {
            assert (this.myArgumentsComponent != null);
            String string = this.myArgumentsComponent.getText().trim();
            if (string == null) {
                RunRailsScriptDialog.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getScriptName() {
            assert (this.myScriptNameComponent != null);
            String string = this.myScriptNameComponent.getText().trim();
            if (string == null) {
                RunRailsScriptDialog.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            RunRailsScriptForm myRunRailsScriptForm = new RunRailsScriptForm(this.myProject, this.myModuleName, this.myModuleScriptFolder);
            this.myScriptNameComponent = myRunRailsScriptForm.getScriptNameComponent();
            this.myArgumentsComponent = myRunRailsScriptForm.getArgumentsComponent();
            return myRunRailsScriptForm.getContentPane();
        }

        protected Action @NotNull [] createActions() {
            this.setOKButtonText(RBundle.message((String)"rails.actions.execution.run.rails.script.dialog.button.ok.caption"));
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                RunRailsScriptDialog.$$$reportNull$$$0(4);
            }
            return actionArray;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myScriptNameComponent.getTextField();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleScriptFolder";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/execution/RunRailsScriptAction$RunRailsScriptDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/execution/RunRailsScriptAction$RunRailsScriptDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArguments";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScriptName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

