/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.templates.TemplateIntegrationUtils;

public class CreateNamedFileFix
implements LocalQuickFix {
    private final String myNewFileName;
    private final String myRelativeDirectory;
    private final VirtualFile myDirectory;
    private final String myType;
    private final String myExtensionKey;
    private final String myDefaultExtension;

    public CreateNamedFileFix(@NotNull String newFileName, @NotNull VirtualFile directory, String extensionKey, String defaultExtension, String type) {
        if (newFileName == null) {
            CreateNamedFileFix.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            CreateNamedFileFix.$$$reportNull$$$0(1);
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Passed 'directory' virtualFile must be a directory, got: " + directory.getPath());
        }
        int pos = newFileName.lastIndexOf(47);
        this.myRelativeDirectory = pos >= 0 ? newFileName.substring(0, pos) : null;
        this.myNewFileName = pos >= 0 ? newFileName.substring(pos + 1) : newFileName;
        this.myDirectory = directory;
        this.myExtensionKey = extensionKey;
        this.myDefaultExtension = defaultExtension;
        this.myType = StringUtil.capitalize((String)type);
    }

    @NotNull
    public String getName() {
        String string = RBundle.message((String)"ruby.action.create.named.file.fix.name", (Object[])new Object[]{this.myType, this.myNewFileName});
        if (string == null) {
            CreateNamedFileFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.action.create.named.file.fix.familyName", (Object[])new Object[]{this.myType});
        if (string == null) {
            CreateNamedFileFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            CreateNamedFileFix.$$$reportNull$$$0(4);
        }
        return null;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            CreateNamedFileFix.$$$reportNull$$$0(5);
        }
        if (previewDescriptor == null) {
            CreateNamedFileFix.$$$reportNull$$$0(6);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            CreateNamedFileFix.$$$reportNull$$$0(7);
        }
        return intentionPreviewInfo;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            CreateNamedFileFix.$$$reportNull$$$0(8);
        }
        if (descriptor == null) {
            CreateNamedFileFix.$$$reportNull$$$0(9);
        }
        CreateNamedFileFix.createFile(project, this.myNewFileName, this.myExtensionKey, this.myDefaultExtension, this.myDirectory, this.myRelativeDirectory, RBundle.message((String)"ruby.action.create.named.file.fix.message"), RBundle.message((String)"ruby.action.create.named.file.fix.title", (Object[])new Object[]{this.myType}));
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void createFile(Project project, String initFileName, String extensionKey, String defaultExtension, @NotNull VirtualFile directory, @Nullable String relativeDirectory, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title) {
        if (directory == null) {
            CreateNamedFileFix.$$$reportNull$$$0(10);
        }
        CreateNamedFileFix.createFile(project, initFileName, extensionKey, defaultExtension, directory, relativeDirectory, message, title, null);
    }

    public static void createFile(Project project, @NlsSafe String initFileName, String extensionKey, String defaultExtension, @NotNull VirtualFile directory, @Nullable String relativeDirectory, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String text) {
        Object fileName;
        if (directory == null) {
            CreateNamedFileFix.$$$reportNull$$$0(11);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        if (extensionKey != null && ((String)initFileName).indexOf(46) < 0) {
            String extension = propertiesComponent.getValue(extensionKey, defaultExtension);
            initFileName = (String)initFileName + "." + extension;
        }
        if ((fileName = ApplicationManager.getApplication().isUnitTestMode() ? initFileName : Messages.showInputDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon(), (String)initFileName, (InputValidator)new NonEmptyInputValidator())) != null) {
            int pos;
            if (extensionKey != null && (pos = ((String)fileName).indexOf(46)) >= 0) {
                propertiesComponent.setValue(extensionKey, ((String)fileName).substring(pos + 1));
            }
            String templateName = ((String)fileName).endsWith("rjs") ? "RJS File" : (((String)fileName).endsWith("js") ? "JavaScript File" : (((String)fileName).endsWith("builder") || ((String)fileName).endsWith("rxml") ? "RXML File" : (String)ObjectUtils.coalesce((Object)TemplateIntegrationUtils.getInstance().getFileTemplateName((String)fileName), (Object)"ERB File")));
            PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(directory);
            if (psiDirectory == null) {
                Logger.getInstance(CreateNamedFileFix.class).warn("Could not get PsiDirectory: " + directory.getPath());
                return;
            }
            if (relativeDirectory != null) {
                for (String dir : relativeDirectory.split("/")) {
                    psiDirectory = CreateFileAction.findOrCreateSubdirectory((PsiDirectory)psiDirectory, (String)dir);
                }
            }
            CreateNamedFileFix.createFromTemplate(project, (String)fileName, psiDirectory, templateName, text);
        }
    }

    private static void createFromTemplate(Project project, String viewName, PsiDirectory viewsDirectory, String templateName, String text) {
        FileTemplate template = FileTemplateManager.getInstance((Project)project).getTemplate(templateName);
        if (template != null) {
            try {
                PsiElement element = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)viewName, (Properties)null, (PsiDirectory)viewsDirectory, (ClassLoader)CreateNamedFileFix.class.getClassLoader());
                ((Navigatable)element).navigate(true);
            }
            catch (Exception e) {
                Messages.showErrorDialog((Project)project, (String)RBundle.message((String)"codeInsight.rails.switch.to.view.error.creating", (Object[])new Object[]{e.getMessage()}), (String)RBundle.message((String)"codeInsight.rails.switch.to.view.title"));
            }
        } else {
            viewsDirectory.checkCreateFile(viewName);
            WriteCommandAction.writeCommandAction((Project)project).withName(RBundle.message((String)"codeInsight.rails.create.view.file", (Object[])new Object[]{viewName})).run(() -> {
                FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(viewName);
                if (type.isBinary()) {
                    type = PlainTextFileType.INSTANCE;
                }
                PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(viewName, type, (CharSequence)(text != null ? text : ""));
                file = (PsiFile)viewsDirectory.add((PsiElement)file);
                file.navigate(true);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileName";
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/CreateNamedFileFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/CreateNamedFileFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 7 -> new IllegalStateException(string);
        };
    }
}

