/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketAssetsLoadPathManager;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths.LoadPathDescriptor;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;

public final class RailsFileReferenceHelper
extends FileReferenceHelper {
    public PsiFileSystemItem findRoot(@NotNull Project project, @NotNull VirtualFile file) {
        RailsApp app;
        if (project == null) {
            RailsFileReferenceHelper.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RailsFileReferenceHelper.$$$reportNull$$$0(1);
        }
        if ((app = RailsApp.fromFile(project, file)) != null) {
            for (VirtualFile root : app.getPaths().findFiles("public")) {
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) continue;
                return PsiManager.getInstance((Project)project).findDirectory(root);
            }
        }
        return null;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        RailsApp app;
        if (module == null) {
            RailsFileReferenceHelper.$$$reportNull$$$0(2);
        }
        if ((app = RailsApp.fromModule(module)) != null) {
            if (SprocketsUtil.areAssetsEnabled(app)) {
                Set<PsiFileSystemItem> paths = RailsFileReferenceHelper.collectAssetsRoots(module, null);
                if (!paths.isEmpty()) {
                    Set<PsiFileSystemItem> set = paths;
                    if (set == null) {
                        RailsFileReferenceHelper.$$$reportNull$$$0(3);
                    }
                    return set;
                }
            } else {
                List list = ContainerUtil.mapNotNull(app.getPaths().findFiles("public"), arg_0 -> ((PsiManager)PsiManager.getInstance((Project)app.getProject())).findDirectory(arg_0));
                if (list == null) {
                    RailsFileReferenceHelper.$$$reportNull$$$0(4);
                }
                return list;
            }
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            RailsFileReferenceHelper.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project, @NotNull VirtualFile file) {
        RailsApp app;
        Module module;
        PsiManager psiManager;
        PsiFile psiFile;
        PsiFileSystemItem parent;
        if (project == null) {
            RailsFileReferenceHelper.$$$reportNull$$$0(6);
        }
        if (file == null) {
            RailsFileReferenceHelper.$$$reportNull$$$0(7);
        }
        LinkedHashSet<PsiFileSystemItem> paths = new LinkedHashSet<PsiFileSystemItem>();
        PsiFileSystemItem item = this.getPsiFileSystemItem(project, file);
        if (item != null && (parent = item.getParent()) != null) {
            paths.add(parent);
        }
        if ((psiFile = (psiManager = PsiManager.getInstance((Project)project)).findFile(file)) != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile)) != null && (app = RailsApp.fromModule(module)) != null && SprocketsUtil.areAssetsEnabled(app)) {
            paths.addAll(RailsFileReferenceHelper.collectAssetsRoots(module, psiFile));
        }
        LinkedHashSet<PsiFileSystemItem> linkedHashSet = paths;
        if (linkedHashSet == null) {
            RailsFileReferenceHelper.$$$reportNull$$$0(8);
        }
        return linkedHashSet;
    }

    private static Set<PsiFileSystemItem> collectAssetsRoots(@NotNull Module module, @Nullable PsiFile fileWithReference) {
        if (module == null) {
            RailsFileReferenceHelper.$$$reportNull$$$0(9);
        }
        LinkedHashSet<PsiDirectory> paths = new LinkedHashSet<PsiDirectory>();
        LinkedHashSet<PsiFileSystemItem> pathsWithGivenType = new LinkedHashSet<PsiFileSystemItem>();
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        RailsApp railsApp = RailsApp.fromModule(module);
        if (railsApp != null) {
            SprocketAssetsLoadPathManager manager = SprocketAssetsLoadPathManager.getInstance(railsApp);
            String expectedAssetType = fileWithReference != null ? SprocketsUtil.getAssetType(null, (PsiElement)fileWithReference) : null;
            Set<VirtualFile> assetsRootPaths = manager.getAssetsRoots();
            for (VirtualFile file : assetsRootPaths) {
                String type;
                PsiDirectory psiDir;
                if (!file.isValid() || (psiDir = psiManager.findDirectory(file)) == null) continue;
                paths.add(psiDir);
                LoadPathDescriptor descriptor = manager.getDescriptor(file);
                if (descriptor == null || (type = descriptor.getType()) != null && expectedAssetType != null && !type.equals(expectedAssetType) && !type.equals("images")) continue;
                pathsWithGivenType.add((PsiFileSystemItem)psiDir);
            }
        }
        return !pathsWithGivenType.isEmpty() ? pathsWithGivenType : paths;
    }

    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        PsiFile psiFile;
        Module module;
        if (project == null) {
            RailsFileReferenceHelper.$$$reportNull$$$0(10);
        }
        if (file == null) {
            RailsFileReferenceHelper.$$$reportNull$$$0(11);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null && (psiFile = PsiManager.getInstance((Project)project).findFile(file)) != null) {
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        }
        return module != null && RailsFacetUtil.hasRailsSupport(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/RailsFileReferenceHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/RailsFileReferenceHelper";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectAssetsRoots";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 8 -> new IllegalStateException(string);
        };
    }
}

