/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.JoniUtil;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RRegexpLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.joni.Regex;

public final class FastInflectorService
extends InflectorService {
    private final List<Pair<Object, String>> mySingulars = new CopyOnWriteArrayList<Pair<Object, String>>();
    private final List<Pair<Object, String>> myPlurals = new CopyOnWriteArrayList<Pair<Object, String>>();
    private final Set<String> myUncountables = ConcurrentCollectionFactory.createConcurrentSet();
    private final Map<String, String> myAcronyms = ConcurrentCollectionFactory.createConcurrentMap();
    private final Map<String, Pattern> myAcronymsToUnderscorePatterns = ConcurrentCollectionFactory.createConcurrentMap();
    private volatile boolean myExceptionsLoaded;
    private static final Pattern WORD_START_ACRONYM_PATTERN = Pattern.compile("^[a-z\\d]*");
    private static final Pattern WORD_ACRONYM_PATTERN = Pattern.compile("([_/])([a-z\\d]*)", 2);

    public FastInflectorService(Module module) {
        super(module);
    }

    @Override
    public boolean isInflectorAvailable() {
        return true;
    }

    @Override
    @Nullable
    public String classify(@Nullable String name) {
        if (name == null) {
            return null;
        }
        String classified = (String)this.myClassifyCache.getIfPresent((Object)name);
        if (classified != null) {
            return classified;
        }
        String value = this.camelize(this.singularize(name.replaceAll(".*\\.", "")));
        this.myClassifyCache.put((Object)name, (Object)value);
        return value;
    }

    @Override
    @Nullable
    public String tableize(@Nullable String name) {
        if (name == null) {
            return null;
        }
        String tableized = (String)this.myTableizeCache.getIfPresent((Object)name);
        if (tableized != null) {
            return tableized;
        }
        String value = this.pluralize(this.underscore(name));
        this.myTableizeCache.put((Object)name, (Object)value);
        return value;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public String singularize(@Nullable String name) {
        if (name == null) {
            return null;
        }
        String singular = (String)this.mySingularizeCache.getIfPresent((Object)name);
        if (singular != null) {
            return singular;
        }
        this.updateInflectionExceptions();
        String value = this.inflect(name, this.mySingulars);
        this.mySingularizeCache.put((Object)name, (Object)value);
        return value;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public String pluralize(@Nullable String name) {
        if (name == null) {
            return null;
        }
        String plural = (String)this.myPluralizeCache.getIfPresent((Object)name);
        if (plural != null) {
            return plural;
        }
        this.updateInflectionExceptions();
        String value = this.inflect(name, this.myPlurals);
        this.myPluralizeCache.put((Object)name, (Object)value);
        return value;
    }

    @Override
    @NotNull
    public String camelize(@Nullable String name) {
        if (name == null) {
            String string = NamingConventions.toCamelCase((String)name);
            if (string == null) {
                FastInflectorService.$$$reportNull$$$0(0);
            }
            return string;
        }
        String camelized = (String)this.myCamelizeCache.getIfPresent((Object)name);
        if (camelized != null) {
            String string = camelized;
            if (string == null) {
                FastInflectorService.$$$reportNull$$$0(1);
            }
            return string;
        }
        this.updateInflectionExceptions();
        String result = name;
        result = WORD_START_ACRONYM_PATTERN.matcher(result).replaceAll(res -> this.myAcronyms.getOrDefault(res.group(0), res.group(0)));
        result = WORD_ACRONYM_PATTERN.matcher(result).replaceAll(res -> this.myAcronyms.containsKey(res.group(2)) ? res.group(1) + this.myAcronyms.get(res.group(2)) : res.group(0));
        result = NamingConventions.toCamelCase((String)result);
        this.myCamelizeCache.put((Object)name, (Object)result);
        String string = result;
        if (string == null) {
            FastInflectorService.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String underscore(@Nullable String name) {
        if (name == null) {
            String string = NamingConventions.toUnderscoreCase((String)name);
            if (string == null) {
                FastInflectorService.$$$reportNull$$$0(3);
            }
            return string;
        }
        String underscored = (String)this.myUnderscoreCache.getIfPresent((Object)name);
        if (underscored != null) {
            String string = underscored;
            if (string == null) {
                FastInflectorService.$$$reportNull$$$0(4);
            }
            return string;
        }
        this.updateInflectionExceptions();
        String result = name;
        for (String key : this.myAcronyms.keySet()) {
            Pattern pattern = this.myAcronymsToUnderscorePatterns.computeIfAbsent(key, k -> Pattern.compile("(?:(?<=([A-Za-z\\d]))|\\b)(" + this.myAcronyms.get(k) + ")(?=\\b|[^a-z])"));
            result = pattern.matcher(result).replaceAll(res -> res.group(1) == null || res.start(2) > res.end(1) ? key : "_" + key);
        }
        result = NamingConventions.toUnderscoreCase((String)result);
        this.myUnderscoreCache.put((Object)name, (Object)result);
        String string = result;
        if (string == null) {
            FastInflectorService.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private String inflect(@NotNull String name, @NotNull List<Pair<Object, String>> inflections) {
        if (name == null) {
            FastInflectorService.$$$reportNull$$$0(6);
        }
        if (inflections == null) {
            FastInflectorService.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)name)) {
            String string = name;
            if (string == null) {
                FastInflectorService.$$$reportNull$$$0(8);
            }
            return string;
        }
        for (String string : this.myUncountables) {
            if (!JoniUtil.search(JoniUtil.regex("\\b" + string + "\\Z", 1), name)) continue;
            String string2 = name;
            if (string2 == null) {
                FastInflectorService.$$$reportNull$$$0(9);
            }
            return string2;
        }
        for (Pair pair : inflections) {
            String gsub;
            Object rule = pair.first;
            String replacement = (String)pair.second;
            if (rule instanceof String) {
                gsub = name.contains((String)rule) ? name.replace((String)rule, replacement) : null;
            } else {
                LanguageLevel languageLevel = RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)RModuleUtil.getInstance().findRubySdkForModule(this.myModule));
                gsub = JoniUtil.gsubBang(name, (Regex)rule, replacement, languageLevel);
            }
            if (gsub == null) continue;
            String string = gsub;
            if (string == null) {
                FastInflectorService.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            FastInflectorService.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    protected void uncountable(String uncountable) {
        this.myUncountables.add(uncountable);
    }

    @Override
    protected void plural(RPsiElement key, RPsiElement val) {
        this.addInflection(key, val, this.myPlurals);
    }

    @Override
    protected void singular(RPsiElement key, RPsiElement val) {
        this.addInflection(key, val, this.mySingulars);
    }

    @Override
    protected void acronym(@NotNull String acronym) {
        if (acronym == null) {
            FastInflectorService.$$$reportNull$$$0(12);
        }
        this.myAcronyms.put(acronym.toLowerCase(Locale.ROOT), acronym);
    }

    private void addInflection(RPsiElement key, RPsiElement val, List<Pair<Object, String>> inflections) {
        if (!(key instanceof RRegexpLiteral)) {
            this.myUncountables.remove(key.getText());
        }
        this.myUncountables.remove(val.getText());
        inflections.add(0, (Pair<Object, String>)Pair.create((Object)FastInflectorService.createRegex(key), (Object)TextUtil.removeQuoting((String)val.getText())));
    }

    private static Object createRegex(RPsiElement key) {
        if (key instanceof RRegexpLiteral) {
            return JoniUtil.regex((RRegexpLiteral)key);
        }
        return key.getText();
    }

    @Override
    protected void irregular(RPsiElement key, RPsiElement val) {
        String singular = TextUtil.removeQuoting((String)key.getText());
        String plural = TextUtil.removeQuoting((String)val.getText());
        if (StringUtil.isEmpty((String)singular) || StringUtil.isEmpty((String)plural)) {
            return;
        }
        this.myUncountables.remove(singular);
        this.myUncountables.remove(plural);
        if (Character.toUpperCase(singular.charAt(0)) == Character.toUpperCase(plural.charAt(0))) {
            this.myPlurals.add(0, (Pair<Object, String>)new Pair((Object)JoniUtil.regex("(" + singular.charAt(0) + ")" + singular.substring(1) + "$", 1), (Object)("\\1" + plural.substring(1))));
            this.myPlurals.add(0, (Pair<Object, String>)new Pair((Object)JoniUtil.regex("(" + plural.charAt(0) + ")" + plural.substring(1) + "$", 1), (Object)("\\1" + plural.substring(1))));
            this.mySingulars.add(0, (Pair<Object, String>)new Pair((Object)JoniUtil.regex("(" + plural.charAt(0) + ")" + plural.substring(1) + "$", 1), (Object)("\\1" + singular.substring(1))));
        } else {
            this.myPlurals.add(0, (Pair<Object, String>)new Pair((Object)JoniUtil.regex(Character.toUpperCase(singular.charAt(0)) + "(?i)" + singular.substring(1) + "$"), (Object)(Character.toUpperCase(plural.charAt(0)) + plural.substring(1))));
            this.myPlurals.add(0, (Pair<Object, String>)new Pair((Object)JoniUtil.regex(Character.toLowerCase(singular.charAt(0)) + "(?i)" + singular.substring(1) + "$"), (Object)(Character.toLowerCase(plural.charAt(0)) + plural.substring(1))));
            this.myPlurals.add(0, (Pair<Object, String>)new Pair((Object)JoniUtil.regex(Character.toUpperCase(plural.charAt(0)) + "(?i)" + plural.substring(1) + "$"), (Object)(Character.toUpperCase(plural.charAt(0)) + plural.substring(1))));
            this.myPlurals.add(0, (Pair<Object, String>)new Pair((Object)JoniUtil.regex(Character.toLowerCase(plural.charAt(0)) + "(?i)" + plural.substring(1) + "$"), (Object)(Character.toLowerCase(plural.charAt(0)) + plural.substring(1))));
            this.mySingulars.add(0, (Pair<Object, String>)new Pair((Object)JoniUtil.regex(Character.toUpperCase(plural.charAt(0)) + "(?i)" + plural.substring(1) + "$"), (Object)(Character.toUpperCase(singular.charAt(0)) + singular.substring(1))));
            this.mySingulars.add(0, (Pair<Object, String>)new Pair((Object)JoniUtil.regex(Character.toLowerCase(plural.charAt(0)) + "(?i)" + plural.substring(1) + "$"), (Object)(Character.toLowerCase(singular.charAt(0)) + singular.substring(1))));
        }
    }

    @Override
    public void clearCaches() {
        this.myExceptionsLoaded = false;
        super.clearCaches();
    }

    @Override
    protected void clearExceptions() {
        this.mySingulars.clear();
        this.myPlurals.clear();
        this.myUncountables.clear();
        this.myAcronyms.clear();
    }

    private void updateInflectionExceptions() {
        Project project = this.myModule.getProject();
        if (this.myExceptionsLoaded || project.isDisposed()) {
            return;
        }
        this.clearExceptions();
        this.loadBaseInflections();
        RailsUtil.getEnvironments(this.myModule).forEach(this::updateInflectionExceptions);
        for (PsiFile file : FastInflectorService.getInflections(this.myModule, this.myApp)) {
            this.updateInflectionExceptions(file);
        }
        if (!DumbService.isDumb((Project)project)) {
            this.myExceptionsLoaded = true;
        }
    }

    private void loadBaseInflections() {
        GemInfo activeSupport = RubyProjectGemSearchService.Companion.findGem(this.myModule, "activesupport");
        if (activeSupport != null) {
            VirtualFile inflectorFile;
            VirtualFile lib = activeSupport.getLibFolder();
            VirtualFile virtualFile = inflectorFile = lib != null ? lib.findFileByRelativePath("active_support/inflections.rb") : null;
            if (inflectorFile != null) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    PsiFile psiFile = PsiManager.getInstance((Project)this.myModule.getProject()).findFile(inflectorFile);
                    RModule module = RContainerUtil.getFirstModuleInFile(psiFile);
                    if (module != null) {
                        this.loadInflectionExceptions((RContainer)module);
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 7, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/FastInflectorService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inflections";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acronym";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "camelize";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "underscore";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/FastInflectorService";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "inflect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inflect";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acronym";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 7, 12 -> new IllegalArgumentException(string);
        };
    }
}

