/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ExternalRailsSettings {
    public static final String SERVER_DEFAULT = "default";
    public static final String SERVER_PASSENGER = "passenger";
    public static final String SERVER_PUMA = "puma";
    public static final String SERVER_THIN = "thin";
    public static final String SERVER_TRINIDAD = "trinidad";
    public static final String SERVER_UNICORN = "unicorn";
    public static final String SERVER_WEBRICK = "webrick";
    private static final Map<String, String> TYPE_TO_TITLE = Map.ofEntries(Map.entry("default", "Default"), Map.entry("passenger", "Passenger"), Map.entry("puma", "Puma"), Map.entry("thin", "Thin"), Map.entry("trinidad", "Trinidad"), Map.entry("unicorn", "Unicorn"), Map.entry("webrick", "WEBrick"));
    private static final String[] SERVER_TYPES = ArrayUtil.toStringArray((Collection)ContainerUtil.sorted(TYPE_TO_TITLE.keySet(), (o1, o2) -> {
        if (o1.equals(SERVER_DEFAULT)) {
            return o2.equals(SERVER_DEFAULT) ? 0 : -1;
        }
        if (o2.equals(SERVER_DEFAULT)) {
            return 1;
        }
        return o1.compareToIgnoreCase((String)o2);
    }));

    private ExternalRailsSettings() {
    }

    public static String @NotNull [] getRailsServersTypes() {
        if (SERVER_TYPES == null) {
            ExternalRailsSettings.$$$reportNull$$$0(0);
        }
        return SERVER_TYPES;
    }

    @NotNull
    public static String getRailsServersTitlesByType(@NotNull String serverType) {
        if (serverType == null) {
            ExternalRailsSettings.$$$reportNull$$$0(1);
        }
        String string = TYPE_TO_TITLE.get(serverType);
        if (string == null) {
            ExternalRailsSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getServerGemTitle(@NotNull String serverGemName) {
        if (serverGemName == null) {
            ExternalRailsSettings.$$$reportNull$$$0(3);
        }
        String string = (String)ObjectUtils.coalesce((Object)TYPE_TO_TITLE.get(serverGemName), (Object)serverGemName);
        if (string == null) {
            ExternalRailsSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/ExternalRailsSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverGemName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRailsServersTypes";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/ExternalRailsSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRailsServersTitlesByType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerGemTitle";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRailsServersTitlesByType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getServerGemTitle";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }
}

