/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rack.run;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rack.RackUtil;
import org.jetbrains.plugins.ruby.rack.run.RackRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationFactoryBase;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;

public class RackRunConfigurationFactory
extends RubyRunConfigurationFactoryBase {
    public RackRunConfigurationFactory(ConfigurationType type) {
        super(type, (project, base) -> new RackRunConfiguration((Project)project, (ConfigurationFactory)base), "Rack");
    }

    public RunnerAndConfigurationSettings createConfigurationSettings(@NotNull Module module, String envType) {
        if (module == null) {
            RackRunConfigurationFactory.$$$reportNull$$$0(0);
        }
        RunnerAndConfigurationSettings settings = RunConfigurationUtil.createSettings(module.getProject(), this, "");
        RackRunConfiguration conf = (RackRunConfiguration)settings.getConfiguration();
        this.initConfiguration(module, conf, envType);
        return settings;
    }

    @Override
    protected void initTemplateDefaultParams(AbstractRubyRunConfiguration conf) {
        super.initTemplateDefaultParams(conf);
        RackRunConfiguration configuration = (RackRunConfiguration)conf;
        configuration.setPort(String.valueOf(9292));
        configuration.setHost(RackUtil.RACK_SERVER_LOCALHOST);
        configuration.setServer("Default");
        Module module = conf.getModule();
        if (module != null) {
            VirtualFile configRu = RackUtil.findRackConfig(module);
            if (configRu != null) {
                configuration.setConfig(configRu.getName());
            } else {
                configuration.setConfig("");
            }
        }
    }

    private void initConfiguration(@NotNull Module module, @NotNull RackRunConfiguration configuration, String environment) {
        if (module == null) {
            RackRunConfigurationFactory.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            RackRunConfigurationFactory.$$$reportNull$$$0(2);
        }
        configuration.setName(StringUtil.capitalize((String)environment) + ": " + module.getName());
        this.initWithDefaultModule(configuration, module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rack/run/RackRunConfigurationFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfigurationSettings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

