/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rack.run;

import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rack.run.RackRunConfiguration;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;

public class RackRunConfigurationExternalizer
extends SettingsExternalizer {
    private static final RackRunConfigurationExternalizer myInstance = new RackRunConfigurationExternalizer();
    @NonNls
    public static final String RACK_CONFIG_SETTINGS_ID = "RACK_CONFIG_SETTINGS_ID";
    @NonNls
    private static final String PORT = "PORT";
    @NonNls
    private static final String IP = "IP";
    @NonNls
    public static final String CONFIG_FILE = "CONFIG_FILE";
    @NonNls
    public static final String SERVER_TYPE = "RACK_SERVER_TYPE";
    @NonNls
    public static final String ENVIRONMENT = "ENVIRONMENT";
    @NonNls
    private static final String BROWSER_URL = "BROWSER_URL";
    @NonNls
    private static final String LAUNCH_JS = "LAUNCH_JS";

    public void writeExternal(RackRunConfiguration conf, Element elem) {
        this.writeOption(PORT, conf.getPort(), elem);
        this.writeOption(IP, conf.getHost(), elem);
        this.writeOption(CONFIG_FILE, conf.getRackupConfig(), elem);
        this.writeOption(SERVER_TYPE, conf.getServer(), elem);
        String url = conf.getBrowserUrl();
        if (url != null) {
            this.writeOption(BROWSER_URL, url, elem);
        }
        this.writeOption(LAUNCH_JS, String.valueOf(conf.isLaunchJavascriptDebugger()), elem);
    }

    public void readExternal(RackRunConfiguration conf, Element elem) {
        String launchJS;
        String browserUrl;
        String envType;
        String configFile;
        Map<String, String> optionsByName = this.buildOptionsByElement(elem);
        conf.setPort(optionsByName.get(PORT));
        conf.setHost(optionsByName.get(IP));
        String serverType = optionsByName.get(SERVER_TYPE);
        if (serverType != null) {
            conf.setServer(serverType);
        }
        if ((configFile = optionsByName.get(CONFIG_FILE)) != null) {
            conf.setConfig(configFile);
        }
        if ((envType = optionsByName.get(ENVIRONMENT)) != null) {
            // empty if block
        }
        if ((browserUrl = optionsByName.get(BROWSER_URL)) != null) {
            conf.setBrowserUrl(browserUrl);
        }
        if ((launchJS = optionsByName.get(LAUNCH_JS)) != null) {
            conf.setLaunchJavascriptDebugger(Boolean.parseBoolean(launchJS));
        }
    }

    public static RackRunConfigurationExternalizer getInstance() {
        return myInstance;
    }

    @Override
    @NotNull
    public String getID() {
        return RACK_CONFIG_SETTINGS_ID;
    }
}

