/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rack.run;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rack.RackUtil;
import org.jetbrains.plugins.ruby.rack.run.RackRunConfiguration;
import org.jetbrains.plugins.ruby.rack.run.RackRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;

public class RackRunConfigurationEditor
extends SettingsEditor<RackRunConfiguration>
implements RackRunConfigurationParams,
PanelWithAnchor {
    @NlsSafe
    public static final String DEVELOPMENT = "development";
    private JPanel generatedPanel1;
    private LabeledComponent myServerComponent;
    private LabeledComponent myPort;
    private LabeledComponent myIPAddr;
    private LabeledComponent myEnvironment;
    private JBCheckBox myRunBrowserCheckBox;
    private JTextField myUrlTextField;
    private JPanel myCommonOptionsPanel;
    private JCheckBox myStartJavaScriptDebugger;
    private LabeledComponent<TextFieldWithBrowseButton> myRackConfig;
    private TextFieldWithBrowseButton myRackupScriptLocation;
    private JTextField myIPAddrField;
    private JTextField myPortField;
    private JComboBox<String> myServerComboBox;
    private JTextField myEnvironmentField;
    private final RubyCommonRunParamsEditor myCommonEditor;
    private JComponent myAnchor;
    private final Project myProject;

    public RackRunConfigurationEditor(Project project, RackRunConfiguration configuration) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCommonEditor = new RubyCommonRunParamsEditor(configuration);
        this.myCommonOptionsPanel.add((Component)this.myCommonEditor.getMainPanel(), "Center");
        this.initComponents();
        this.setupAnchor();
    }

    private void initComponents() {
        this.myRunBrowserCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RackRunConfigurationEditor.this.myUrlTextField.setEnabled(RackRunConfigurationEditor.this.myRunBrowserCheckBox.isSelected());
                RackRunConfigurationEditor.this.myStartJavaScriptDebugger.setEnabled(RackRunConfigurationEditor.this.myRunBrowserCheckBox.isSelected());
            }
        });
        this.myPortField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                RackRunConfigurationEditor.this.updatePort();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/rack/run/RackRunConfigurationEditor$2", "textChanged"));
            }
        });
        this.myIPAddrField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                RackRunConfigurationEditor.this.updateHost();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/rack/run/RackRunConfigurationEditor$3", "textChanged"));
            }
        });
        this.myUrlTextField.setText(this.getDefaultUrl());
        this.myServerComboBox.setModel(new DefaultComboBoxModel<String>(RackUtil.getSupportedServers()));
        this.myEnvironmentField.setText(DEVELOPMENT);
        this.myServerComboBox.setSelectedItem("Default");
        this.myServerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RackRunConfigurationEditor.this.myIPAddr.setEnabled(true);
            }
        });
    }

    private void updateHost() {
        String url = this.myUrlTextField.getText();
        int index = url.lastIndexOf(58);
        if (index != -1) {
            this.myUrlTextField.setText("http://" + this.myIPAddrField.getText().trim() + url.substring(index));
        }
    }

    private void updatePort() {
        String url = this.myUrlTextField.getText();
        int index = url.lastIndexOf(58);
        if (index != -1) {
            int i;
            for (i = index + 1; i < url.length() && Character.isDigit(url.charAt(i)); ++i) {
            }
            String route = i < url.length() ? url.substring(i) : "";
            this.myUrlTextField.setText(url.substring(0, index) + ":" + this.myPortField.getText().trim() + route);
        }
    }

    private String getDefaultUrl() {
        return "http://" + this.myIPAddrField.getText().trim() + ":" + this.myPortField.getText().trim();
    }

    private void createUIComponents() {
        this.myRackConfig = this.createRackupComponent();
        this.myServerComponent = this.createServersComponent();
        this.myEnvironment = this.createEnvironmentsComponent();
        this.myPort = this.createPortComponent();
        this.myIPAddr = this.createIPAddrComponent();
    }

    private LabeledComponent createEnvironmentsComponent() {
        this.myEnvironmentField = new JTextField();
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)this.myEnvironmentField);
        myComponent.setText(DEVELOPMENT);
        return myComponent;
    }

    private LabeledComponent createIPAddrComponent() {
        this.myIPAddrField = new JTextField();
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)this.myIPAddrField);
        myComponent.setText(RBundle.message((String)"run.configuration.server.dialog.ip"));
        myComponent.setLabelLocation("West");
        return myComponent;
    }

    private LabeledComponent createPortComponent() {
        this.myPortField = new JTextField();
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)this.myPortField);
        myComponent.setLabelLocation("West");
        myComponent.setText(RBundle.message((String)"run.configuration.server.dialog.port"));
        return myComponent;
    }

    private LabeledComponent createServersComponent() {
        this.myServerComboBox = new ComboBox();
        this.myServerComboBox.setRenderer((ListCellRenderer<String>)SimpleListCellRenderer.create((String)"", (Function)Functions.id()));
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent(this.myServerComboBox);
        myComponent.setText(RBundle.message((String)"run.configuration.server.dialog.server"));
        myComponent.setLabelLocation("West");
        return myComponent;
    }

    protected LabeledComponent<TextFieldWithBrowseButton> createRackupComponent() {
        String title = RBundle.message((String)"run.configuration.rack.select.rackup.path");
        this.myRackupScriptLocation = new TextFieldWithBrowseButton();
        RunConfigurationUIUtil.addFileChooser(title, this.myRackupScriptLocation, this.myProject);
        this.myRackupScriptLocation.setText(this.getRackupConfig());
        return LabeledComponent.create((JComponent)this.myRackupScriptLocation, (String)RBundle.message((String)"run.configuration.rack.select.rackup.path"));
    }

    @Override
    @NotNull
    public String getHost() {
        String string = this.myIPAddrField.getText().trim();
        if (string == null) {
            RackRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void setHost(String ip) {
        this.myIPAddrField.setText(ip);
    }

    @Override
    public String getPort() {
        return this.myPortField.getText().trim();
    }

    @Override
    public void setPort(String port) {
        this.myPortField.setText(port);
    }

    @Override
    @NotNull
    public String getServer() {
        String string = (String)this.myServerComboBox.getSelectedItem();
        if (string == null) {
            RackRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void setServer(@NotNull @NlsSafe String type) {
        if (type == null) {
            RackRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        this.myServerComboBox.setSelectedItem(type);
    }

    @Override
    @Nullable
    public String getBrowserUrl() {
        return this.myRunBrowserCheckBox.isSelected() ? this.myUrlTextField.getText() : null;
    }

    @Override
    public void setBrowserUrl(String url) {
        if (url != null) {
            this.myRunBrowserCheckBox.setSelected(true);
            this.myUrlTextField.setText(url);
            this.myStartJavaScriptDebugger.setEnabled(true);
        } else {
            this.myRunBrowserCheckBox.setSelected(false);
            this.myUrlTextField.setText(this.getDefaultUrl());
            this.myStartJavaScriptDebugger.setEnabled(false);
        }
        this.myUrlTextField.setEnabled(this.myRunBrowserCheckBox.isSelected());
    }

    @Override
    public boolean isLaunchJavascriptDebugger() {
        return this.myStartJavaScriptDebugger.isEnabled() && this.myStartJavaScriptDebugger.isSelected();
    }

    @Override
    public void setLaunchJavascriptDebugger(boolean launch) {
        this.myStartJavaScriptDebugger.setSelected(launch);
    }

    @Override
    @NlsSafe
    public String getRackupConfig() {
        return FileUtil.toSystemIndependentName((String)this.myRackupScriptLocation.getText().trim());
    }

    @Override
    public void setConfig(@NlsSafe String location) {
        this.myRackupScriptLocation.setText(location);
    }

    public JComponent getPanel() {
        return this.generatedPanel1;
    }

    public void resetEditorFrom(@NotNull RackRunConfiguration config) {
        if (config == null) {
            RackRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        RackRunConfiguration.copyParams(config, this);
        this.myCommonEditor.resetEditorFrom(config);
    }

    public void applyEditorTo(@NotNull RackRunConfiguration config) {
        if (config == null) {
            RackRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        RackRunConfiguration.copyParams(this, config);
        this.myCommonEditor.applyEditorTo(config);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.generatedPanel1;
        if (jPanel == null) {
            RackRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myIPAddr.setAnchor(anchor);
        this.myPort.setAnchor(anchor);
        this.myRackConfig.setAnchor(anchor);
        this.myEnvironment.setAnchor(anchor);
        this.myServerComponent.setAnchor(anchor);
        this.myRunBrowserCheckBox.setAnchor(anchor);
    }

    private void setupAnchor() {
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myCommonEditor, this.myIPAddr, this.myPort, this.myRackConfig, this.myEnvironment, this.myServerComponent});
        JComponent checkboxAnchor = this.myRunBrowserCheckBox.getAnchor();
        if (checkboxAnchor == null || checkboxAnchor.getPreferredSize().getWidth() <= this.myAnchor.getPreferredSize().getWidth()) {
            this.myRunBrowserCheckBox.setAnchor(this.myAnchor);
            return;
        }
        this.setAnchor(checkboxAnchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rack/run/RackRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getServer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rack/run/RackRunConfigurationEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setServer";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        this.createUIComponents();
        this.generatedPanel1 = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LabeledComponent labeledComponent = this.myServerComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", RackRunConfigurationEditor.class).getString("run.configuration.server.dialog.server"));
        jPanel2.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent2 = this.myIPAddr;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/RBundle", RackRunConfigurationEditor.class).getString("run.configuration.server.dialog.ip"));
        jPanel2.add((Component)labeledComponent2, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myRunBrowserCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", RackRunConfigurationEditor.class).getString("run.configuration.rack.config.run.browser.text"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        LabeledComponent labeledComponent3 = this.myPort;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/RBundle", RackRunConfigurationEditor.class).getString("run.configuration.server.dialog.port"));
        jPanel2.add((Component)labeledComponent3, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myStartJavaScriptDebugger = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(0, 0, 0, 1));
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", RackRunConfigurationEditor.class).getString("run.configuration.rack.config.auto.start.js.debugger.text"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(6, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myUrlTextField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel2.add((Component)jTextField, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(7, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myCommonOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel2.add((Component)jSeparator2, new GridConstraints(4, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        LabeledComponent<TextFieldWithBrowseButton> labeledComponent4 = this.myRackConfig;
        labeledComponent4.setLabelLocation("West");
        labeledComponent4.setText(DynamicBundle.getBundle((String)"messages/RBundle", RackRunConfigurationEditor.class).getString("run.configuration.rack.config.path"));
        jPanel2.add((Component)labeledComponent4, new GridConstraints(3, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.generatedPanel1;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

