/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rack.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rack.RackUtil;
import org.jetbrains.plugins.ruby.rack.run.RackRunCommandLineState;
import org.jetbrains.plugins.ruby.rack.run.RackRunConfigurationEditor;
import org.jetbrains.plugins.ruby.rack.run.RackRunConfigurationExternalizer;
import org.jetbrains.plugins.ruby.rack.run.RackRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;

public class RackRunConfiguration
extends AbstractRubyRunConfiguration<RackRunConfiguration>
implements RackRunConfigurationParams {
    @NlsSafe
    public static final String DEFAULT_SERVER = "Default";
    private String myConfig = "";
    @NotNull
    private String myServer = "";
    private String myPort = String.valueOf(9292);
    private String myHost = RackUtil.RACK_SERVER_LOCALHOST;
    private String myBrowserUrl = null;
    private boolean myLaunchJavascriptDebugger = false;

    public RackRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    @Override
    protected String getSerializationId() {
        return "RACK_CONFIG_SETTINGS_ID";
    }

    @Override
    public boolean isLaunchJavascriptDebugger() {
        return this.myLaunchJavascriptDebugger;
    }

    @Override
    public void setLaunchJavascriptDebugger(boolean launchJavascriptDebugger) {
        this.myLaunchJavascriptDebugger = launchJavascriptDebugger;
    }

    @Override
    public String getRackupConfig() {
        return this.myConfig;
    }

    @Override
    public void setConfig(String location) {
        this.myConfig = RackRunConfiguration.asSysIndependentPath(location);
    }

    public static void copyParams(RackRunConfigurationParams fromParams, RackRunConfigurationParams toParams) {
        toParams.setConfig(fromParams.getRackupConfig());
        toParams.setHost(fromParams.getHost());
        toParams.setPort(fromParams.getPort());
        toParams.setServer(fromParams.getServer());
        toParams.setBrowserUrl(fromParams.getBrowserUrl());
        toParams.setLaunchJavascriptDebugger(fromParams.isLaunchJavascriptDebugger());
    }

    @Override
    public String getPort() {
        return this.myPort;
    }

    @Override
    public void setPort(String port) {
        this.myPort = port;
    }

    @Override
    @NotNull
    public String getHost() {
        String string = this.myHost;
        if (string == null) {
            RackRunConfiguration.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getServer() {
        String string = this.myServer;
        if (string == null) {
            RackRunConfiguration.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void setServer(@NotNull String server) {
        if (server == null) {
            RackRunConfiguration.$$$reportNull$$$0(2);
        }
        this.myServer = server;
    }

    @Override
    public void setHost(String ip) {
        this.myHost = StringUtil.notNullize((String)ip);
    }

    @Override
    @NotNull
    protected SettingsEditor<RackRunConfiguration> createConfigurationEditor() {
        return new RackRunConfigurationEditor(this.getProject(), this);
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            RackRunConfiguration.$$$reportNull$$$0(3);
        }
        super.readExternal(element);
        RackRunConfigurationExternalizer.getInstance().readExternal(this, element);
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            RackRunConfiguration.$$$reportNull$$$0(4);
        }
        super.writeExternal(element);
        RackRunConfigurationExternalizer.getInstance().writeExternal(this, element);
    }

    @Override
    protected RubyAbstractCommandLineState createCommandLineState(@NotNull ExecutionEnvironment env) throws ExecutionException {
        if (env == null) {
            RackRunConfiguration.$$$reportNull$$$0(5);
        }
        return new RackRunCommandLineState(this, env);
    }

    @Nullable
    public String getRackScriptPath() {
        VirtualFile config;
        Module module = this.getModule();
        if (module != null && (config = RackUtil.findRackConfig(module)) != null) {
            return config.getPath();
        }
        return null;
    }

    @Override
    protected void validateConfiguration() throws RuntimeConfigurationException {
        this.inspectRackGem();
        this.inspectConfigRu();
        RunConfigurationUtil.inspectWorkingDirectory(true, this);
        RunConfigurationUtil.validatePort(this.getPort());
        RunConfigurationUtil.validateIpAddress(this.getHost());
    }

    private void inspectRackGem() throws RuntimeConfigurationError {
        Module module = this.getModule();
        Sdk sdk = this.getSdk();
        String executable = null;
        if (module != null && sdk != null) {
            executable = RackUtil.findRackupExecutablePath(module, sdk);
        }
        if (executable == null) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.rack.rackup.error"));
        }
    }

    @Override
    @NotNull
    public String getWorkingDirectory() {
        String workDir = super.getWorkingDirectory();
        if (!StringUtil.isEmptyOrSpaces((String)workDir)) {
            String string = workDir;
            if (string == null) {
                RackRunConfiguration.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)this.getProject().getBasePath());
        if (string == null) {
            RackRunConfiguration.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected void inspectConfigRu() throws RuntimeConfigurationError {
        String config = this.getRackupConfig();
        if (config.isEmpty()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.rack.config.error"));
        }
    }

    @Override
    public String getBrowserUrl() {
        return this.myBrowserUrl;
    }

    @Override
    public void setBrowserUrl(String browserUrl) {
        this.myBrowserUrl = browserUrl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rack/run/RackRunConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getServer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rack/run/RackRunConfiguration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setServer";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLineState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

