/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rack;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import java.net.InetAddress;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;

public final class RackUtil {
    public static final String RACK_CONFIG = "config.ru";
    public static final String RACK_GEM_NAME = "rack";
    private static final String RACK_GEM_EXECUTABLE = "rackup";
    public static final int PORT = 9292;
    public static final String RACK_ENV = "RACK_ENV";
    public static final String RACK_SERVER_LOCALHOST = System.getProperty("ruby.server.localhost.ip.address", InetAddress.getLoopbackAddress().getHostAddress());

    public static boolean isRackConfig(PsiFile file) {
        return file instanceof RFile && RACK_CONFIG.equals(file.getName());
    }

    public static boolean isRackConfig(@NotNull VirtualFile file) {
        if (file == null) {
            RackUtil.$$$reportNull$$$0(0);
        }
        return RACK_CONFIG.equalsIgnoreCase(file.getName());
    }

    public static String[] getSupportedServers() {
        RackServers[] servers = RackServers.values();
        ArrayList<String> presentableNames = new ArrayList<String>();
        for (RackServers server : servers) {
            presentableNames.add(server.getServerName());
        }
        return ArrayUtilRt.toStringArray(presentableNames);
    }

    @Nullable
    public static VirtualFile findRackConfig(@NotNull Module module) {
        if (module == null) {
            RackUtil.$$$reportNull$$$0(1);
        }
        if (RModuleUtil.getInstance().hasRubySupport(module)) {
            VirtualFile moduleFile = module.getModuleFile();
            if (moduleFile != null) {
                VirtualFile parent = moduleFile.getParent().getParent();
                return parent.findFileByRelativePath(RACK_CONFIG);
            }
            VirtualFile baseDir = module.getProject().getBaseDir();
            if (baseDir != null) {
                return baseDir.findFileByRelativePath(RACK_CONFIG);
            }
        }
        return null;
    }

    @Nullable
    public static String findRackupExecutablePath(@NotNull Module module, @NotNull Sdk sdk) {
        GemInfo gem;
        if (module == null) {
            RackUtil.$$$reportNull$$$0(2);
        }
        if (sdk == null) {
            RackUtil.$$$reportNull$$$0(3);
        }
        return (gem = RubyProjectGemSearchService.Companion.findGem(module, RACK_GEM_NAME)) != null ? RubyGemExecutionContext.getScriptPath(sdk, module, RACK_GEM_NAME, RACK_GEM_EXECUTABLE) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rack/RackUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRackConfig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findRackConfig";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findRackupExecutablePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum RackServers {
        DEFAULT("default"),
        WEBRICK("WEBrick"),
        THIN("Thin");

        @NonNls
        private final String myServerName;

        private RackServers(String name) {
            this.myServerName = name;
        }

        public String getServerName() {
            return this.myServerName;
        }

        public String getCommandOption() {
            return StringUtil.toLowerCase((String)this.myServerName);
        }
    }
}

