/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.mongoid;

import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.mongoid.MongoField;
import org.jetbrains.plugins.ruby.mongoid.MongoidCallTypeProvider;
import org.jetbrains.plugins.ruby.mongoid.MongoidUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;

public final class MongoModel {
    private final RClass myClass;

    private MongoModel(@NotNull RClass aClass) {
        if (aClass == null) {
            MongoModel.$$$reportNull$$$0(0);
        }
        this.myClass = aClass;
    }

    public RClass getRClass() {
        return this.myClass;
    }

    @Nullable
    public static MongoModel fromClass(@NotNull RClass rClass) {
        if (rClass == null) {
            MongoModel.$$$reportNull$$$0(1);
        }
        if (MongoidUtil.isMongoidIncluded(rClass)) {
            return new MongoModel(rClass);
        }
        return null;
    }

    public void processFields(@NotNull Consumer<MongoField> fieldConsumer) {
        if (fieldConsumer == null) {
            MongoModel.$$$reportNull$$$0(2);
        }
        this.getRClass().processCallsOfType(MongoidCallTypeProvider.FIELD, call -> {
            RPsiElement type;
            List arguments = (List)call.getData(new RubyCallType[]{MongoidCallTypeProvider.FIELD});
            if (arguments.size() != 1) {
                return;
            }
            String fieldName = (String)arguments.get(0);
            List callArguments = call.getArguments();
            if (callArguments.size() < 2) {
                return;
            }
            RPsiElement element = (RPsiElement)callArguments.get(1);
            if (!(element instanceof RAssoc)) {
                return;
            }
            RAssoc hash = (RAssoc)element;
            RPsiElement key = hash.getKey();
            if (key != null && key.getText().equals("type") && (type = hash.getValue()) != null) {
                String dataType = type.getText();
                MongoField field = new MongoField(fieldName, dataType);
                fieldConsumer.consume((Object)field);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldConsumer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/mongoid/MongoModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fromClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processFields";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

