/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.model.navigation;

import com.intellij.codeInsight.navigation.UtilKt;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.backend.presentation.TargetPresentationBuilder;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TextWithIcon;
import java.io.File;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.FileLocationProvider;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;

public final class TargetPresentationUtil {
    private TargetPresentationUtil() {
    }

    @NotNull
    public static TargetPresentation createTargetPresentation(@NotNull NavigatablePsiElement target) {
        if (target == null) {
            TargetPresentationUtil.$$$reportNull$$$0(0);
        }
        return TargetPresentationUtil.createTargetPresentation(Objects.requireNonNull(target.getName()), target.getIcon(0), (PsiElement)target);
    }

    @NotNull
    public static TargetPresentation createTargetPresentation(@NotNull PresentableSymbol symbol, @NotNull PsiElement target) {
        if (symbol == null) {
            TargetPresentationUtil.$$$reportNull$$$0(1);
        }
        if (target == null) {
            TargetPresentationUtil.$$$reportNull$$$0(2);
        }
        SymbolPresentation presentation = symbol.getPresentation();
        return TargetPresentationUtil.createTargetPresentation(presentation.name(), presentation.icon(), target);
    }

    @NotNull
    public static TargetPresentation createTargetPresentation(@NotNull PsiSymbolDeclaration declaration) {
        if (declaration == null) {
            TargetPresentationUtil.$$$reportNull$$$0(3);
        }
        PresentableSymbol symbol = (PresentableSymbol)ObjectUtils.tryCast((Object)declaration.getSymbol(), PresentableSymbol.class);
        PsiElement element = declaration.getDeclaringElement();
        TargetPresentation targetPresentation = symbol != null ? TargetPresentationUtil.createTargetPresentation(symbol, element) : UtilKt.targetPresentation((PsiElement)element);
        if (targetPresentation == null) {
            TargetPresentationUtil.$$$reportNull$$$0(4);
        }
        return targetPresentation;
    }

    @NotNull
    public static TargetPresentation createTargetPresentation(@NlsSafe @NotNull String name, @Nullable Icon icon, @NotNull PsiElement target) {
        if (name == null) {
            TargetPresentationUtil.$$$reportNull$$$0(5);
        }
        if (target == null) {
            TargetPresentationUtil.$$$reportNull$$$0(6);
        }
        TargetPresentationBuilder builder2 = TargetPresentation.builder((String)name).icon(icon);
        Project project = target.getProject();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)target);
        if (file != null) {
            builder2 = builder2.backgroundColor(VfsPresentationUtil.getFileBackgroundColor((Project)project, (VirtualFile)file));
            String relativePath = TargetPresentationUtil.getRelativePath(project, target instanceof PsiFileSystemItem ? file.getParent() : file);
            builder2 = builder2.containerText(relativePath, UtilKt.fileStatusAttributes((Project)project, (VirtualFile)file));
            TextWithIcon fileLocation = FileLocationProvider.getFileLocationWithProviders(project, file);
            if (fileLocation != null) {
                builder2 = builder2.locationText(fileLocation.getText(), fileLocation.getIcon());
            }
        }
        TargetPresentation targetPresentation = builder2.presentation();
        if (targetPresentation == null) {
            TargetPresentationUtil.$$$reportNull$$$0(7);
        }
        return targetPresentation;
    }

    @NotNull
    public static TargetPresentation createTargetPresentation(@NlsSafe @NotNull String name, @Nullable Icon icon, @NlsSafe @NotNull String containerText, @NotNull PsiElement target) {
        if (name == null) {
            TargetPresentationUtil.$$$reportNull$$$0(8);
        }
        if (containerText == null) {
            TargetPresentationUtil.$$$reportNull$$$0(9);
        }
        if (target == null) {
            TargetPresentationUtil.$$$reportNull$$$0(10);
        }
        TargetPresentationBuilder builder2 = TargetPresentation.builder((String)name).icon(icon);
        Project project = target.getProject();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)target);
        if (file != null) {
            builder2 = builder2.backgroundColor(VfsPresentationUtil.getFileBackgroundColor((Project)project, (VirtualFile)file)).containerText(containerText);
            TextWithIcon fileLocation = FileLocationProvider.getFileLocationWithProviders(project, file);
            if (fileLocation != null) {
                builder2 = builder2.locationText(fileLocation.getText(), fileLocation.getIcon());
            }
        }
        TargetPresentation targetPresentation = builder2.presentation();
        if (targetPresentation == null) {
            TargetPresentationUtil.$$$reportNull$$$0(11);
        }
        return targetPresentation;
    }

    @NlsSafe
    @Nullable
    public static String getRelativePath(@NotNull PsiFile file) {
        if (file == null) {
            TargetPresentationUtil.$$$reportNull$$$0(12);
        }
        Project project = file.getProject();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        return virtualFile != null ? TargetPresentationUtil.getRelativePath(project, virtualFile) : null;
    }

    @NlsSafe
    @Nullable
    public static String getRelativePath(@NotNull Project project, @NotNull VirtualFile file) {
        ProjectFileIndex index;
        VirtualFile root;
        if (project == null) {
            TargetPresentationUtil.$$$reportNull$$$0(13);
        }
        if (file == null) {
            TargetPresentationUtil.$$$reportNull$$$0(14);
        }
        return (root = (VirtualFile)ObjectUtils.coalesce((Object)(index = ProjectRootManager.getInstance((Project)project).getFileIndex()).getContentRootForFile(file), (Object)index.getClassRootForFile(file), (Object)index.getSourceRootForFile(file))) != null ? VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/model/navigation/TargetPresentationUtil";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerText";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/model/navigation/TargetPresentationUtil";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTargetPresentation";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 11 -> new IllegalStateException(string);
        };
    }
}

