/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.model.navigation;

import com.intellij.model.Pointer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.LinkableNavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.TargetLocation;
import org.jetbrains.plugins.ruby.model.navigation.TargetPresentationUtil;

public final class PsiFileSystemItemNavigationTarget
implements LinkableNavigationTarget {
    private final PsiFileSystemItem myFileSystemItem;
    private final TargetLocation myLocation;
    private final TargetPresentation myPresentation;

    public PsiFileSystemItemNavigationTarget(@NotNull PsiFileSystemItem fileSystemItem) {
        if (fileSystemItem == null) {
            PsiFileSystemItemNavigationTarget.$$$reportNull$$$0(0);
        }
        this(fileSystemItem, TargetLocation.fromElement((PsiElement)fileSystemItem), TargetPresentationUtil.createTargetPresentation((NavigatablePsiElement)fileSystemItem));
    }

    public PsiFileSystemItemNavigationTarget(@NotNull PsiFileSystemItem fileSystemItem, @NotNull TargetLocation location, @NotNull TargetPresentation presentation) {
        if (fileSystemItem == null) {
            PsiFileSystemItemNavigationTarget.$$$reportNull$$$0(1);
        }
        if (location == null) {
            PsiFileSystemItemNavigationTarget.$$$reportNull$$$0(2);
        }
        if (presentation == null) {
            PsiFileSystemItemNavigationTarget.$$$reportNull$$$0(3);
        }
        this.myFileSystemItem = fileSystemItem;
        this.myLocation = location;
        this.myPresentation = presentation;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = this.myPresentation;
        if (targetPresentation == null) {
            PsiFileSystemItemNavigationTarget.$$$reportNull$$$0(4);
        }
        return targetPresentation;
    }

    @NotNull
    public Pointer<PsiFileSystemItemNavigationTarget> createPointer() {
        TargetLocation location = this.myLocation;
        TargetPresentation presentation = this.myPresentation;
        Pointer pointer = Pointer.delegatingPointer((Pointer)SmartPointerManager.createPointer((PsiElement)this.myFileSystemItem), it -> new PsiFileSystemItemNavigationTarget((PsiFileSystemItem)it, location, presentation));
        if (pointer == null) {
            PsiFileSystemItemNavigationTarget.$$$reportNull$$$0(5);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.myFileSystemItem.equals((Object)((PsiFileSystemItemNavigationTarget)obj).myFileSystemItem);
    }

    @NotNull
    public PsiFileSystemItem getFileSystemItem() {
        PsiFileSystemItem psiFileSystemItem = this.myFileSystemItem;
        if (psiFileSystemItem == null) {
            PsiFileSystemItemNavigationTarget.$$$reportNull$$$0(6);
        }
        return psiFileSystemItem;
    }

    @Override
    @NotNull
    public String getLink() {
        VirtualFile file = Objects.requireNonNull(PsiUtilCore.getVirtualFile((PsiElement)this.myFileSystemItem));
        String string = String.format("#navigation/%s:%d", file.getPath(), 0);
        if (string == null) {
            PsiFileSystemItemNavigationTarget.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public Navigatable getNavigatable() {
        PsiFileSystemItem psiFileSystemItem = this.myFileSystemItem;
        if (psiFileSystemItem == null) {
            PsiFileSystemItemNavigationTarget.$$$reportNull$$$0(8);
        }
        return psiFileSystemItem;
    }

    public int hashCode() {
        return this.myFileSystemItem.hashCode();
    }

    @Override
    @NotNull
    public TargetLocation location() {
        TargetLocation targetLocation = this.myLocation;
        if (targetLocation == null) {
            PsiFileSystemItemNavigationTarget.$$$reportNull$$$0(9);
        }
        return targetLocation;
    }

    @Override
    @Nullable
    public NavigationRequest navigationRequest() {
        PsiFileSystemItem psiFileSystemItem = this.myFileSystemItem;
        if (psiFileSystemItem instanceof PsiFile) {
            PsiFile file = (PsiFile)psiFileSystemItem;
            return NavigationRequest.sourceNavigationRequest((PsiFile)file, (TextRange)TextRange.EMPTY_RANGE);
        }
        psiFileSystemItem = this.myFileSystemItem;
        if (psiFileSystemItem instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)psiFileSystemItem;
            return NavigationRequest.directoryNavigationRequest((PsiDirectory)directory);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystemItem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/model/navigation/PsiFileSystemItemNavigationTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/model/navigation/PsiFileSystemItemNavigationTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystemItem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLink";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

