/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.model.navigation;

import com.intellij.model.Pointer;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.LinkableNavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.TargetLocation;

public final class PsiElementNavigationTarget<T extends PsiElement>
implements LinkableNavigationTarget {
    private static final Function<? super PsiElement, ? extends TextRange> NO_RANGE_SUPPLIER = __ -> TextRange.EMPTY_RANGE;
    private final T myElement;
    private final Function<? super T, ? extends TextRange> myRangeInElementSupplier;
    private final TargetLocation myLocation;
    private final TargetPresentation myPresentation;
    @Nullable
    private TextAttributes myLinkTextAttributes;

    public PsiElementNavigationTarget(@NotNull T element, @NotNull TargetPresentation presentation) {
        if (element == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(1);
        }
        this((PsiElement)element, (Function<? super PsiElement, TextRange>)NO_RANGE_SUPPLIER, TargetLocation.fromElement(element), presentation);
    }

    public PsiElementNavigationTarget(@NotNull T element, @NotNull Function<? super T, ? extends TextRange> rangeInElementSupplier, @NotNull TargetPresentation presentation) {
        if (element == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(2);
        }
        if (rangeInElementSupplier == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(3);
        }
        if (presentation == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(4);
        }
        this((T)element, (Function<? super T, TextRange>)rangeInElementSupplier, TargetLocation.fromElement(element), presentation);
    }

    public PsiElementNavigationTarget(@NotNull T element, @NotNull Function<? super T, ? extends TextRange> rangeInElementSupplier, @NotNull TargetLocation location, @NotNull TargetPresentation presentation) {
        if (element == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(5);
        }
        if (rangeInElementSupplier == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(6);
        }
        if (location == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(7);
        }
        if (presentation == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(8);
        }
        this.myElement = element;
        this.myRangeInElementSupplier = rangeInElementSupplier;
        this.myLocation = location;
        this.myPresentation = presentation;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = this.myPresentation;
        if (targetPresentation == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(9);
        }
        return targetPresentation;
    }

    @NotNull
    public Pointer<PsiElementNavigationTarget<T>> createPointer() {
        Function rangeInElementSupplier = this.myRangeInElementSupplier;
        TargetLocation location = this.myLocation;
        TargetPresentation presentation = this.myPresentation;
        TextAttributes linkTextAttributes = this.myLinkTextAttributes;
        Pointer pointer = Pointer.delegatingPointer((Pointer)SmartPointerManager.createPointer(this.myElement), element -> {
            PsiElementNavigationTarget<PsiElement> target = new PsiElementNavigationTarget<PsiElement>((PsiElement)element, rangeInElementSupplier, location, presentation);
            target.setLinkTextAttributes(linkTextAttributes);
            return target;
        });
        if (pointer == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(10);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.myElement.equals(((PsiElementNavigationTarget)obj).myElement);
    }

    @NotNull
    public T getElement() {
        T t = this.myElement;
        if (t == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(11);
        }
        return t;
    }

    @Override
    @NotNull
    public String getLink() {
        VirtualFile file = Objects.requireNonNull(PsiUtilCore.getVirtualFile(this.myElement));
        int offset = this.myElement.getTextRange().getStartOffset() + this.myRangeInElementSupplier.apply(this.myElement).getStartOffset();
        String string = "#navigation/%s:%d".formatted(file.getPath(), offset);
        if (string == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @Nullable
    public TextAttributes getLinkTextAttributes() {
        return this.myLinkTextAttributes;
    }

    @Override
    @NotNull
    public Navigatable getNavigatable() {
        Project project = this.myElement.getProject();
        VirtualFile file = Objects.requireNonNull(PsiUtilCore.getVirtualFile(this.myElement));
        int offset = this.myElement.getTextRange().getStartOffset() + this.myRangeInElementSupplier.apply(this.myElement).getStartOffset();
        return new OpenFileDescriptor(project, file, offset);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    @Override
    @NotNull
    public TargetLocation location() {
        TargetLocation targetLocation = this.myLocation;
        if (targetLocation == null) {
            PsiElementNavigationTarget.$$$reportNull$$$0(13);
        }
        return targetLocation;
    }

    @Override
    @Nullable
    public NavigationRequest navigationRequest() {
        PsiFile file = this.myElement.getContainingFile();
        TextRange range = this.myRangeInElementSupplier.apply(this.myElement).shiftRight(this.myElement.getTextRange().getStartOffset());
        return NavigationRequest.sourceNavigationRequest((PsiFile)file, (TextRange)range);
    }

    public void setLinkTextAttributes(@Nullable TextAttributes attributes) {
        this.myLinkTextAttributes = attributes;
    }

    public void setLinkTextAttributes(@Nullable TextAttributesKey attributesKey) {
        this.myLinkTextAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElementSupplier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/model/navigation/PsiElementNavigationTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/model/navigation/PsiElementNavigationTarget";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLink";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

